<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile ValueSet
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:ValueSet</sch:title>
    <sch:rule context="f:ValueSet">
      <sch:assert test="count(f:url) &gt;= 1">url: minimum cardinality of 'url' is 1</sch:assert>
      <sch:assert test="count(f:version) &gt;= 1">version: minimum cardinality of 'version' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:publisher) &lt;= 0">publisher: maximum cardinality of 'publisher' is 0</sch:assert>
      <sch:assert test="count(f:contact) &lt;= 0">contact: maximum cardinality of 'contact' is 0</sch:assert>
      <sch:assert test="count(f:useContext) &lt;= 0">useContext: maximum cardinality of 'useContext' is 0</sch:assert>
      <sch:assert test="count(f:immutable) &lt;= 0">immutable: maximum cardinality of 'immutable' is 0</sch:assert>
      <sch:assert test="count(f:purpose) &lt;= 0">purpose: maximum cardinality of 'purpose' is 0</sch:assert>
      <sch:assert test="count(f:compose) &gt;= 1">compose: minimum cardinality of 'compose' is 1</sch:assert>
      <sch:assert test="count(f:expansion) &lt;= 0">expansion: maximum cardinality of 'expansion' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ValueSet/f:compose</sch:title>
    <sch:rule context="f:ValueSet/f:compose">
      <sch:assert test="count(f:lockedDate) &lt;= 0">lockedDate: maximum cardinality of 'lockedDate' is 0</sch:assert>
      <sch:assert test="count(f:inactive) &lt;= 0">inactive: maximum cardinality of 'inactive' is 0</sch:assert>
      <sch:assert test="count(f:exclude) &lt;= 0">exclude: maximum cardinality of 'exclude' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ValueSet/f:compose/f:include</sch:title>
    <sch:rule context="f:ValueSet/f:compose/f:include">
      <sch:assert test="count(f:system) &gt;= 1">system: minimum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:concept) &gt;= 1">concept: minimum cardinality of 'concept' is 1</sch:assert>
      <sch:assert test="count(f:filter) &lt;= 0">filter: maximum cardinality of 'filter' is 0</sch:assert>
      <sch:assert test="count(f:valueSet) &lt;= 0">valueSet: maximum cardinality of 'valueSet' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ValueSet/f:compose/f:include/f:concept</sch:title>
    <sch:rule context="f:ValueSet/f:compose/f:include/f:concept">
      <sch:assert test="count(f:display) &gt;= 1">display: minimum cardinality of 'display' is 1</sch:assert>
      <sch:assert test="count(f:designation) &lt;= 0">designation: maximum cardinality of 'designation' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
