<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile DeviceDefinition
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:DeviceDefinition</sch:title>
    <sch:rule context="f:DeviceDefinition">
      <sch:assert test="count(f:identifier) &lt;= 0">identifier: maximum cardinality of 'identifier' is 0</sch:assert>
      <sch:assert test="count(f:udiDeviceIdentifier) &lt;= 1">udiDeviceIdentifier: maximum cardinality of 'udiDeviceIdentifier' is 1</sch:assert>
      <sch:assert test="count(f:manufacturer[x]) &gt;= 1">manufacturer[x]: minimum cardinality of 'manufacturer[x]' is 1</sch:assert>
      <sch:assert test="count(f:deviceName) &lt;= 0">deviceName: maximum cardinality of 'deviceName' is 0</sch:assert>
      <sch:assert test="count(f:modelNumber) &gt;= 1">modelNumber: minimum cardinality of 'modelNumber' is 1</sch:assert>
      <sch:assert test="count(f:specialization) &lt;= 0">specialization: maximum cardinality of 'specialization' is 0</sch:assert>
      <sch:assert test="count(f:version) &lt;= 0">version: maximum cardinality of 'version' is 0</sch:assert>
      <sch:assert test="count(f:safety) &lt;= 0">safety: maximum cardinality of 'safety' is 0</sch:assert>
      <sch:assert test="count(f:shelfLifeStorage) &lt;= 0">shelfLifeStorage: maximum cardinality of 'shelfLifeStorage' is 0</sch:assert>
      <sch:assert test="count(f:physicalCharacteristics) &lt;= 0">physicalCharacteristics: maximum cardinality of 'physicalCharacteristics' is 0</sch:assert>
      <sch:assert test="count(f:languageCode) &lt;= 0">languageCode: maximum cardinality of 'languageCode' is 0</sch:assert>
      <sch:assert test="count(f:capability) &gt;= 1">capability: minimum cardinality of 'capability' is 1</sch:assert>
      <sch:assert test="count(f:property) &lt;= 0">property: maximum cardinality of 'property' is 0</sch:assert>
      <sch:assert test="count(f:owner) &lt;= 0">owner: maximum cardinality of 'owner' is 0</sch:assert>
      <sch:assert test="count(f:contact) &lt;= 0">contact: maximum cardinality of 'contact' is 0</sch:assert>
      <sch:assert test="count(f:url) &lt;= 0">url: maximum cardinality of 'url' is 0</sch:assert>
      <sch:assert test="count(f:onlineInformation) &lt;= 0">onlineInformation: maximum cardinality of 'onlineInformation' is 0</sch:assert>
      <sch:assert test="count(f:note) &lt;= 0">note: maximum cardinality of 'note' is 0</sch:assert>
      <sch:assert test="count(f:quantity) &lt;= 0">quantity: maximum cardinality of 'quantity' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:DeviceDefinition/f:capability</sch:title>
    <sch:rule context="f:DeviceDefinition/f:capability">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/livd/StructureDefinition/ext-analyte']) &gt;= 1">extension with URL = 'http://hl7.org/fhir/uv/livd/StructureDefinition/ext-analyte': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:description) &lt;= 0">description: maximum cardinality of 'description' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
