<!-- input/pagecontent/downloads.md -->



### Package File

The following package file includes an NPM package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and URLs in the IG, etc., defined as part of this version of the Implementation Guides. This file should be the first choice whenever generating any implementation artifacts since it contains all the rules about what makes the profiles valid. Implementers will still need to be familiar with the specification content and profiles that apply to make a conformant implementation. For more information, see the [validating profiles and resources]({{site.data.fhir.path}}validation.html) documentation in FHIR.

- [Package(compressed folder)](package.tgz){::download="true"}

  
### Downloadable Copy of Specification

A downloadable version of this IG for local hosting is available:

- [Downloadable Copy](full-ig.zip)

### Examples

All the examples in this Implementation Guide are available for download:

- [XML(compressed folder)](examples.xml.zip)
- [JSON(compressed folder)](examples.json.zip)



### Implementation Guide Details
The following link to the [ImplementationGuide]({{site.data.fhir.path}}implementationguide.html) resource defines the technical details of this publication, including dependencies and publishing parameters:

- [IPA ImplementationGuide Resource](ImplementationGuide-hl7.fhir.uv.ipa.html)

### OpenAPI (a.k.a., Swagger) Definition Files

 The following [OpenAPI](https://www.openapis.org/) files are generated from the IPA CapabilityStatements:

- [IPA Server](ipa-server.openapi.json)
- [IPA Client](ipa-client.openapi.json)

