<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile AdverseEvent
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:AdverseEvent</sch:title>
    <sch:rule context="f:AdverseEvent">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/research-subject-ref']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/research-subject-ref': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/caused-subject-to-discontinue-study']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/caused-subject-to-discontinue-study': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/ae-grade']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/ae-grade': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/expected-in-research-study']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/expected-in-research-study': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/resolve-date']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-backport-ig/StructureDefinition/resolve-date': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:event) &gt;= 1">event: minimum cardinality of 'event' is 1</sch:assert>
      <sch:assert test="count(f:resultingCondition) &lt;= 0">resultingCondition: maximum cardinality of 'resultingCondition' is 0</sch:assert>
      <sch:assert test="count(f:seriousness) &gt;= 1">seriousness: minimum cardinality of 'seriousness' is 1</sch:assert>
      <sch:assert test="count(f:outcome) &gt;= 1">outcome: minimum cardinality of 'outcome' is 1</sch:assert>
      <sch:assert test="count(f:suspectEntity) &lt;= 0">suspectEntity: maximum cardinality of 'suspectEntity' is 0</sch:assert>
      <sch:assert test="count(f:subjectMedicalHistory) &lt;= 0">subjectMedicalHistory: maximum cardinality of 'subjectMedicalHistory' is 0</sch:assert>
      <sch:assert test="count(f:referenceDocument) &lt;= 0">referenceDocument: maximum cardinality of 'referenceDocument' is 0</sch:assert>
      <sch:assert test="count(f:study) &gt;= 1">study: minimum cardinality of 'study' is 1</sch:assert>
      <sch:assert test="count(f:study) &lt;= 1">study: maximum cardinality of 'study' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
