# hl7.fhir.us.davinci-vbpr#1.1.0: Da Vinci Value-Based Performance Reporting Implementation Guide

## Pages

* [IG Home](index.md)
* [Examples](examples.md)
* [Extensions](extensions.md)
* [Search Parameters](search-parameters.md)
* [Terminology](terminology.md)
* [Reading this IG](fhir.md)
* [Privacy, Safety, and Security](security.md)
* [Profiles](profiles.md)
* [Change Log](change-log.md)
* [Conformance Expectations](conformance.md)
* [Use Cases](usecase.md)
* [Glossary](glossary.md)
* [Projects and Participants](credits.md)
* [Capability Statements](capabilities.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [Guidance](guidance.md)

## Resources

### CodeSystems

* [HCPLAN Framework Categories Codes](CodeSystem-hcplan-framework.md)
* [Measure Contractual Status Codes](CodeSystem-measure-contractual-status.md)
* [Measure Stratifier Example Codes](CodeSystem-measure-stratifier-example.md)
* [Payment Stream Codes](CodeSystem-payment-stream.md)
* [Threshold Type Codes](CodeSystem-threshold-type.md)
* [Cohort Codes](CodeSystem-vbp-cohort.md)
* [Incentive Payment Codes](CodeSystem-vbp-incentive.md)
* [Value-Based Performance Measure Population Type Codes](CodeSystem-vbp-measure-population.md)
* [Performance Metric Codes](CodeSystem-vbp-performance-metric.md)

### ValueSets

* [HCPLAN Framework Categories](ValueSet-hcplan-framework.md)
* [Line of Business Value Set](ValueSet-lob.md)
* [Measure Contractual Status](ValueSet-measure-contractual-status.md)
* [Measure Stratifier Example](ValueSet-measure-stratifier-example.md)
* [Threshold Type](ValueSet-threshold-type.md)
* [Cohort](ValueSet-vbp-cohort.md)
* [Incentive](ValueSet-vbp-incentive.md)
* [VBP Measure Population Type](ValueSet-vbp-measure-population.md)
* [Payment Stream Value Set](ValueSet-vbp-payment-stream.md)
* [Performance Metric](ValueSet-vbp-performance-metric.md)

### Resource Profiles

* [Value-Based Performance Measure](StructureDefinition-vbp-measure.md)
* [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)
* [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)

### Extensions

* [Alternate Measure Score](StructureDefinition-alternate-measurescore.md)
* [Baseline](StructureDefinition-baseline.md)
* [Contractual Status](StructureDefinition-contractual-status.md)
* [Group Reference](StructureDefinition-group-reference.md)
* [Line of Business](StructureDefinition-lob.md)
* [Paid Through Date](StructureDefinition-paid-through-date.md)
* [Payment Stream](StructureDefinition-payment-stream.md)
* [Program Model](StructureDefinition-program-model.md)
* [Score](StructureDefinition-score.md)
* [Service Period](StructureDefinition-service-period.md)
* [Threshold](StructureDefinition-threshold.md)
* [Weight](StructureDefinition-weight.md)

### CapabilityStatements

* [VBP Reporting Client Capability Statement](CapabilityStatement-vbp-reporting-client.md)
* [VBP Reporting Server Capability Statement](CapabilityStatement-vbp-reporting-server.md)

### ImplementationGuides

* [Da Vinci Value-Based Performance Reporting Implementation Guide](index.md)

### SearchParameters

* [MeasureReportCategory](SearchParameter-measurereport-category.md)

### Examples

* [Every Hospital ATR Group (Group)](Group-everyhospital-group.md)
* [Good Health Clinic ATR Group (Group)](Group-goodhealth-group.md)
* [Example Value-Based Contract - ABC Payer and GoodHealth (Measure)](Measure-vbp-measure01.md)
* [Example Value-Based Contract - ABC Payer and EveryHospital (Measure)](Measure-vbp-measure02.md)
* [quality-measurereport01 (MeasureReport)](MeasureReport-quality-measurereport01.md)
* [quality-measurereport02 (MeasureReport)](MeasureReport-quality-measurereport02.md)
* [quality-measurereport03 (MeasureReport)](MeasureReport-quality-measurereport03.md)
* [quality-measurereport04 (MeasureReport)](MeasureReport-quality-measurereport04.md)
* [quality-measurereport05 (MeasureReport)](MeasureReport-quality-measurereport05.md)
* [quality-measurereport06 (MeasureReport)](MeasureReport-quality-measurereport06.md)
* [quality-measurereport07 (MeasureReport)](MeasureReport-quality-measurereport07.md)
* [quality-measurereport08 (MeasureReport)](MeasureReport-quality-measurereport08.md)
* [quality-measurereport09 (MeasureReport)](MeasureReport-quality-measurereport09.md)
* [quality-measurereport11 (MeasureReport)](MeasureReport-quality-measurereport11.md)
* [quality-measurereport12 (MeasureReport)](MeasureReport-quality-measurereport12.md)
* [quality-measurereport13 (MeasureReport)](MeasureReport-quality-measurereport13.md)
* [quality-measurereport14 (MeasureReport)](MeasureReport-quality-measurereport14.md)
* [quality-measurereport15 (MeasureReport)](MeasureReport-quality-measurereport15.md)
* [quality-measurereport20 (MeasureReport)](MeasureReport-quality-measurereport20.md)
* [quality-measurereport21 (MeasureReport)](MeasureReport-quality-measurereport21.md)
* [quality-measurereport22 (MeasureReport)](MeasureReport-quality-measurereport22.md)
* [quality-measurereport23 (MeasureReport)](MeasureReport-quality-measurereport23.md)
* [quality-measurereport24 (MeasureReport)](MeasureReport-quality-measurereport24.md)
* [quality-measurereport25 (MeasureReport)](MeasureReport-quality-measurereport25.md)
* [quality-measurereport30 (MeasureReport)](MeasureReport-quality-measurereport30.md)
* [quality-measurereport31 (MeasureReport)](MeasureReport-quality-measurereport31.md)
* [quality-measurereport32 (MeasureReport)](MeasureReport-quality-measurereport32.md)
* [quality-measurereport33 (MeasureReport)](MeasureReport-quality-measurereport33.md)
* [vbp-measurereport101 (MeasureReport)](MeasureReport-vbp-measurereport101.md)
* [vbp-measurereport102 (MeasureReport)](MeasureReport-vbp-measurereport102.md)
* [vbp-measurereport103 (MeasureReport)](MeasureReport-vbp-measurereport103.md)
* [vbp-measurereport104 (MeasureReport)](MeasureReport-vbp-measurereport104.md)
* [ABC Payer (Organization)](Organization-vbp-payer01.md)
* [Good Health Clinic (Organization)](Organization-vbp-provider01.md)
* [Every Hospital (Organization)](Organization-vbp-provider02.md)
