# IG Home - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **IG Home**

## IG Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr | *Version*:1.1.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ValueBasedPerformanceReporting |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30 | | |

### Summary

The Da Vinci Fast Healthcare Interoperability Resource (FHIR) Value-Based Performance Reporting (VBPR) Implementation Guide supports exchanging financial and quality performance data based on contractual performance measurements agreed to by payers and providers.

Value-based contracting offers the following benefits to the US healthcare system:

* Encourages providers to focus on quality outcomes and efficiency
* Helps to reduce wasteful healthcare spending and improve the affordability of healthcare for individuals, employers, and the government
* Promotes cost containment by incentivizing providers to improve the quality of care, rather than just providing more services
* Has shown to lead to better health outcomes for patients and improved patient satisfaction
* Promotes innovation in healthcare delivery and payment models, which can help drive improvements in healthcare quality, efficiency, and affordability

Reporting performance against the specific details of a contract may include financial, quality, utilization, etc. over defined time periods. This timely performance reporting provides the needed transparency required at the point of care and is essential to the success of value-based contracts for both payers and providers.

The first Standard for Trial Use (STU) version of this implementation guide focuses on the standard exchange format of value-based financial and quality performance reports for payers to providers. It may also benefit both providers and payers by reducing the administrative burden to providers by standardizing the reporting they receive across all payers.

This implementation guide is supported by the Da Vinci initiative which is a private effort to accelerate the adoption of Health Level Seven International Fast Healthcare Interoperability Resources (HL7® FHIR®) as the standard to support and integrate value-based care data exchange across communities. Like all Da Vinci Implementation Guides, it follows the [HL7 Da Vinci Guiding Principles](https://confluence.hl7.org/display/DVP/Da+Vinci+Clinical+Advisory+Council+Members?preview=/66940155/66942916/Guiding%20Principles%20for%20Da%20Vinci%20Implementation%20Guides.pdf) for exchange of patient health information. As an HL7 FHIR Implementation Guide, changes to this specification are managed by the sponsoring [Clinical Quality Information (CQI) Work Group](http://www.hl7.org/Special/committees/cqi/overview.cfm) and are incorporated as part of the standard balloting process.

### Content and Organization

This implementation guide is divided into several pages which are listed at the top of each page in the menu bar:

* [IG Home](index.md): The home page provides the summary, background information, scope, and actors for this implementation guide.
* FHIR Artifacts: These pages lists FHIR artifacts specified in this implementation guide. 
* [Profiles and Extensions](artifacts.md#structures-resource-profiles): This page lists the set of Profiles and Extensions that are defined in this implementation guide.
* [Terminology](artifacts.md#terminology-value-sets): This page lists code systems and value sets defined in this implementation guide.
* [Capability Statements](artifacts.md#behavior-capability-statements): This page describes the expected FHIR capabilities of this implementation guide.
 
* [Examples](examples.md): This page lists all the examples used in this implementation guide.
* [Glossary](glossary.md): This page lists glossary and acronyms for this implementation guide.
* [Downloads](downloads.md): This page provides links to downloadable artifacts.

### Dependencies

At present, the VBPR IG is based on [FHIR R4](http://hl7.org/fhir/R4/). In addition, this guide also relies on a number of parent implementation guides:

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AlternateMeasureScore](StructureDefinition-alternate-measurescore.md), [Baseline](StructureDefinition-baseline.md)...Show 38 more,[ContractualStatus](StructureDefinition-contractual-status.md),[GroupReference](StructureDefinition-group-reference.md),[HCPLANFrameworkCS](CodeSystem-hcplan-framework.md),[HCPLANFrameworkVS](ValueSet-hcplan-framework.md),[LOB](StructureDefinition-lob.md),[LineOfBusinessVS](ValueSet-lob.md),[MeasureContratualStatusCS](CodeSystem-measure-contractual-status.md),[MeasureContratualStatusVS](ValueSet-measure-contractual-status.md),[MeasureReportCategory](SearchParameter-measurereport-category.md),[MeasureStratifierExampleCS](CodeSystem-measure-stratifier-example.md),[MeasureStratifierExampleVS](ValueSet-measure-stratifier-example.md),[PaidThroughDate](StructureDefinition-paid-through-date.md),[PaymentStream](StructureDefinition-payment-stream.md),[PaymentStreamCS](CodeSystem-payment-stream.md),[PaymentStreamVS](ValueSet-vbp-payment-stream.md),[ProgramModel](StructureDefinition-program-model.md),[Score](StructureDefinition-score.md),[ServicePeriod](StructureDefinition-service-period.md),[Threshold](StructureDefinition-threshold.md),[ThresholdTypeCS](CodeSystem-threshold-type.md),[ThresholdTypeVS](ValueSet-threshold-type.md),[VBPCohortVS](ValueSet-vbp-cohort.md),[VBPIncentiveVS](ValueSet-vbp-incentive.md),[VBPRMeasurePopulationVS](ValueSet-vbp-measure-population.md),[VBPReportingClientCapabilityStatement](CapabilityStatement-vbp-reporting-client.md),[VBPReportingServerCapabilityStatement](CapabilityStatement-vbp-reporting-server.md),[ValueBasedPerformanceReporting](index.md),[VbpCohortCS](CodeSystem-vbp-cohort.md),[VbpIncentiveCS](CodeSystem-vbp-incentive.md),[VbpMeasure](StructureDefinition-vbp-measure.md),[VbpMeasurePopulationTypeCS](CodeSystem-vbp-measure-population.md),[VbpMeasureReport](StructureDefinition-vbp-performance-measurereport.md),[VbpPerformanceMetricsCS](CodeSystem-vbp-performance-metric.md),[VbpPerformanceMetricsVS](ValueSet-vbp-performance-metric.md),[VbpQualityMeasureReport](StructureDefinition-vbp-quality-measurereport.md),[VbprMeasureExample01](Measure-vbp-measure01.md),[VbprMeasureExample02](Measure-vbp-measure02.md)and[Weight](StructureDefinition-weight.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 25 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md),[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md),[MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md),[MeasureReport/vbp-measurereport102](MeasureReport-vbp-measurereport102.md)and[MeasureReport/vbp-measurereport104](MeasureReport-vbp-measurereport104.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 8 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md)and[MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [MeasureImprovementNotation](http://terminology.hl7.org/6.5.0/CodeSystem-measure-improvement-notation.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 22 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* [Measure Population Type](http://terminology.hl7.org/6.5.0/CodeSystem-measure-population.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 8 more,[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[VBPRMeasurePopulationVS](ValueSet-vbp-measure-population.md)and[VbpQualityMeasureReport](StructureDefinition-vbp-quality-measurereport.md)
* [Measure Scoring](http://terminology.hl7.org/6.5.0/CodeSystem-measure-scoring.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 22 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [ABC Payer](Organization-vbp-payer01.md), [Every Hospital](Organization-vbp-provider02.md) and [Good Health Clinic](Organization-vbp-provider01.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 7 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md)and[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md)


-------

