# Reading this IG - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Reading this IG**

## Reading this IG

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This implementation guide uses terminology, notations and design principles that are specific to FHIR. Before reading this implementation guide, it is important to be familiar with some of the basic principles of FHIR as well as general guidance on how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to read (or at least skim) the following prior to reading the rest of this implementation guide.

* [FHIR overview](http://hl7.org/fhir/R4/overview.html)
* [Developer's introduction](http://hl7.org/fhir/R4/overview-dev.html) (or [Clinical introduction](http://hl7.org/fhir/R4/overview-clinical.html))
* [FHIR data types](http://hl7.org/fhir/R4/datatypes.html)
* [Using codes](http://hl7.org/fhir/R4/terminologies.html)
* [References between resources](http://hl7.org/fhir/R4/references.html)
* [How to read resource & profile definitions](http://hl7.org/fhir/R4/formats.html) and additional [IG reading guidance](https://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html)
* [Base resource](http://hl7.org/fhir/R4/resource.html)

This implementation guide supports the [R4](http://hl7.org/fhir/R4/index.html) version of the FHIR standard.

* A complete list of the FHIR resources in the core specification can be found [here](http://hl7.org/fhir/R4/resourcelist.html).

This implementation guide utilizes the following profiles. Implementers therefore need to familiarize themselves with those profiles as well.

* profiles from the [US Core 6.1 (FHIR R4)]() implementation guide,
* the [DEQM Summary MeasureReport](https://hl7.org/fhir/us/davinci-deqm/StructureDefinition-summary-measurereport-deqm.html) profile from the [Da Vinci Data Exchange for Quality Measures (DEQM)](http://hl7.org/fhir/us/davinci-deqm/ImplementationGuide/hl7.fhir.us.davinci-deqm) implementation guide STU5.0.0, and
* the [CRMI Sharable Measure](https://hl7.org/fhir/uv/crmi/StructureDefinition-crmi-shareablemeasure.html) profile from the [Canonical Resource Management Infrastructure (CRMI)](https://hl7.org/fhir/uv/crmi/) (CRMI) implementation Guide STU1.0.0.

The table below lists the resources profiled or otherwise used in this specification. Implementers should review the general descriptions and usage notes for these resources for additional implementation guidance.

| | |
| :--- | :--- |
| [CapabilityStatement](http://hl7.org/fhir/R4/capabilitystatement.html) | Used to define conformance expectations for this guide |
| [CodeSystem](http://hl7.org/fhir/R4/codesystem.html) | Used to define custom codes specific to this guide |
| [Measure](http://hl7.org/fhir/R4/measure.html) |  |
| [MeasureReport](http://hl7.org/fhir/R4/measurereport.html) | Used for value-based performance reports and for quality measure reports. |
| [Group](http://hl7.org/fhir/R4/group.html) | Used to represent the MeasureReport subject being a group. |
| [Organization](http://hl7.org/fhir/R4/organization.html) | Used to represent the organization who the report is for or the reporter of the report |
| [SearchParameter](http://hl7.org/fhir/R4/searchparameter.html) | Used in defining additional search parameters used by this IG |
| [StructureDefinition](http://hl7.org/fhir/R4/structuredefinition.html) | Used when defining profiles and extensions in this guide |
| [ValueSet](http://hl7.org/fhir/R4/valueset.html) | Used to define a list of codes used by VBPR profiles and extensions |

