# Artifacts Summary - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [VBP Reporting Client Capability Statement](CapabilityStatement-vbp-reporting-client.md) | This profile defines the expected capabilities of the Value-Based Performance (VBP) Reporting Client actor, when request and consume value-based performance MeasureReports from a Value-Based Performance Reporting Server. The complete list of FHIR profiles that a VBP Reporting Server could support are defined. VBP Reporting Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |
| [VBP Reporting Server Capability Statement](CapabilityStatement-vbp-reporting-server.md) | This profile defines the expected capabilities of the Value-Based Performance (VBP) Reporting Server actor which is responsible for producing value-based performance MeasureReports to be consumed by a Value-Based Performance Reporting Client. The complete list of FHIR profiles and search parameters that a VBP Reporting Server could support are defined. VBP Reporting Servers have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [measurereport-category](SearchParameter-measurereport-category.md) | Search based on the measurereport-category extension |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md) | VBP quality measure report at the summary level for a population. This profile is derived from the Data Exchange for Quality Measure IG's DEQM Summary MeasureReport. |
| [Value-Based Performance Measure](StructureDefinition-vbp-measure.md) | The measure definition that describes value-based contract level information for a value-based performance report. |
| [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md) | Value-Based Performance MeasureReport is a payer-generated performance report against the specific details (metrics) of a value-based contract (VBC) or a value-based purchasing (VBP) which may include financial, quality, utilization, etc. over a time period. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Alternate Measure Score](StructureDefinition-alternate-measurescore.md) | The Alternate Measure Score Extension allows other data type choices to be used for the measureScore element in addition to Quantity. The alternate data type for measure score is determined by the performance metric type. |
| [Baseline](StructureDefinition-baseline.md) | The Baseline Extension is a complex extension. It is used to state the baseline that the performance metric is used for comparisons. |
| [Contractual Status](StructureDefinition-contractual-status.md) | Contractual status of a measure whether it is tied to payment as specified in a value-based contract. |
| [Group Reference](StructureDefinition-group-reference.md) | Reference to a group within the MeasureReport. |
| [Line of Business](StructureDefinition-lob.md) | The Line of Business (LOB) Extension is used to indicate whether the value-based contract is for Medicare, Medicaid, or commercial (private insurance). |
| [Paid Through Date](StructureDefinition-paid-through-date.md) | Paid through date is the ending date of the pay cycle. |
| [Payment Stream](StructureDefinition-payment-stream.md) | The Payment Stream Extension is a complex extension that defines the type of payment stream. A value-based contract may contain different types of payment streams, such as quality incentive payment and care coordination fee. |
| [Program Model](StructureDefinition-program-model.md) | The Program Model Extension is a complex extension, which defines the The Health Care Payment Learning & Action Network (HCPLAN) Alternative Payment Model (APM) framework specified APM categories and which cohort this program model applies to. |
| [Score](StructureDefinition-score.md) | The Score Extension is used to specify the score of a measure, such as star score. |
| [Service Period](StructureDefinition-service-period.md) | The Service period for a payment stream. |
| [Threshold](StructureDefinition-threshold.md) | The Threshold Extension is a complex extension that defines a threshold needed to be met when measuring performance. |
| [Weight](StructureDefinition-weight.md) | What is the weight of the contribution of this measure to the overall performance score specified by a value-based contract. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Cohort](ValueSet-vbp-cohort.md) | Cohort types. |
| [HCPLAN Framework Categories](ValueSet-hcplan-framework.md) | HCPLAN framework categories for value-based performance. HCPLAN framework represents payments from public and private payers to provider organizations. |
| [Incentive](ValueSet-vbp-incentive.md) | What type of incentive. |
| [Line of Business Value Set](ValueSet-lob.md) | Type of line of business. |
| [Measure Contractual Status](ValueSet-measure-contractual-status.md) | Contractual status of a measure as specified in a value-based contract. |
| [Measure Stratifier Example](ValueSet-measure-stratifier-example.md) | Example stratifiers that could be used to stratify measure or performance metrics. |
| [Payment Stream Value Set](ValueSet-vbp-payment-stream.md) | Type of payment stream. |
| [Performance Metric](ValueSet-vbp-performance-metric.md) | Type of value-based performance reporting performance metric. |
| [Threshold Type](ValueSet-threshold-type.md) | The threshold type. |
| [VBP Measure Population Type](ValueSet-vbp-measure-population.md) | Measure population type that includes calculated-denominator and calculated-numerator. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Cohort Codes](CodeSystem-vbp-cohort.md) | The type of cohort, which represents a group of members with a shared characteristic. |
| [HCPLAN Framework Categories Codes](CodeSystem-hcplan-framework.md) | HCPLAN Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer. Although payments will be classified in discrete categories, the Framework captures a continuum of clinical and financial risk for provider organizations. |
| [Incentive Payment Codes](CodeSystem-vbp-incentive.md) | What type of incentive for a payment stream such as quality incentive payment. |
| [Measure Contractual Status Codes](CodeSystem-measure-contractual-status.md) | Contractual status whether a measure is tied to payment as specified in a value-based contract. |
| [Measure Stratifier Example Codes](CodeSystem-measure-stratifier-example.md) | Example stratifiers that could be used to stratify measure or performance metrics. |
| [Payment Stream Codes](CodeSystem-payment-stream.md) | Payment stream defined in a value-based contract. A value-based contract may contain multiple payment streams. |
| [Performance Metric Codes](CodeSystem-vbp-performance-metric.md) | Type of value-based performance metrics. |
| [Threshold Type Codes](CodeSystem-threshold-type.md) | The threshold type. |
| [Value-Based Performance Measure Population Type Codes](CodeSystem-vbp-measure-population.md) | Measure population type that includes calculated-denominator and calculated-numerator. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Every Hospital ATR Group](Group-everyhospital-group.md) | Example Member Attribution List (ATR Group) for ABC Payer and Every Hospital Value-Based Contract. |
| [Example Value-Based Contract - ABC Payer and EveryHospital](Measure-vbp-measure02.md) | This is an example measure for the**VBP Measure**profile. |
| [Example Value-Based Contract - ABC Payer and GoodHealth](Measure-vbp-measure01.md) | This is an example measure for the**VBP Measure**profile. |
| [Good Health Clinic ATR Group](Group-goodhealth-group.md) | Example Member Attribution List (ATR Group) for ABC Payer and Good Health Clinic Value-Based Contract. |
| [quality-measurereport01](MeasureReport-quality-measurereport01.md) | This is an example Breast Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport02](MeasureReport-quality-measurereport02.md) | This is an example Colorectal Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport03](MeasureReport-quality-measurereport03.md) | This is an example Diabetes Care - Blood Sugar Controlled MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport04](MeasureReport-quality-measurereport04.md) | This is an example Diabetes Care - Eye Exam MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport05](MeasureReport-quality-measurereport05.md) | This is an example Medication Adherence for Cholesterol (Statins) MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport06](MeasureReport-quality-measurereport06.md) | This is an example Medication Adherence for Hypertension (RAS antagonists) MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport07](MeasureReport-quality-measurereport07.md) | This is an example Medication Adherence for Diabetes Medications MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport08](MeasureReport-quality-measurereport08.md) | This is an example Statin Therapy for Patients with Cardiovascular Disease MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport09](MeasureReport-quality-measurereport09.md) | This is an example Statin Use in Persons with Diabetes (SUPD) MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport11](MeasureReport-quality-measurereport11.md) | This is an example Breast Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport12](MeasureReport-quality-measurereport12.md) | This is an example Colorectal Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport13](MeasureReport-quality-measurereport13.md) | This is an example Diabetic Retinopathy: Communication with the Physician Managing Ongoing Diabetes Care MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport14](MeasureReport-quality-measurereport14.md) | This is an example Diabetes: Hemoglobin A1c (HbA1c) Poor Control (> 9%) MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport15](MeasureReport-quality-measurereport15.md) | This is an example Diabetes: Medical Attention for Nephropathy MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport20](MeasureReport-quality-measurereport20.md) | This is an example Breast Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport21](MeasureReport-quality-measurereport21.md) | This is an example Colorectal Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport22](MeasureReport-quality-measurereport22.md) | This is an example Comprehensive Diabetes Care: Hemoglobin A1c (HbA1c) Control (<8.0%) MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport23](MeasureReport-quality-measurereport23.md) | This is an example Controlling High Blood Pressure MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport24](MeasureReport-quality-measurereport24.md) | This is an example Plan All-Cause Readmissions MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport25](MeasureReport-quality-measurereport25.md) | This is an example Member Satisfaction Survey MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport30](MeasureReport-quality-measurereport30.md) | This is an example Breast Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport31](MeasureReport-quality-measurereport31.md) | This is an example Colorectal Cancer Screening MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport32](MeasureReport-quality-measurereport32.md) | This is an example Diabetes Care - Blood Sugar Controlled MeasureReport for the**VBP Quality MeasureReport**profile. |
| [quality-measurereport33](MeasureReport-quality-measurereport33.md) | This is an example Diabetes Care - Eye Exam MeasureReport for the**VBP Quality MeasureReport**profile. |
| [vbp-measurereport101](MeasureReport-vbp-measurereport101.md) | This is an example Value-Based Performance MeasureReport for the**VBP MeasureReport**profile., which includes examples for payment streams shared savings - gated on quality, care coordination fee, quality incentive payment for the chronic care management incentive program, and quality incentive payment for the annual office visits. |
| [vbp-measurereport102](MeasureReport-vbp-measurereport102.md) | This is an example Value-Based Performance MeasureReport for the**VBP MeasureReport**profile., which includes utilizations and quality. |
| [vbp-measurereport103](MeasureReport-vbp-measurereport103.md) | This is an example Value-Based Performance MeasureReport for the**VBP MeasureReport**profile., which includes quality measures and alternative measures. |
| [vbp-measurereport104](MeasureReport-vbp-measurereport104.md) | This is an example Value-Based Performance MeasureReport for the**VBP MeasureReport**profile. |
| [vbp-payer01](Organization-vbp-payer01.md) | This is an example payer |
| [vbp-provider01](Organization-vbp-provider01.md) | This is an example of Provider organization the Value-Based Performance Report is for. |
| [vbp-provider02](Organization-vbp-provider02.md) | This is an example of Provider organization the Value-Based Performance Report is for. |

