# VBP Quality MeasureReport - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **VBP Quality MeasureReport**

## Resource Profile: VBP Quality MeasureReport 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:VbpQualityMeasureReport |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.42.15 | | |

 
VBP quality measure report at the summary level for a population. This profile is derived from the Data Exchange for Quality Measure IG's DEQM Summary MeasureReport. 

The Value-Based Performance (VBP) Quality MeasureReport derives from the [DEQM Susmmary MeasureReport](http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/summary-measurereport-deqm).

The [Formal Views](StructureDefinition-vbp-quality-measurereport.md#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Value-Based Performance Measure has the following mandatory elements:**

1. A`measurereport-category`- with a fixed code`vbp`
1. A`url`- a canonical identifier for this measure (value-based contract)
1. A`version`- version of the measure (value-based contract)
1. A`name`- a computer friendly name for this measure (value-based contract)
1. A`status`- status of this measure, which would often be`active`
1. An`experimental`element - set to`true`if for testing
1. A`publisher`- name of the publisher for this measure (value-based contract)
1. A`description`- description of the measure (value-based contract)

**Each Value-Based Performance Measure should have the following elements:**

1. Zero to many`identifier`- business identifier of the measure (value-based contract)
1. Zero to one`title`- a human friendly title for this measure (value-based contract)
1. Zero to one`effectivePeriod`- effective period of the measure, which is the contract term period for a value-based contract
1. Zero to one`lineOfBusiness`- line of business for the measure (value-based contract)
1. Zero to many`paymentStream`- list of payment streams covered in the measure (value-based contract)
1. Zeor to one`programModel`- program model for the measure (value-based contract) based on the HPCLAN Framework
1. Zero to many`group.code`- list of performance metrics that could be reported on the measure (value-based contract)
1. zero to many`relatedArtifact`- list of quality measures specified in the value-based contract that ties to the payment stream based on quality measures
1. zeor to one`relatedArtifact.weight`for each relatedArtifact - the weight of a quality measure that contributes to the scoring

**Usages:**

* Refer to this Profile: [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)
* Examples for this Profile: [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md), [MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md), [MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md)...Show 20 more,[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* CapabilityStatements using this Profile: [VBP Reporting Client Capability Statement](CapabilityStatement-vbp-reporting-client.md) and [VBP Reporting Server Capability Statement](CapabilityStatement-vbp-reporting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-vbpr|current/StructureDefinition/vbp-quality-measurereport)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-vbp-quality-measurereport.csv), [Excel](StructureDefinition-vbp-quality-measurereport.xlsx), [Schematron](StructureDefinition-vbp-quality-measurereport.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "vbp-quality-measurereport",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.42.15"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbpQualityMeasureReport",
  "title" : "VBP Quality MeasureReport",
  "status" : "active",
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "VBP quality measure report at the summary level for a population. This profile is derived from the Data Exchange for Quality Measure IG's DEQM Summary MeasureReport.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MeasureReport",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/summary-measurereport-deqm",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MeasureReport",
        "path" : "MeasureReport"
      },
      {
        "id" : "MeasureReport.extension:score",
        "path" : "MeasureReport.extension",
        "sliceName" : "score",
        "short" : "Score of a measure, such as star rating score",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.extension:threshold",
        "path" : "MeasureReport.extension",
        "sliceName" : "threshold",
        "short" : "Threshold needed to be met when measuring performance",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.population.code",
        "path" : "MeasureReport.group.population.code",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/vbp-measure-population"
        }
      },
      {
        "id" : "MeasureReport.group.stratifier.code",
        "path" : "MeasureReport.group.stratifier.code",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/measure-stratifier-example"
        }
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.extension",
        "path" : "MeasureReport.group.stratifier.stratum.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.extension:score",
        "path" : "MeasureReport.group.stratifier.stratum.extension",
        "sliceName" : "score",
        "short" : "What score such as star rating score this stratum achieved",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.component.code",
        "path" : "MeasureReport.group.stratifier.stratum.component.code",
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/measure-stratifier-example"
        }
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.component.value",
        "path" : "MeasureReport.group.stratifier.stratum.component.value",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.population.code",
        "path" : "MeasureReport.group.stratifier.stratum.population.code",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/vbp-measure-population"
        }
      }
    ]
  }
}

```
