# Value-Based Performance Measure - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Value-Based Performance Measure**

## Resource Profile: Value-Based Performance Measure 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:VbpMeasure |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.42.13 | | |

 
The measure definition that describes value-based contract level information for a value-based performance report. 

The [Formal Views](StructureDefinition-vbp-measure.md#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Value-Based Performance Measure has the following mandatory elements:**

1. A`url`- a canonical identifier for this measure (value-based contract)
1. A`version`- version of the measure (value-based contract)
1. A`name`- a computer friendly name for this measure (value-based contract)
1. A`status`- status of this measure
1. An`experimental`element - set to`true`if for testing
1. A`publisher`- name of the publisher for this measure (value-based contract)
1. A`description`- description of the measure (value-based contract)

**Each Value-Based Performance Measure should have the following elements:**

1. Zero to many`identifier`- business identifier of the measure (value-based contract)
1. Zero to one`title`- a human friendly title for this measure (value-based contract)
1. Zero to one`effectivePeriod`- effective period of the measure, which is the contract term period for a value-based contract
1. Zero to one`lineOfBusiness`- line of business for the measure (value-based contract)
1. Zero to many`paymentStream`- list of payment streams covered in the measure (value-based contract)
1. Zeor to one`programModel`- program model for the measure (value-based contract) based on the HPCLAN Framework
1. Zero to many`group.code`- list of performance metrics that could be reported on the measure (value-based contract)
1. zero to many`relatedArtifact`- list of quality measures specified in the value-based contract that ties to the payment stream based on quality measures
1. zero to one`relatedArtifact.weight`for each relatedArtifact - the weight of a quality measure that contributes to the scoring

**Usages:**

* Refer to this Profile: [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)
* Examples for this Profile: [VbprMeasureExample01](Measure-vbp-measure01.md) and [VbprMeasureExample02](Measure-vbp-measure02.md)
* CapabilityStatements using this Profile: [VBP Reporting Client Capability Statement](CapabilityStatement-vbp-reporting-client.md) and [VBP Reporting Server Capability Statement](CapabilityStatement-vbp-reporting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-vbpr|current/StructureDefinition/vbp-measure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-vbp-measure.csv), [Excel](StructureDefinition-vbp-measure.xlsx), [Schematron](StructureDefinition-vbp-measure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "vbp-measure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.42.13"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbpMeasure",
  "title" : "Value-Based Performance Measure",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The measure definition that describes value-based contract level information for a value-based performance report.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Measure",
  "baseDefinition" : "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-shareablemeasure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Measure",
        "path" : "Measure"
      },
      {
        "id" : "Measure.extension:lineOfBusiness",
        "path" : "Measure.extension",
        "sliceName" : "lineOfBusiness",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/lob"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Measure.extension:programModel",
        "path" : "Measure.extension",
        "sliceName" : "programModel",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/program-model"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Measure.extension:paymentStream",
        "path" : "Measure.extension",
        "sliceName" : "paymentStream",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Measure.identifier",
        "path" : "Measure.identifier",
        "short" : "Business identifier of this measure, e.g., value-based contract identifier",
        "mustSupport" : true
      },
      {
        "id" : "Measure.effectivePeriod",
        "path" : "Measure.effectivePeriod",
        "short" : "Value-based contract term period",
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact",
        "path" : "Measure.relatedArtifact",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact:component",
        "path" : "Measure.relatedArtifact",
        "sliceName" : "component",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact:component.extension",
        "path" : "Measure.relatedArtifact.extension",
        "min" : 1
      },
      {
        "id" : "Measure.relatedArtifact:component.extension:weight",
        "path" : "Measure.relatedArtifact.extension",
        "sliceName" : "weight",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact:component.extension:contractualStatus",
        "path" : "Measure.relatedArtifact.extension",
        "sliceName" : "contractualStatus",
        "short" : "contractual | contractual-alternate | reporting-only",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact:component.type",
        "path" : "Measure.relatedArtifact.type",
        "short" : "Component measure",
        "definition" : "A component of the composite measure.",
        "fixedCode" : "composed-of",
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact:component.display",
        "path" : "Measure.relatedArtifact.display",
        "mustSupport" : true
      },
      {
        "id" : "Measure.relatedArtifact:component.resource",
        "path" : "Measure.relatedArtifact.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Measure"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Measure.scoring",
        "path" : "Measure.scoring",
        "max" : "0"
      },
      {
        "id" : "Measure.compositeScoring",
        "path" : "Measure.compositeScoring",
        "max" : "0"
      },
      {
        "id" : "Measure.improvementNotation",
        "path" : "Measure.improvementNotation",
        "max" : "0"
      },
      {
        "id" : "Measure.group",
        "path" : "Measure.group",
        "mustSupport" : true
      },
      {
        "id" : "Measure.group.code",
        "path" : "Measure.group.code",
        "short" : "Performance metric",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/vbp-performance-metric"
        }
      }
    ]
  }
}

```
