# Payment Stream - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Payment Stream**

## Extension: Payment Stream 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PaymentStream |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.42.8 | | |

The Payment Stream Extension is a complex extension that defines the type of payment stream. A value-based contract may contain different types of payment streams, such as quality incentive payment and care coordination fee.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Value-Based Performance Measure](StructureDefinition-vbp-measure.md) and [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)
* Examples for this Extension: [VbprMeasureExample01](Measure-vbp-measure01.md), [VbprMeasureExample02](Measure-vbp-measure02.md), [MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md) and [MeasureReport/vbp-measurereport102](MeasureReport-vbp-measurereport102.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-vbpr|current/StructureDefinition/payment-stream)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-payment-stream.csv), [Excel](StructureDefinition-payment-stream.xlsx), [Schematron](StructureDefinition-payment-stream.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "payment-stream",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.42.8"
    }
  ],
  "version" : "1.1.0",
  "name" : "PaymentStream",
  "title" : "Payment Stream",
  "status" : "active",
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The Payment Stream Extension is a complex extension that defines the type of payment stream. A value-based contract may contain different types of payment streams, such as quality incentive payment and care coordination fee.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MeasureReport"
    },
    {
      "type" : "element",
      "expression" : "MeasureReport.group"
    },
    {
      "type" : "element",
      "expression" : "Measure"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Payment Stream",
        "definition" : "The Payment Stream Extension is a complex extension that defines the type of payment stream. A value-based contract may contain different types of payment streams, such as quality incentive payment and care coordination fee."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 1
      },
      {
        "id" : "Extension.extension:type",
        "path" : "Extension.extension",
        "sliceName" : "type",
        "short" : "The type of payment stream",
        "definition" : "The type of payment stream, such as quality incentive payment and care coordination fee.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:type.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:type.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "type"
      },
      {
        "id" : "Extension.extension:type.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/vbp-payment-stream"
        }
      },
      {
        "id" : "Extension.extension:incentive",
        "path" : "Extension.extension",
        "sliceName" : "incentive",
        "short" : "For quality incentive payment, what type of incentive",
        "definition" : "For quality incentive payment, what type of incentive",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:incentive.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:incentive.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "incentive"
      },
      {
        "id" : "Extension.extension:incentive.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/vbp-incentive"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
