# vbp-provider01 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-provider01**

## Example Organization: vbp-provider01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Davinci ATR Organization](http://hl7.org/fhir/us/davinci-atr/STU2.1/StructureDefinition-atr-organization.html)

**active**: true

**type**: Healthcare Provider

**name**: Good Health Clinic

**telecom**: ph: (+1) 123-456-7890, [contact@goodhealth.com](mailto:contact@goodhealth.com)

**address**: 100 Good Health Lane Amherst MA 01002 USA 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "vbp-provider01",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Provider"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "Provider organization the Value-Based Performance Report is for."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/atr-organization"
    ]
  },
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov",
          "display" : "Healthcare Provider"
        }
      ]
    }
  ],
  "name" : "Good Health Clinic",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 123-456-7890"
    },
    {
      "system" : "email",
      "value" : "contact@goodhealth.com"
    }
  ],
  "address" : [
    {
      "line" : ["100 Good Health Lane"],
      "city" : "Amherst",
      "state" : "MA",
      "postalCode" : "01002",
      "country" : "USA"
    }
  ]
}

```
