# vbp-payer01 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-payer01**

## Example Organization: vbp-payer01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Organization Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

**active**: true

**type**: payer

**name**: ABC Payer

**telecom**: ph: (+1) 800-123-4567, [contact@ABCPayer.com](mailto:contact@ABCPayer.com)

**address**: 100 ABC Payer Lane Amherst MA 01002 USA 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "vbp-payer01",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Payer"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example payer."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0"
    ]
  },
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "pay",
          "display" : "payer"
        }
      ]
    }
  ],
  "name" : "ABC Payer",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 800-123-4567"
    },
    {
      "system" : "email",
      "value" : "contact@ABCPayer.com"
    }
  ],
  "address" : [
    {
      "line" : ["100 ABC Payer Lane"],
      "city" : "Amherst",
      "state" : "MA",
      "postalCode" : "01002",
      "country" : "USA"
    }
  ]
}

```
