# vbp-measurereport103 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-measurereport103**

## Example MeasureReport: vbp-measurereport103

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)

**Measure Report Category**: Value-Based Performance

**status**: Complete

**type**: Summary

**measure**: [Example Value-Based Contract - ABC Payer and EveryHospital](Measure-vbp-measure02.md)

**subject**: [Every Hospital](Group-everyhospital-group.md)

**date**: 2022-12-31

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2020-01-01 --> 2021-03-31

**evaluatedResource**: 

* [MeasureReport: extension = Proportion,2,,,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport20.md)
* [MeasureReport: extension = Proportion,0,,,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport21.md)
* [MeasureReport: extension = Proportion,2,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-HbA1c|1.0.000; date = 2021-04-02; period = 2020-01-01 --> 2021-03-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport22.md)
* [MeasureReport: extension = Proportion,1,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-HbA1c|1.0.000; date = 2021-04-02; period = 2020-01-01 --> 2021-03-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport23.md)
* [MeasureReport: extension = Proportion,2,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-HbA1c|1.0.000; date = 2021-04-02; period = 2020-01-01 --> 2021-03-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport24.md)
* [MeasureReport: extension = Proportion,3,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-HbA1c|1.0.000; date = 2021-04-02; period = 2020-01-01 --> 2021-03-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport25.md)



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "vbp-measurereport103",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP MeasureReport Example 103"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile., which includes quality measures and alternative measures."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
            "code" : "vbp"
          }
        ]
      }
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure02",
  "subject" : {
    "reference" : "Group/everyhospital-group",
    "display" : "Every Hospital"
  },
  "date" : "2022-12-31",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2020-01-01",
    "end" : "2021-03-31"
  },
  "evaluatedResource" : [
    {
      "reference" : "MeasureReport/quality-measurereport20"
    },
    {
      "reference" : "MeasureReport/quality-measurereport21"
    },
    {
      "reference" : "MeasureReport/quality-measurereport22"
    },
    {
      "reference" : "MeasureReport/quality-measurereport23"
    },
    {
      "reference" : "MeasureReport/quality-measurereport24"
    },
    {
      "reference" : "MeasureReport/quality-measurereport25"
    }
  ]
}

```
