# vbp-measurereport102 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-measurereport102**

## Example MeasureReport: vbp-measurereport102

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)

**Measure Report Category**: Value-Based Performance

**status**: Complete

**type**: Summary

**measure**: [Example Value-Based Contract - ABC Payer and EveryHospital](Measure-vbp-measure02.md)

**subject**: [Every Hospital](Group-everyhospital-group.md)

**date**: 2022-12-31

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-10-01 --> 2022-12-31

> **group**
> **id**ubip-group-01

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: 250 /10*3(Details: UCUM code/10*3 = '/10*3')
* period: 2021-01-01 --> 2021-12-31

**code**:In patient admission**measureScore**: 400 /10*3(Details: UCUM code/10*3 = '/10*3')

> **group**
> **id**ubip-group-02

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: 180 /10*3(Details: UCUM code/10*3 = '/10*3')
* period: 2021-01-01 --> 2021-12-31

**code**:In patient acute**measureScore**: 350 /10*3(Details: UCUM code/10*3 = '/10*3')

> **group**
> **id**ubip-group-03

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: 51 /10*3(Details: UCUM code/10*3 = '/10*3')
* period: 2021-01-01 --> 2021-12-31

**code**:Readmission**measureScore**: 120 /10*3(Details: UCUM code/10*3 = '/10*3')

> **group**
> **id**ubip-group-04

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: 350 per 100(Details: UCUM code/100 = '/100')
* period: 2021-01-01 --> 2021-12-31

**code**:ED visit**measureScore**: 300 /100(Details: UCUM code/100 = '/100')

> **group**
> **id**ubip-group-05

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: 51 /10*3(Details: UCUM code/10*3 = '/10*3')
* period: 2021-01-01 --> 2021-12-31

**code**:Skilled Nursing Facility admission**measureScore**: 50 /10*3(Details: UCUM code/10*3 = '/10*3')

> **group**
> **id**ubip-group-06

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: 22 d(Details: UCUM coded = 'd')
* period: 2021-01-01 --> 2021-12-31

**code**:Skilled Nursing Facility average length of stay**measureScore**: 15 d(Details: UCUM coded = 'd')

> **group**
> **id**ssq-group-starscore

> **Payment Stream**
* type: Shared savings gated on quality

**code**:Weighted average star**measureScore**: 2.5

> **group**
> **id**financial-group-01

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: $800.00 (USD)
* period: 2021-01-01 --> 2021-12-31

**code**:Total medical expense PMPM**measureScore**:

> **group**
> **id**financial-group-02

> **Payment Stream**
* type: Utilization incentive payment

> **Baseline**
* baseline: $800.00 (USD)
* period: 2021-01-01 --> 2021-12-31

**code**:Total medical expense PMPM**measureScore**:

**evaluatedResource**: 

* [MeasureReport: extension = Proportion,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport11.md)
* [MeasureReport: extension = Proportion,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport12.md)
* [MeasureReport: extension = Proportion,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-retinopathy-FHIR|1.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport13.md)
* [MeasureReport: extension = Proportion,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-A1c-FHIR|1.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport14.md)
* [MeasureReport: extension = Proportion,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-nephropathy-FHIR|1.0.000; date = 2022-12-31; period = 2022-10-01 --> 2022-12-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport15.md)



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "vbp-measurereport102",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP MeasureReport Example 102"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile., which includes utilization and quality."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
            "code" : "vbp"
          }
        ]
      }
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure02",
  "subject" : {
    "reference" : "Group/everyhospital-group",
    "display" : "Every Hospital"
  },
  "date" : "2022-12-31",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-10-01",
    "end" : "2022-12-31"
  },
  "group" : [
    {
      "id" : "ubip-group-01",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueQuantity" : {
                "value" : 250,
                "system" : "http://unitsofmeasure.org",
                "code" : "/10*3"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "inpatient-admission"
          }
        ],
        "text" : "In patient admission"
      },
      "measureScore" : {
        "value" : 400,
        "system" : "http://unitsofmeasure.org",
        "code" : "/10*3"
      }
    },
    {
      "id" : "ubip-group-02",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueQuantity" : {
                "value" : 180,
                "system" : "http://unitsofmeasure.org",
                "code" : "/10*3"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "inpatient-acute"
          }
        ],
        "text" : "In patient acute"
      },
      "measureScore" : {
        "value" : 350,
        "system" : "http://unitsofmeasure.org",
        "code" : "/10*3"
      }
    },
    {
      "id" : "ubip-group-03",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueQuantity" : {
                "value" : 51,
                "system" : "http://unitsofmeasure.org",
                "code" : "/10*3"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "readmission"
          }
        ],
        "text" : "Readmission"
      },
      "measureScore" : {
        "value" : 120,
        "system" : "http://unitsofmeasure.org",
        "code" : "/10*3"
      }
    },
    {
      "id" : "ubip-group-04",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueQuantity" : {
                "value" : 350,
                "unit" : "per 100",
                "system" : "http://unitsofmeasure.org",
                "code" : "/100"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "ed-visit"
          }
        ],
        "text" : "ED visit"
      },
      "measureScore" : {
        "value" : 300,
        "system" : "http://unitsofmeasure.org",
        "code" : "/100"
      }
    },
    {
      "id" : "ubip-group-05",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueQuantity" : {
                "value" : 51,
                "system" : "http://unitsofmeasure.org",
                "code" : "/10*3"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "snf-admission"
          }
        ],
        "text" : "Skilled Nursing Facility admission"
      },
      "measureScore" : {
        "value" : 50,
        "system" : "http://unitsofmeasure.org",
        "code" : "/10*3"
      }
    },
    {
      "id" : "ubip-group-06",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueQuantity" : {
                "value" : 22,
                "system" : "http://unitsofmeasure.org",
                "code" : "d"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "snf-avg-los"
          }
        ],
        "text" : "Skilled Nursing Facility average length of stay"
      },
      "measureScore" : {
        "value" : 15,
        "system" : "http://unitsofmeasure.org",
        "code" : "d"
      }
    },
    {
      "id" : "ssq-group-starscore",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "weighted-avg-star"
          }
        ],
        "text" : "Weighted average star"
      },
      "measureScore" : {
        "value" : 2.5
      }
    },
    {
      "id" : "financial-group-01",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueMoney" : {
                "value" : 800,
                "currency" : "USD"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "med-cost-pmpm"
          }
        ],
        "text" : "Total medical expense PMPM"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 800,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "financial-group-02",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ubip"
                  }
                ],
                "text" : "Utilization incentive payment"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "extension" : [
            {
              "url" : "baseline",
              "valueMoney" : {
                "value" : 800,
                "currency" : "USD"
              }
            },
            {
              "url" : "period",
              "valuePeriod" : {
                "start" : "2021-01-01",
                "end" : "2021-12-31"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "ibnr-pmpm"
          }
        ],
        "text" : "Total medical expense PMPM"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 800,
              "currency" : "USD"
            }
          }
        ]
      }
    }
  ],
  "evaluatedResource" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport11"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport12"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport13"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport14"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport15"
    }
  ]
}

```
