# quality-measurereport23 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **quality-measurereport23**

## Example MeasureReport: quality-measurereport23

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Information Source: [http://example.org/fhir/server](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/fhir/server)

Profile: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)

**DEQM Measure Scoring Extension**: Proportion

**Score**: 1

> **Threshold**
* threshold: 55 %(Details: UCUM code% = '%')
* type: HEDIS 50 Percentile

> **Threshold**
* threshold: 62 %(Details: UCUM code% = '%')
* type: HEDIS 75 Percentile

> **Threshold**
* threshold: 72 %(Details: UCUM code% = '%')
* type: HEDIS 90 Percentile

**status**: Complete

**type**: Summary

**measure**: [http://example.org/Measure/measure-diabetes-HbA1c|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-diabetes-HbA1c|1.0.000)

**date**: 2021-04-02

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2020-01-01 --> 2021-03-31

**improvementNotation**: Increased score indicates improvement

> **group**
> **population**
> **id**pop1-num
**code**:Calculated Numerator**count**: 27

> **population**
> **id**pop2-denom
**code**:Calculated Denominator**count**: 49
**measureScore**: 0.551



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "quality-measurereport23",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP Quality MeasureReport Example"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Controlling High Blood Pressure MeasureReport for the *VBP Quality MeasureReport* profile."
      }
    ],
    "source" : "http://example.org/fhir/server",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
            "code" : "proportion"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score",
      "valueDecimal" : 1
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 55,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "hedis-50-percentile"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 62,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "hedis-75-percentile"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 72,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "hedis-90-percentile"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "http://example.org/Measure/measure-diabetes-HbA1c|1.0.000",
  "date" : "2021-04-02",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2020-01-01",
    "end" : "2021-03-31"
  },
  "improvementNotation" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
        "code" : "increase",
        "display" : "Increased score indicates improvement"
      }
    ]
  },
  "group" : [
    {
      "population" : [
        {
          "id" : "pop1-num",
          "code" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                "code" : "calculated-numerator"
              }
            ]
          },
          "count" : 27
        },
        {
          "id" : "pop2-denom",
          "code" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                "code" : "calculated-denominator"
              }
            ]
          },
          "count" : 49
        }
      ],
      "measureScore" : {
        "value" : 0.551
      }
    }
  ]
}

```
