# quality-measurereport06 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **quality-measurereport06**

## Example MeasureReport: quality-measurereport06

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Information Source: [http://example.org/fhir/server](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/fhir/server)

Profile: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)

**DEQM Measure Scoring Extension**: Proportion

**Score**: 0

> **Threshold**
* threshold: 80 %(Details: UCUM code% = '%')
* type: Star 2

> **Threshold**
* threshold: 85 %(Details: UCUM code% = '%')
* type: Star 3

> **Threshold**
* threshold: 90 %(Details: UCUM code% = '%')
* type: Star 4

> **Threshold**
* threshold: 93 %(Details: UCUM code% = '%')
* type: Star 5

**status**: Complete

**type**: Summary

**measure**: [http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000)

**date**: 2023-01-15

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-01-01 --> 2022-11-30

**improvementNotation**: Increased score indicates improvement

> **group**
> **population**
> **id**pop1
**code**:Calculated Numerator**count**: 100

> **population**
> **id**pop2
**code**:Calculated Denominator**count**: 380
**measureScore**: 0.263
> **stratifier**
> **stratum**
> **component****code**:Coverage type**value**:health maintenance organization policy

> **component****code**:location**value**:Region 1

> **population**
> **id**strat-pop1
**code**:Calculated Numerator**count**: 30

> **population**
> **id**strat-pop2
**code**:Calculated Denominator**count**: 50
**measureScore**: 0.6

> **stratum**
> **component****code**:Coverage type**value**:health maintenance organization policy

> **component****code**:location**value**:Region 2

> **population**
> **id**strat-pop3
**code**:Calculated Numerator**count**: 20

> **population**
> **id**strat-pop4
**code**:Calculated Denominator**count**: 140
**measureScore**: 0.14

> **stratum**
> **component****code**:Coverage type**value**:preferred provider organization policy

> **component****code**:location**value**:Region 1

> **population**
> **id**strat-pop5
**code**:Calculated Numerator**count**: 30

> **population**
> **id**strat-pop6
**code**:Calculated Denominator**count**: 50
**measureScore**: 0.6

> **stratum**
> **component****code**:Coverage type**value**:preferred provider organization policy

> **component****code**:location**value**:Region 2

> **population**
> **id**strat-pop7
**code**:Calculated Numerator**count**: 20

> **population**
> **id**strat-pop8
**code**:Calculated Denominator**count**: 140
**measureScore**: 0.14




## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "quality-measurereport06",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP Quality MeasureReport Example"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Medication Adherence for Hypertension (RAS antagonists) MeasureReport for the *VBP Quality MeasureReport* profile."
      }
    ],
    "source" : "http://example.org/fhir/server",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
            "code" : "proportion"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score",
      "valueDecimal" : 0
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 80,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-2"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 85,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-3"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 90,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-4"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 93,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-5"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000",
  "date" : "2023-01-15",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-01-01",
    "end" : "2022-11-30"
  },
  "improvementNotation" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
        "code" : "increase",
        "display" : "Increased score indicates improvement"
      }
    ]
  },
  "group" : [
    {
      "population" : [
        {
          "id" : "pop1",
          "code" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                "code" : "calculated-numerator"
              }
            ]
          },
          "count" : 100
        },
        {
          "id" : "pop2",
          "code" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                "code" : "calculated-denominator"
              }
            ]
          },
          "count" : 380
        }
      ],
      "measureScore" : {
        "value" : 0.263
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "HMO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop1",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-numerator"
                      }
                    ]
                  },
                  "count" : 30
                },
                {
                  "id" : "strat-pop2",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-denominator"
                      }
                    ]
                  },
                  "count" : 50
                }
              ],
              "measureScore" : {
                "value" : 0.6
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "HMO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop3",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-numerator"
                      }
                    ]
                  },
                  "count" : 20
                },
                {
                  "id" : "strat-pop4",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-denominator"
                      }
                    ]
                  },
                  "count" : 140
                }
              ],
              "measureScore" : {
                "value" : 0.14
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "PPO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop5",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-numerator"
                      }
                    ]
                  },
                  "count" : 30
                },
                {
                  "id" : "strat-pop6",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-denominator"
                      }
                    ]
                  },
                  "count" : 50
                }
              ],
              "measureScore" : {
                "value" : 0.6
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "PPO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop7",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-numerator"
                      }
                    ]
                  },
                  "count" : 20
                },
                {
                  "id" : "strat-pop8",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-measure-population",
                        "code" : "calculated-denominator"
                      }
                    ]
                  },
                  "count" : 140
                }
              ],
              "measureScore" : {
                "value" : 0.14
              }
            }
          ]
        }
      ]
    }
  ]
}

```
