# Every Hospital ATR Group - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Every Hospital ATR Group**

## Example Group: Every Hospital ATR Group

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2022-12-01 03:04:12-0400

Profile: [Davinci ATR Group](http://hl7.org/fhir/us/davinci-atr/STU2.1/StructureDefinition-atr-group.html)

**Contract Validity Period**: 2020-01-01 --> 2024-12-31

**Attribution List Status**: final

**identifier**: [United States Employer Identification Number](http://terminology.hl7.org/6.5.0/NamingSystem-USEIN.html)/789456231

**type**: Person

**actual**: true

**name**: Every Hospital ATR Group

**managingEntity**: [Every Hospital](Organization-vbp-provider02.md)



## Resource Content

```json
{
  "resourceType" : "Group",
  "id" : "everyhospital-group",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "Example Member Attribution List (ATR Group) for ABC Payer and Every Hospital Value-Based Contract."
      }
    ],
    "lastUpdated" : "2022-12-01T03:04:12.348-04:00",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/atr-group"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/ext-contractValidityPeriod",
      "valuePeriod" : {
        "start" : "2020-01-01",
        "end" : "2024-12-31"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/ext-attributionListStatus",
      "valueCode" : "final"
    }
  ],
  "identifier" : [
    {
      "system" : "urn:oid:2.16.840.1.113883.4.4",
      "value" : "789456231"
    }
  ],
  "type" : "person",
  "actual" : true,
  "name" : "Every Hospital ATR Group",
  "managingEntity" : {
    "reference" : "Organization/vbp-provider02",
    "display" : "Every Hospital"
  }
}

```
