# Measure Contractual Status Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Measure Contractual Status Codes**

## CodeSystem: Measure Contractual Status Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MeasureContratualStatusCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.2 | | |

 
Contractual status whether a measure is tied to payment as specified in a value-based contract. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureContratualStatusVS](ValueSet-measure-contractual-status.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-contractual-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.2"
    }
  ],
  "version" : "1.1.0",
  "name" : "MeasureContratualStatusCS",
  "title" : "Measure Contractual Status Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Contractual status whether a measure is tied to payment as specified in a value-based contract.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "contractual",
      "display" : "Contractual",
      "definition" : "Measure is tied to payment contractually."
    },
    {
      "code" : "contractual-alternate",
      "display" : "Contractual Alternate",
      "definition" : "Measure is identified as an alternate measure and is tied to payment contractually."
    },
    {
      "code" : "reporting-only",
      "display" : "Reporting Only",
      "definition" : "Measure is for reporting only, it is not tied to payment."
    }
  ]
}

```
