# HCPLAN Framework Categories Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HCPLAN Framework Categories Codes**

## CodeSystem: HCPLAN Framework Categories Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:HCPLANFrameworkCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.1 | | |

 
HCPLAN Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer. Although payments will be classified in discrete categories, the Framework captures a continuum of clinical and financial risk for provider organizations. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HCPLANFrameworkVS](ValueSet-hcplan-framework.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "hcplan-framework",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.1"
    }
  ],
  "version" : "1.1.0",
  "name" : "HCPLANFrameworkCS",
  "title" : "HCPLAN Framework Categories Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "HCPLAN Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer. Although payments will be classified in discrete categories, the Framework captures a continuum of clinical and financial risk for provider organizations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 10,
  "concept" : [
    {
      "code" : "2A",
      "display" : "Category 2A",
      "definition" : "Foundational Payments for Infrastructure and Operations, e.g., care coordination fees and payments for HIT investments."
    },
    {
      "code" : "2B",
      "display" : "Category 2B",
      "definition" : "Pay for Reporting, e.g., bonuses for reporting data or penalies for not reporting data."
    },
    {
      "code" : "2C",
      "display" : "Category 2C",
      "definition" : "Pay-for-Performance, e.g., bonuses for quality performance."
    },
    {
      "code" : "3A",
      "display" : "Category 3A",
      "definition" : "APMs with Shared Savings, e.g., shared savings with upside risk only."
    },
    {
      "code" : "3B",
      "display" : "Category 3B",
      "definition" : "APMs with Shared Savings and Downside Risk, e.g., episode-based payments for procedures and comprehensive payments with upside and downside risk."
    },
    {
      "code" : "3N",
      "display" : "Category 3N",
      "definition" : "Risk Based Payments not linked to quality."
    },
    {
      "code" : "4A",
      "display" : "Category 4A",
      "definition" : "Condition-Specific Population-Based Payment, e.g., per member per month payments, payments for speciality services, such as oncology or mental health."
    },
    {
      "code" : "4B",
      "display" : "Category 4B",
      "definition" : "Comprehensive Population-Based Payment, e.g., global budgets or full/percent of premium payments."
    },
    {
      "code" : "4C",
      "display" : "Category 4C",
      "definition" : "Integrated Finance and Delivery System, e.g., global budgets or full/percent of premium payments in integrated systems."
    },
    {
      "code" : "4N",
      "display" : "Category 4N",
      "definition" : "Capitated Payments not linked to quality."
    }
  ]
}

```
