# VBP Reporting Server Capability Statement - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **VBP Reporting Server Capability Statement**

## CapabilityStatement: VBP Reporting Server Capability Statement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CapabilityStatement/vbp-reporting-server | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:VBPReportingServerCapabilityStatement |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.13.2 | | |

 
This profile defines the expected capabilities of the Value-Based Performance (VBP) Reporting Server actor which is responsible for producing value-based performance MeasureReports to be consumed by a Value-Based Performance Reporting Client. The complete list of FHIR profiles and search parameters that a VBP Reporting Server could support are defined. VBP Reporting Servers have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. 

 [Raw OpenAPI-Swagger Definition file](vbp-reporting-server.openapi.json) | [Download](vbp-reporting-server.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "vbp-reporting-server",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CapabilityStatement/vbp-reporting-server",
  "version" : "1.1.0",
  "name" : "VBPReportingServerCapabilityStatement",
  "title" : "VBP Reporting Server Capability Statement",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-25",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This profile defines the expected capabilities of the Value-Based Performance (VBP) Reporting Server actor which is responsible for producing value-based performance MeasureReports to be consumed by a Value-Based Performance Reporting Client. The complete list of FHIR profiles \r\nand search parameters that a VBP Reporting Server could support are defined. VBP Reporting Servers have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/us/davinci-deqm/ImplementationGuide/hl7.fhir.us.davinci-deqm",
    "http://hl7.org/fhir/uv/crmi/ImplementationGuide/hl7.fhir.uv.crmi"
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "Da Vinci Value-Based Performance Reporting Server §SHALL§ support the profiles specified in this implementation guide.",
      "security" : {
        "description" : "For general security consideration refer to the [Security and Privacy Considerations](http://hl7.org/fhir/R4/secpriv-module.html)."
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Measure",
          "profile" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Read allows maintainers of the Measures to get the logical definitions of the Measure"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create",
              "documentation" : "Create allows maintainers of the Measures to create the logical definition of a Measure"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update",
              "documentation" : "Update allows maintainers of the Measures to update the logical definitions of a Measure by its id or create a new one if it is new"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "patch",
              "documentation" : "Patch allows maintainers of the Measures to update the logical definition of a Measure by posting a set of changes to it"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "delete",
              "documentation" : "Delete allows maintainers of the Measures to delete the logical definition of a Measure"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-instance"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type",
              "documentation" : "Search allows maintainers of the Measures to find the logical definition of a Measure"
            }
          ]
        },
        {
          "type" : "MeasureReport",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport",
            "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Read allows maintainers of the MeasureReports to get the logical definitions of the MeasureReports"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "vread"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create",
              "documentation" : "Create allows maintainers of the MeasureReports to create the logical definition of a MeasureReport"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update",
              "documentation" : "Update allows maintainers of the MeasureReports to update the logical definitions of a MeasureReport by its id or create a new one if it is new"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "patch",
              "documentation" : "Patch allows maintainers of the MeasureReports to update the logical definition of a MeasureReport by posting a set of changes to it"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "delete",
              "documentation" : "Delete allows maintainers of the MeasureReports to delete the logical definition of a MeasureReport"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-instance"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type",
              "documentation" : "Search allows maintainers of the MeasureReports to find the logical definition of a MeasureReport"
            }
          ],
          "conditionalCreate" : true,
          "conditionalUpdate" : true,
          "conditionalDelete" : "multiple",
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : ["MeasureReport.evaluatedResources"],
          "searchParam" : [
            {
              "name" : "date",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-date",
              "type" : "date"
            },
            {
              "name" : "evaluatedResource",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-evaluated-resource",
              "type" : "reference"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-identifier",
              "type" : "token"
            },
            {
              "name" : "measure",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-measure",
              "type" : "reference"
            },
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-patient",
              "type" : "reference"
            },
            {
              "name" : "period",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-period",
              "type" : "date"
            },
            {
              "name" : "reporter",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-reporter",
              "type" : "reference"
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-status",
              "type" : "token"
            },
            {
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-subject",
              "type" : "reference"
            },
            {
              "name" : "measurereport-category",
              "definition" : "http://hl7.org/fhir/us/davinci-vbpr/SearchParameter/measurereport-category",
              "type" : "token"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "code" : "batch"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "code" : "transaction"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "search-system"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "history-system"
        }
      ]
    }
  ]
}

```
