# Use Cases - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Use Cases**

## Use Cases

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Value-Based Performance Reporting

Value-Based Performance Reporting (VBPR) offers insights into the performance of healthcare providers and organizations by evaluating their financial, quality, cost, and efficiency aspects. These reports play a crucial role in assessing and comparing providers within value-based contracts. The objective of such contracts is to encourage superior care, enhance patient outcomes, and lower costs by compensating providers according to their performance, as opposed to the quantity of services provided.

Payer-generated performance reports are crucial because payers are generally the arbiters in determining financial performance on risk contracts with health systems. Many times, payers have the best source of information on Per Member Per Month (PMPM) spend, contractual terms, regional or historical trends, and other financial information that health systems need to track and manage performance on those contracts. Claims data is important but insufficient on its own because state and federal requirements mask certain types of data that make accurate financial calculations difficult.

#### Key Components of Value Based Performance (VBP) Reports

* **Performance Categories**: Distinct areas of provider performance, such as clinical quality, cost, utilization, and patient experience, which are evaluated and weighted to calculate an overall performance score.
* **Quality Measures**: Quantitative metrics that assess the performance of healthcare providers and organizations in terms of clinical outcomes, patient safety, patient experience, and adherence to clinical guidelines and best practices.
* **Performance Benchmarks**: Comparative metrics used to evaluate provider performance against established industry standards or the historic performance of peer organizations or clinician/organization's own performance over time.
* **Incentive Payments**: Financial rewards or penalties applied to providers based on their performance to encourage improvements in care quality and efficiency.
* **Risk Adjustment**: A methodology applied to account for differences in patient populations, such as demographic factors, clinical conditions, and social determinants of health, to ensure fair comparisons of provider performance.

Healthcare providers and participating organizations submit performance data, including quality measures, cost, and utilization metrics, to payers or other regulatory bodies for evaluation and analysis. There have been numerous value-based performance initiatives launched by both public and private payers, including accountable care organizations (ACOs), bundled payments, and pay-for-performance programs to name a few. These initiatives have continued to evolve and expand, with a growing emphasis on patient-centered care, population health management, and the use of data analytics to drive quality improvement and cost containment.

Value-based performance reports are generated by payers to summarize provider performance across different categories, including lines of business, contracts, populations, quality measures, and financial metrics and reporting periods on a scheduled and ad-hoc basis.

Based on the calculated performance scores, incentive payments are calculated and distributed to providers as rewards or penalties, encouraging continuous improvement in care quality and efficiency.

### HCPLAN APM Framework

[The Health Care Payment Learning & Action Network](https://www.cms.gov/priorities/innovation/health-care-payment-learning-and-action-network) (HCPLAN or LAN) is an active group of public and private health care leaders dedicated to providing thought leadership, strategic direction, and ongoing support to accelerate our care system’s adoption of alternative payment models (APMs). HCPLAN has defined several categories[1](https://hcp-lan.org/apm-framework/) that help to categorize the alternative payment models (APMs). These categories are intended to provide a framework for evaluating the complexity and risk associated with different APMs, and to help stakeholders understand the trade-offs between different payment models.

**Figure 1-1 HCPLAN APM Framework**
![](hcplan-apm-framework.jpg)

* **Category 1**: Fee-for-Service with No Link to Quality and Value: This level includes traditional fee-for-service payment models that do not provide incentives for quality improvement or cost containment. (Note that Category 1 is not addressed in this implementation guide).
* **Category 2**: Fee-for-Service with Links to Quality and Value: foundational payments for infrastructure and operations, pay for reporting, or pay-for-performance.
* **Category 3**: APMs built on fee-for-service architecture: This level includes payment models that focus on upside risk only or episode-based payment for procedures and comprehensive payments with upside and downside risk. This category also included risk-based payments NOT linked to quality.
* **Category 4**: Population-based Payment: Category 4 payment models involve prospective, population-based payments, structured in a manner that encourages providers to deliver well-coordinated, high-quality, person-centered care within either a defined scope of practice (4A), a comprehensive collection of care (4B), or a highly integrated finance and delivery system (4C). Category 4 APMs require accountability for measures of appropriate care to provide additional safeguards against incentives to limit necessary care. Absent this accountability, APMs that use prospective, population-based payments will be classified in Category 4N.

This level includes payment models where providers receive a fixed payment for a specific population, such as a patient panel, and are responsible for delivering all necessary care within that population. This category also includes global budgets or full/percent of premium payment and integrated finance and delivery system. This category also includes capitated payments not linked to quality.

While a framework is in place to identify the types of value-based agreements payers and providers can participate in, there is a challenge in collecting, analyzing and reconciling the numerous reports providers receive from payers. Some of these challenges include:

* Lack of standardizations for value-based performance reporting format
* Data is in unstructured formats
* Lack of common definitions, for example, Total Care Capitation (TCC) could have many different calculations
* Data retrieval is time intensive because of reports come from various portals and is not scalable
* Data is error-prone based on human error when entering into reporting systems
* Misalignment on time periods when data is shared, and care is delivered.
* Various reporting, payment, and reconciliation periods can make tracking performance across contractual measures difficult for providers to understand how well they are performing prior to various settlement dates.
* Variation in metrics used across payers and also variation in methodology – e.g., attribution.

### Value-Based Payment Models

Originally, value-based payment models were designed to reward healthcare providers with incentive payments for the quality of care they give to people with Medicare. The programs were designed to link provider performance of quality measures to provider payment and work with other CMS quality efforts to ensure that quality is being achieved. Value-based purchasing refers to a broad set of performance-based payment strategies that link financial incentives to providers' performance on a set of defined metrics and measures. Value-based purchasing programs are private or public programs that link financial reimbursement to performance on measures of quality (i.e., structure, process, outcomes, access, and patient experience) and cost or resource use.[1](https://www.rand.org/pubs/periodicals/health-quarterly/issues/v4/n3/09.html)

Economic challenges and higher healthcare costs have expanded these value-based payment models to larger populations of patients and members. The industry has adopted several names for the original value-based payment models, including value-based purchasing, value-based contracting, value-based payments, and, most recently, alternative payment models.

For the purpose of this implementation guide, any report that meets the definition of a value-based payment model, meaning a contract that links financial incentives to providers’ financial, quality, and risk performance on defined metrics and measures, will be considered a **value-based performance report**. Reporting performance against the specific details of a contract may include financial, quality, utilization, etc. over defined time periods.

In this implementation guide, we use the term metrics to refer to financial measures in the report, and the term quality measures or measures to refer to the quality measures such as the colorectal cancer screening measure.

### Preconditions and Assumptions

This following is a list of pre-requisites for using this implementation guide:

* Payer and Provider have value-based contract agreement in place 
* **Data agreed in a contract includes information such as program details, data aggregation period, reporting period, and attribution methods.**
 
* Payer and Provider have an established process for creating and reconciling member attribution list 
* **Creation and reconciliation of attributed member list is outside the scope of this implementation guide**
 
* Payer assembles administrative, clinical, quality, and claims data for attributed members
* Payer calculates population performance 
* **Calculating population performance is outside the scope of this implementation guide**
 
* Payer calculates incentive 
* **Calculating financial incentive is outside the scope of this implementation guide**
 
* Payer calculates performance based on contract terms 
* **Calculating performance is outside the scope of this implementation guide**
* **Performance helps determine incentives**
 
* Payer generates population level reports for providers 
* **Member-level performance is outside the scope of this implementation guide**
 
* Provider submits attributed member quality and risk adjustment data to Payer
* Payer and Provider has established security and privacy practices in place

### Actors

The actors involved in exchanging value-based performance reports are Clients and Servers.

* **Clients** are the actors requesting value-based performance reports.
* **Servers** are the actors receiving the request for retrieving the value-based performance reports. In the scenario where the Payer sends the value-based performance reports to the Provider, the Payer acts as the Server and the Provider acts as the Client.

### Scope

The goals of implementation guide are:

* Standardize the format of payer-generated value-based performance report and
* Exchange standardized payer-generated value-based performance report from payer to provider.

The initial phase of this implementation guide focuses on:

* Defining standardized data structure and data elements on value-based performance reports
* Identifying and defining common data elements in a value-based performance report
* Supporting both Medicare value-based contracts (Medicare Advantage) and commercial value-based contracts, and other types of value-based contracts such as Medicaid.

**Figure 1-2 Scope**
![](stu1_scope.png)

