# IG Home - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **IG Home**

## IG Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr | *Version*:1.1.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ValueBasedPerformanceReporting |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30 | | |

### Summary

The Da Vinci Fast Healthcare Interoperability Resource (FHIR) Value-Based Performance Reporting (VBPR) Implementation Guide supports exchanging financial and quality performance data based on contractual performance measurements agreed to by payers and providers.

Value-based contracting offers the following benefits to the US healthcare system:

* Encourages providers to focus on quality outcomes and efficiency
* Helps to reduce wasteful healthcare spending and improve the affordability of healthcare for individuals, employers, and the government
* Promotes cost containment by incentivizing providers to improve the quality of care, rather than just providing more services
* Has shown to lead to better health outcomes for patients and improved patient satisfaction
* Promotes innovation in healthcare delivery and payment models, which can help drive improvements in healthcare quality, efficiency, and affordability

Reporting performance against the specific details of a contract may include financial, quality, utilization, etc. over defined time periods. This timely performance reporting provides the needed transparency required at the point of care and is essential to the success of value-based contracts for both payers and providers.

The first Standard for Trial Use (STU) version of this implementation guide focuses on the standard exchange format of value-based financial and quality performance reports for payers to providers. It may also benefit both providers and payers by reducing the administrative burden to providers by standardizing the reporting they receive across all payers.

This implementation guide is supported by the Da Vinci initiative which is a private effort to accelerate the adoption of Health Level Seven International Fast Healthcare Interoperability Resources (HL7® FHIR®) as the standard to support and integrate value-based care data exchange across communities. Like all Da Vinci Implementation Guides, it follows the [HL7 Da Vinci Guiding Principles](https://confluence.hl7.org/display/DVP/Da+Vinci+Clinical+Advisory+Council+Members?preview=/66940155/66942916/Guiding%20Principles%20for%20Da%20Vinci%20Implementation%20Guides.pdf) for exchange of patient health information. As an HL7 FHIR Implementation Guide, changes to this specification are managed by the sponsoring [Clinical Quality Information (CQI) Work Group](http://www.hl7.org/Special/committees/cqi/overview.cfm) and are incorporated as part of the standard balloting process.

### Content and Organization

This implementation guide is divided into several pages which are listed at the top of each page in the menu bar:

* [IG Home](index.md): The home page provides the summary, background information, scope, and actors for this implementation guide.
* FHIR Artifacts: These pages lists FHIR artifacts specified in this implementation guide. 
* [Profiles and Extensions](artifacts.md#structures-resource-profiles): This page lists the set of Profiles and Extensions that are defined in this implementation guide.
* [Terminology](artifacts.md#terminology-value-sets): This page lists code systems and value sets defined in this implementation guide.
* [Capability Statements](artifacts.md#behavior-capability-statements): This page describes the expected FHIR capabilities of this implementation guide.
 
* [Examples](examples.md): This page lists all the examples used in this implementation guide.
* [Glossary](glossary.md): This page lists glossary and acronyms for this implementation guide.
* [Downloads](downloads.md): This page provides links to downloadable artifacts.

### Dependencies

At present, the VBPR IG is based on [FHIR R4](http://hl7.org/fhir/R4/). In addition, this guide also relies on a number of parent implementation guides:

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AlternateMeasureScore](StructureDefinition-alternate-measurescore.md), [Baseline](StructureDefinition-baseline.md)...Show 38 more,[ContractualStatus](StructureDefinition-contractual-status.md),[GroupReference](StructureDefinition-group-reference.md),[HCPLANFrameworkCS](CodeSystem-hcplan-framework.md),[HCPLANFrameworkVS](ValueSet-hcplan-framework.md),[LOB](StructureDefinition-lob.md),[LineOfBusinessVS](ValueSet-lob.md),[MeasureContratualStatusCS](CodeSystem-measure-contractual-status.md),[MeasureContratualStatusVS](ValueSet-measure-contractual-status.md),[MeasureReportCategory](SearchParameter-measurereport-category.md),[MeasureStratifierExampleCS](CodeSystem-measure-stratifier-example.md),[MeasureStratifierExampleVS](ValueSet-measure-stratifier-example.md),[PaidThroughDate](StructureDefinition-paid-through-date.md),[PaymentStream](StructureDefinition-payment-stream.md),[PaymentStreamCS](CodeSystem-payment-stream.md),[PaymentStreamVS](ValueSet-vbp-payment-stream.md),[ProgramModel](StructureDefinition-program-model.md),[Score](StructureDefinition-score.md),[ServicePeriod](StructureDefinition-service-period.md),[Threshold](StructureDefinition-threshold.md),[ThresholdTypeCS](CodeSystem-threshold-type.md),[ThresholdTypeVS](ValueSet-threshold-type.md),[VBPCohortVS](ValueSet-vbp-cohort.md),[VBPIncentiveVS](ValueSet-vbp-incentive.md),[VBPRMeasurePopulationVS](ValueSet-vbp-measure-population.md),[VBPReportingClientCapabilityStatement](CapabilityStatement-vbp-reporting-client.md),[VBPReportingServerCapabilityStatement](CapabilityStatement-vbp-reporting-server.md),[ValueBasedPerformanceReporting](index.md),[VbpCohortCS](CodeSystem-vbp-cohort.md),[VbpIncentiveCS](CodeSystem-vbp-incentive.md),[VbpMeasure](StructureDefinition-vbp-measure.md),[VbpMeasurePopulationTypeCS](CodeSystem-vbp-measure-population.md),[VbpMeasureReport](StructureDefinition-vbp-performance-measurereport.md),[VbpPerformanceMetricsCS](CodeSystem-vbp-performance-metric.md),[VbpPerformanceMetricsVS](ValueSet-vbp-performance-metric.md),[VbpQualityMeasureReport](StructureDefinition-vbp-quality-measurereport.md),[VbprMeasureExample01](Measure-vbp-measure01.md),[VbprMeasureExample02](Measure-vbp-measure02.md)and[Weight](StructureDefinition-weight.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 25 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md),[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md),[MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md),[MeasureReport/vbp-measurereport102](MeasureReport-vbp-measurereport102.md)and[MeasureReport/vbp-measurereport104](MeasureReport-vbp-measurereport104.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 8 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md)and[MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [MeasureImprovementNotation](http://terminology.hl7.org/6.5.0/CodeSystem-measure-improvement-notation.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 22 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* [Measure Population Type](http://terminology.hl7.org/6.5.0/CodeSystem-measure-population.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 8 more,[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[VBPRMeasurePopulationVS](ValueSet-vbp-measure-population.md)and[VbpQualityMeasureReport](StructureDefinition-vbp-quality-measurereport.md)
* [Measure Scoring](http://terminology.hl7.org/6.5.0/CodeSystem-measure-scoring.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 22 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [ABC Payer](Organization-vbp-payer01.md), [Every Hospital](Organization-vbp-provider02.md) and [Good Health Clinic](Organization-vbp-provider01.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 7 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md)and[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md)


-------



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.davinci-vbpr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr",
  "version" : "1.1.0",
  "name" : "ValueBasedPerformanceReporting",
  "title" : "Da Vinci Value-Based Performance Reporting Implementation Guide",
  "status" : "active",
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The Da Vinci Fast Healthcare Interoperability Resource (FHIR) Value-Based Performance Reporting Implementation Guide (this IG) specifies standard representations of value-based performance reports that are exchanged payers and providers, which include performance metrics on financial, utilization, etc. and quality measures for varies types of value-based contracts.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.us.davinci-vbpr",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "uscore",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v3     \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "6.1.0"
    },
    {
      "id" : "ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for the measurereport-category extension.  \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "deqm5",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed the USCore 6.1.0 based DEQM Summary MeasureReport profile   \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/davinci-deqm/ImplementationGuide/hl7.fhir.us.davinci-deqm",
      "packageId" : "hl7.fhir.us.davinci-deqm",
      "version" : "5.0.0"
    },
    {
      "id" : "atr",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Neede the ATR Group profile \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/davinci-atr/ImplementationGuide/hl7.fhir.us.davinci-atr",
      "packageId" : "hl7.fhir.us.davinci-atr",
      "version" : "2.1.0"
    },
    {
      "id" : "crmi",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed the CRMI Shareable Measure profile\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/uv/crmi/ImplementationGuide/hl7.fhir.uv.crmi",
      "packageId" : "hl7.fhir.uv.crmi",
      "version" : "1.0.0"
    },
    {
      "id" : "vsac",
      "uri" : "http://fhir.org/packages/us.nlm.vsac/ImplementationGuide/us.nlm.vsac",
      "packageId" : "us.nlm.vsac",
      "version" : "0.23.0"
    },
    {
      "id" : "tho",
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2023+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 1.1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-vbpr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.30"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2023+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 1.1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-vbpr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.30"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/alternate-measurescore"
        },
        "name" : "Alternate Measure Score",
        "description" : "The Alternate Measure Score Extension allows other data type choices to be used for the measureScore element in addition to Quantity. The alternate data type for measure score is determined by the performance metric type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/baseline"
        },
        "name" : "Baseline",
        "description" : "The Baseline Extension is a complex extension. It is used to state the baseline that the performance metric is used for comparisons.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vbp-cohort"
        },
        "name" : "Cohort",
        "description" : "Cohort types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/vbp-cohort"
        },
        "name" : "Cohort Codes",
        "description" : "The type of cohort, which represents a group of members with a shared characteristic.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/contractual-status"
        },
        "name" : "Contractual Status",
        "description" : "Contractual status of a measure whether it is tied to payment as specified in a value-based contract.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Group"
          }
        ],
        "reference" : {
          "reference" : "Group/everyhospital-group"
        },
        "name" : "Every Hospital ATR Group",
        "description" : "Example Member Attribution List (ATR Group) for ABC Payer and Every Hospital Value-Based Contract.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/atr-group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Measure"
          }
        ],
        "reference" : {
          "reference" : "Measure/vbp-measure02"
        },
        "name" : "Example Value-Based Contract - ABC Payer and EveryHospital",
        "description" : "This is an example measure for the *VBP Measure* profile.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Measure"
          }
        ],
        "reference" : {
          "reference" : "Measure/vbp-measure01"
        },
        "name" : "Example Value-Based Contract - ABC Payer and GoodHealth",
        "description" : "This is an example measure for the *VBP Measure* profile.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Group"
          }
        ],
        "reference" : {
          "reference" : "Group/goodhealth-group"
        },
        "name" : "Good Health Clinic ATR Group",
        "description" : "Example Member Attribution List (ATR Group) for ABC Payer and Good Health Clinic Value-Based Contract.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/atr-group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/group-reference"
        },
        "name" : "Group Reference",
        "description" : "Reference to a group within the MeasureReport.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hcplan-framework"
        },
        "name" : "HCPLAN Framework Categories",
        "description" : "HCPLAN framework categories for value-based performance. HCPLAN framework represents payments from public and private payers to provider organizations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hcplan-framework"
        },
        "name" : "HCPLAN Framework Categories Codes",
        "description" : "HCPLAN Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer. Although payments will be classified in discrete categories, the Framework captures a continuum of clinical and financial risk for provider organizations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vbp-incentive"
        },
        "name" : "Incentive",
        "description" : "What type of incentive.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/vbp-incentive"
        },
        "name" : "Incentive Payment Codes",
        "description" : "What type of incentive for a payment stream such as quality incentive payment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/lob"
        },
        "name" : "Line of Business",
        "description" : "The Line of Business (LOB) Extension is used to indicate whether the value-based contract is for Medicare, Medicaid, or commercial (private insurance).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/lob"
        },
        "name" : "Line of Business Value Set",
        "description" : "Type of line of business.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-contractual-status"
        },
        "name" : "Measure Contractual Status",
        "description" : "Contractual status of a measure as specified in a value-based contract.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-contractual-status"
        },
        "name" : "Measure Contractual Status Codes",
        "description" : "Contractual status whether a measure is tied to payment as specified in a value-based contract.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/measure-stratifier-example"
        },
        "name" : "Measure Stratifier Example",
        "description" : "Example stratifiers that could be used to stratify measure or performance metrics.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/measure-stratifier-example"
        },
        "name" : "Measure Stratifier Example Codes",
        "description" : "Example stratifiers that could be used to stratify measure or performance metrics.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/measurereport-category"
        },
        "name" : "measurereport-category",
        "description" : "Search based on the measurereport-category extension",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/paid-through-date"
        },
        "name" : "Paid Through Date",
        "description" : "Paid through date is the ending date of the pay cycle.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/payment-stream"
        },
        "name" : "Payment Stream",
        "description" : "The Payment Stream Extension is a complex extension that defines the type of payment stream. A value-based contract may contain different types of payment streams, such as quality incentive payment and care coordination fee.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/payment-stream"
        },
        "name" : "Payment Stream Codes",
        "description" : "Payment stream defined in a value-based contract. A value-based contract may contain multiple payment streams.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vbp-payment-stream"
        },
        "name" : "Payment Stream Value Set",
        "description" : "Type of payment stream.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vbp-performance-metric"
        },
        "name" : "Performance Metric",
        "description" : "Type of value-based performance reporting performance metric.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/vbp-performance-metric"
        },
        "name" : "Performance Metric Codes",
        "description" : "Type of value-based performance metrics.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/program-model"
        },
        "name" : "Program Model",
        "description" : "The Program Model Extension is a complex extension, which defines the The Health Care Payment Learning & Action Network (HCPLAN) Alternative Payment Model (APM) framework specified APM categories and which cohort this program model applies to.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport01"
        },
        "name" : "quality-measurereport01",
        "description" : "This is an example Breast Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport02"
        },
        "name" : "quality-measurereport02",
        "description" : "This is an example Colorectal Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport03"
        },
        "name" : "quality-measurereport03",
        "description" : "This is an example Diabetes Care - Blood Sugar Controlled MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport04"
        },
        "name" : "quality-measurereport04",
        "description" : "This is an example Diabetes Care - Eye Exam MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport05"
        },
        "name" : "quality-measurereport05",
        "description" : "This is an example Medication Adherence for Cholesterol (Statins) MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport06"
        },
        "name" : "quality-measurereport06",
        "description" : "This is an example Medication Adherence for Hypertension (RAS antagonists) MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport07"
        },
        "name" : "quality-measurereport07",
        "description" : "This is an example Medication Adherence for Diabetes Medications MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport08"
        },
        "name" : "quality-measurereport08",
        "description" : "This is an example Statin Therapy for Patients with Cardiovascular Disease MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport09"
        },
        "name" : "quality-measurereport09",
        "description" : "This is an example Statin Use in Persons with Diabetes (SUPD) MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport11"
        },
        "name" : "quality-measurereport11",
        "description" : "This is an example Breast Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport12"
        },
        "name" : "quality-measurereport12",
        "description" : "This is an example Colorectal Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport13"
        },
        "name" : "quality-measurereport13",
        "description" : "This is an example Diabetic Retinopathy: Communication with the Physician Managing Ongoing Diabetes Care MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport14"
        },
        "name" : "quality-measurereport14",
        "description" : "This is an example Diabetes: Hemoglobin A1c (HbA1c) Poor Control (> 9%) MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport15"
        },
        "name" : "quality-measurereport15",
        "description" : "This is an example Diabetes: Medical Attention for Nephropathy MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport20"
        },
        "name" : "quality-measurereport20",
        "description" : "This is an example Breast Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport21"
        },
        "name" : "quality-measurereport21",
        "description" : "This is an example Colorectal Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport22"
        },
        "name" : "quality-measurereport22",
        "description" : "This is an example Comprehensive Diabetes Care: Hemoglobin A1c (HbA1c) Control (<8.0%) MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport23"
        },
        "name" : "quality-measurereport23",
        "description" : "This is an example Controlling High Blood Pressure MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport24"
        },
        "name" : "quality-measurereport24",
        "description" : "This is an example Plan All-Cause Readmissions MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport25"
        },
        "name" : "quality-measurereport25",
        "description" : "This is an example Member Satisfaction Survey MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport30"
        },
        "name" : "quality-measurereport30",
        "description" : "This is an example Breast Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport31"
        },
        "name" : "quality-measurereport31",
        "description" : "This is an example Colorectal Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport32"
        },
        "name" : "quality-measurereport32",
        "description" : "This is an example Diabetes Care - Blood Sugar Controlled MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/quality-measurereport33"
        },
        "name" : "quality-measurereport33",
        "description" : "This is an example Diabetes Care - Eye Exam MeasureReport for the *VBP Quality MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/score"
        },
        "name" : "Score",
        "description" : "The Score Extension is used to specify the score of a measure, such as star score.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/service-period"
        },
        "name" : "Service Period",
        "description" : "The Service period for a payment stream.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/threshold"
        },
        "name" : "Threshold",
        "description" : "The Threshold Extension is a complex extension that defines a threshold needed to be met when measuring performance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/threshold-type"
        },
        "name" : "Threshold Type",
        "description" : "The threshold type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/threshold-type"
        },
        "name" : "Threshold Type Codes",
        "description" : "The threshold type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/vbp-measure"
        },
        "name" : "Value-Based Performance Measure",
        "description" : "The measure definition that describes value-based contract level information for a value-based performance report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/vbp-measure-population"
        },
        "name" : "Value-Based Performance Measure Population Type Codes",
        "description" : "Measure population type that includes calculated-denominator and calculated-numerator.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/vbp-performance-measurereport"
        },
        "name" : "Value-Based Performance MeasureReport",
        "description" : "Value-Based Performance MeasureReport is a payer-generated performance report against the specific details (metrics) of a value-based contract (VBC) or a value-based purchasing (VBP) which may include financial, quality, utilization, etc. over a time period.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vbp-measure-population"
        },
        "name" : "VBP Measure Population Type",
        "description" : "Measure population type that includes calculated-denominator and calculated-numerator.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/vbp-quality-measurereport"
        },
        "name" : "VBP Quality MeasureReport",
        "description" : "VBP quality measure report at the summary level for a population. This profile is derived from the Data Exchange for Quality Measure IG's DEQM Summary MeasureReport.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/vbp-reporting-client"
        },
        "name" : "VBP Reporting Client Capability Statement",
        "description" : "This profile defines the expected capabilities of the Value-Based Performance (VBP) Reporting Client actor, when request and consume value-based performance MeasureReports from a Value-Based Performance Reporting Server. The complete list of FHIR profiles \r\nthat a VBP Reporting Server could support are defined. VBP Reporting Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/vbp-reporting-server"
        },
        "name" : "VBP Reporting Server Capability Statement",
        "description" : "This profile defines the expected capabilities of the Value-Based Performance (VBP) Reporting Server actor which is responsible for producing value-based performance MeasureReports to be consumed by a Value-Based Performance Reporting Client. The complete list of FHIR profiles \r\nand search parameters that a VBP Reporting Server could support are defined. VBP Reporting Servers have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/vbp-measurereport101"
        },
        "name" : "vbp-measurereport101",
        "description" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile., which includes examples for payment streams shared savings - gated on quality, care coordination fee, quality incentive payment for the chronic care management incentive program, and quality incentive payment for the annual office visits.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/vbp-measurereport102"
        },
        "name" : "vbp-measurereport102",
        "description" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile., which includes utilizations and quality.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/vbp-measurereport103"
        },
        "name" : "vbp-measurereport103",
        "description" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile., \nwhich includes quality measures and alternative measures.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/vbp-measurereport104"
        },
        "name" : "vbp-measurereport104",
        "description" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/vbp-payer01"
        },
        "name" : "vbp-payer01",
        "description" : "This is an example payer",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/vbp-provider01"
        },
        "name" : "vbp-provider01",
        "description" : "This is an example of Provider organization the Value-Based Performance Report is for.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/vbp-provider02"
        },
        "name" : "vbp-provider02",
        "description" : "This is an example of Provider organization the Value-Based Performance Report is for.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/weight"
        },
        "name" : "Weight",
        "description" : "What is the weight of the contribution of this measure to the overall performance score specified by a value-based contract.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "IG Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "fhir.html"
            }
          ],
          "nameUrl" : "fhir.html",
          "title" : "Reading this IG",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "usecase.html"
            }
          ],
          "nameUrl" : "usecase.html",
          "title" : "Use Cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "glossary.html"
            }
          ],
          "nameUrl" : "glossary.html",
          "title" : "Glossary",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "credits.html"
            }
          ],
          "nameUrl" : "credits.html",
          "title" : "Projects and Participants",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "conformance.html"
            }
          ],
          "nameUrl" : "conformance.html",
          "title" : "Conformance Expectations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "guidance.html"
            }
          ],
          "nameUrl" : "guidance.html",
          "title" : "Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Privacy, Safety, and Security",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts Summary",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles.html"
            }
          ],
          "nameUrl" : "profiles.html",
          "title" : "Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "extensions.html"
            }
          ],
          "nameUrl" : "extensions.html",
          "title" : "Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology.html"
            }
          ],
          "nameUrl" : "terminology.html",
          "title" : "Terminology",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search-parameters.html"
            }
          ],
          "nameUrl" : "search-parameters.html",
          "title" : "Search Parameters",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capabilities.html"
            }
          ],
          "nameUrl" : "capabilities.html",
          "title" : "Capability Statements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "change-log.html"
            }
          ],
          "nameUrl" : "change-log.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "input/pagecontent"
      },
      {
        "code" : "path-pages",
        "value" : "input/intro-notes"
      },
      {
        "code" : "path-pages",
        "value" : "fsh-generated/includes"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
