# Guidance - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Guidance**

## Guidance

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Resources

There are three profiles specified in this version of the implementation guide:

* The [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md) is the main resource that represents a value-based performance report, which could include data on financial and utilization metrics and quality measures, etc.
* The Value-Based Performance MeasureReport `evaluatedResource` references the [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md) profile. This profile derives from the Da Vinci Data Exchange for Quality Measure IG's DEQM Summary MeasureReport profile and provides additional capability to support the need for exchanging quality measure data relevant for value-based performance reporting.
* Relevant value-based contract level information is represented using the [Value-Based Performance Measure](StructureDefinition-vbp-measure.md).

**Figure 2-1 Resources Overview**
![](resources.png)

### Workflow

Figure 2-2 describes value-based performance reporting workflow between a Payer and a Provider. Payer creates Value-Based Performance Measure for a value-based contract and generates VBP MeasureReport for a performance period, Provider then periodically gets the reports from the Payer.

**Figure 2-2 Value-based performance reporting workflow**
![](api-workflow.png)

### Value-Based Reporting Framework

Value-based payment models are expected to grow across all lines of business. The adoption of value-based care has accelerated in recent years, and this trend could continue in the coming years as payers, employers, and the government embrace these value-based care models. Value-based contracts encompass a broad variety of models, such as capitation, pay-for-performance, pay-for-quality, and shared savings to name a few. The performance metrics and measures that these value-based contracts need to measure and to track are also very broad, which spans over financial, quality, utilization and more. Because of the challenges with ever-expanding value-based payment models and performance metrics associated with those models, it would be near impossible and unsustainable to specify a comprehensive list of named representations for these different value-based care models and metrics. This implementation guide has taken the approach of defining a framework for value-based performance reporting. The profiles specified in this implementation guide provide standard structural representation that is intended to support reporting on various value-based payment models. Commonly used payment models and performance metrics are defined in value sets with extensible binding, which provides Payer and Provider the flexibility for reporting value-based payment models and metrics that are not yet defined in this implementation guide or those that are applicable only to their own organizations.

#### Value-Based Performance MeasureReport

The Value-Based Performance MeasureReport ([VBP MeasureReport](StructureDefinition-vbp-performance-measurereport.md)) is a profile on the MeasureReport resource. Each `MeasureReport.group` corresponds to a performance metric.

* The `MeasureReport.group.code` has an extensible binding to the [Performance Metric](ValueSet-vbp-performance-metric.md) value set. This value set contains a list of commonly used performance metrics for various value-based payment models. Several extensions are added to the `group` element to provide additional information about a performance metric.
* `measureScore` is the value of a performance metric. An extension [Alternate MeasureScore](StructureDefinition-alternate-measurescore.md) is added to allow additional data types including decimal, integer, CodeableConcept, boolean, and Money to be used in addition to Quantity.
* `paymentStream` is a complex extension. The `type` is required, which has an extensible binding to the Payment Stream value set. The Payment Stream value set defines commonly used value-based payment models such as care coordination fee, shared savings percent, shared savings gated on quality, and etcetera. The `incentive` is an optional field and is intended to provide more granular incentive program information for the Quality Incentive Payment payment stream, such as chronic care management and annual office visit. The `paymentStream` has cardinality of 0..*. It is possible for a performance metric to be associated with different payment streams.
* `baseline` is a complex extension. The baseline value of the performance metric and the time period the baseline was measured could be provided.
* `servicePeriod` is the service period for a performance metric. Each performance metric may have a different service period.
* `paidThroughDate` is the ending date of the pay cycle.

Value-based performance reports often include data on performance on overall population and stratified results on those performance metrics based on variety of stratifiers. This IG has defined a list of stratifier codes, which include facility, taxid, group, geography, and cohort.

* The `MeasureReport.group.stratifer` provides the capabilities of stratifying based on a single stratifier or combination of a number of stratifiers.
* For example, to stratify by regions within an organization only, it will use facility as the stratifier code, then the `stratifier.stratum.value` would be selecting from a list of codes that represent the regions. The exact codes may be specific to a payer or provider organization.
* If stratifying by a compound stratifier, such as both facility and cohort (either HMO or PPO), this would be represented using the `stratifier.stratum.component`.

Many value-based payment models involve quality. The implementation guide reuses the [Data Exchange for Quality Measure (DEQM) Summary MeasureReport](http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/summary-measurereport-deqm) for reports on quality measures. The [VBP MeasureReport](StructureDefinition-vbp-performance-measurereport.md) profile created a slice on the `MeasureReport.evaluatedResource` to reference the [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md) profile, which is derived from the DEQM Summary MeasureReport. The `groupReference` extension allows a VBP MeasureReport to be linked to a specific performance metric by using the `group.id` if needed.

For a value-based performance report, the subject of the report is a reference to the [ATR Group](https://hl7.org/fhir/us/davinci-atr/STU2.1/StructureDefinition-atr-group.html) profile defined in the Da Vinci Member Attribution (ATR) List IG. ATR Group is a Member Attribution List that contain information related to the members who are attributed to a value-based contract.

Figure 2-2 provides a structural overview of the VBP MeasureReport. (Note: elements that are added as extensions are indicated with purple background.) 

**Figure 2-3 VBP MeasureReport overview**
![](vbp-measurereport.png)

#### Value-Based Performance (VBP) Quality MeasureReport

[VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md) is based on the DEQM Summary MeasureReport with a few extensions.

* `MeasureReport.threshold`: value-based performance reports often include threshold information for a measure, for example, the threshold for this measure for a 4 star in a star rating is 85%. The `type` indicates what kind of threshold. The `threshold` is the value of the threshold, such as 85%. The gap that needs to meet the threshold can be represented using the optional `gapToThreshold`.
* `MeasureReport.score`: this score is used to represent scores such as a star rating score.

This profile has defined a [VBP Measure Population Type](ValueSet-vbp-measure-population.md) value set. This value set added two new codes calculated-denominator and calculated-numerator to the Measure Population Type value set from the base Measure resource. The calculated-denominator is the resulting denominator when calculating performance rate, for a proportion measure, this would be the result of denominator – denominator exclusion – denominator exception. Same applies to the calculated-numerator.

Figure 2-3 and Figure 2-4 used the colorectal cancer screening and the breast cancer screening measures as examples to illustrate the use of the VBP Quality MeasureReport.

**Figure 2-4 VBP Quality MeasureReport overview - colorectal cancer screening measure example**
![](vbp-quality-measurereport-colorectalcancer.png)

**Figure 2-5 VBP Quality MeasureReport overview - breast cancer screening measure example**
![](vbp-quality-measurereport-breastcancer.png)

#### Value-Based Performance (VBP) Measure

The [VBP Measure](StructureDefinition-vbp-measure.md) is used to represent value-based contract information that are needed for value-based performance reporting.

This profile added a few extensions to represent the following:

* lineOfBusiness: line of business whether it is Medicare, Medicaid, or commercial.
* programModel: HCPLAN APM framework categories. A value-based contract may have a different HCPLAN APM framework category applicable for a different cohort.
* paymentStream: value-based payment models such as care coordination fee, shared savings percent, shared savings gated on quality.

**Figure 2-6 VBP Measure overview**
![](vbp-measure.png)

