# Examples - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following examples are published with this guide, and all are available as a downloadable zip file [here](downloads.md#examples).

### Example Value-Based Performance Report - vbp-measurereport101

This example value-based performance MeasureReport ([vbp-measurereport101](MeasureReport-vbp-measurereport101.md)) includes example payment streams:

* shared savings - gated on quality,
* care coordination fee,
* quality incentive payment chronic care management incentive program, and
* quality incentive payment annual office visits

The example "shared savings - gated on quality" payment stream's weighted average star score is based on 9 quality measures.

| | |
| :--- | :--- |
| [vbp-measurereport101](MeasureReport-vbp-measurereport101.md) | Example Value-Based Performance MeasureReport for a value-based contract between ABC Payer and GoodHealthClinic |
| [quality-measurereport01](MeasureReport-quality-measurereport01.md) | Example Quality Performance MeasureReport for Breast Cancer Screening |
| [quality-measurereport02](MeasureReport-quality-measurereport02.md) | Example Quality Performance MeasureReport for Colorectal Cancer Screening |
| [quality-measurereport03](MeasureReport-quality-measurereport03.md) | Example Quality Performance MeasureReport Diabetes Care - Blood Sugar Controlled |
| [quality-measurereport04](MeasureReport-quality-measurereport04.md) | Example Quality Performance MeasureReport Diabetes Care - Eye Exam Controlled |
| [quality-measurereport05](MeasureReport-quality-measurereport05.md) | Example Quality Performance MeasureReport Medication Adherence for Cholesterol (Statins) |
| [quality-measurereport06](MeasureReport-quality-measurereport06.md) | Example Quality Performance MeasureReport Medication Adherence for Hypertension (RAS antagonists) |
| [quality-measurereport07](MeasureReport-quality-measurereport07.md) | Example Quality Performance MeasureReport Medication Adherence for Diabetes Medications |
| [quality-measurereport08](MeasureReport-quality-measurereport08.md) | Example Quality Performance MeasureReport Statin Therapy for Patients with Cardiovascular Disease |
| [quality-measurereport09](MeasureReport-quality-measurereport09.md) | Example Quality Performance MeasureReport Statin Use in Persons with Diabetes (SUPD) |
| [vbp-measure01](Measure-vbp-measure01.md) | Example VBP Measure |
| [vbp-payer01](Organization-vbp-payer01.md) | Example Organization: ABC Payer |
| [vbp-provider01](Organization-vbp-provider01.md) | Example Organization: Good Health Clinic |
| [goodhealth-group](Group-goodhealth-group.md) | Example ATR Group: Member Attribution List for ABC Payer and Good Health Clinic Value-Based Contract |

### Example Value-Based Performance Report - vbp-measurereport102

This example value-based performance MeasureReport ([vbp-measurereport102](MeasureReport-vbp-measurereport102.md)) includes example payment streams:

* utilization incentive payment
* shared savings - gated on quality

The example "shared savings - gated on quality" is based on 5 quality measures.

| | |
| :--- | :--- |
| [vbp-measurereport102](MeasureReport-vbp-measurereport102.md) | Example Value-Based Performance MeasureReport for a value-based contract between ABC Payer and EveryHospital |
| [quality-measurereport11](MeasureReport-quality-measurereport11.md) | Example Quality Performance MeasureReport for Breast Cancer Screening |
| [quality-measurereport12](MeasureReport-quality-measurereport12.md) | Example Quality Performance MeasureReport for Colorectal Cancer Screening |
| [quality-measurereport13](MeasureReport-quality-measurereport13.md) | Example Quality Performance MeasureReport Diabetic Retinopathy: Communication with the Physician Managing Ongoing Diabetes Care |
| [quality-measurereport14](MeasureReport-quality-measurereport14.md) | Example Quality Performance MeasureReport Diabetes: Hemoglobin A1c (HbA1c) Poor Control (> 9%) |
| [quality-measurereport15](MeasureReport-quality-measurereport15.md) | Example Quality Performance MeasureReport Diabetes: Medical Attention for Nephropathy |
| [vbp-measure02](Measure-vbp-measure02.md) | Example VBP Measure |
| [vbp-payer01](Organization-vbp-payer01.md) | Example Organization: ABC Payer |
| [vbp-provider02](Organization-vbp-provider01.md) | Example Organization: Every Hospital |
| [goodhospital-group](Group-everyhospital-group.md) | Example ATR Group: Member Attribution List for ABC Payer and Every Hospital Value-Based Contract |

### Example Value-Based Performance Report - vbp-measurereport103

The example shows an example report with 6 quality measures and 2 alternative measures.

| | |
| :--- | :--- |
| [vbp-measurereport103](MeasureReport-vbp-measurereport103.md) | Example Value-Based Performance MeasureReport for a value-based contract between ABC Payer and EveryHospital |
| [quality-measurereport20](MeasureReport-quality-measurereport20.md) | Example Quality Performance MeasureReport for Breast Cancer Screening |
| [quality-measurereport21](MeasureReport-quality-measurereport21.md) | Example Quality Performance MeasureReport for Colorectal Cancer Screening |
| [quality-measurereport22](MeasureReport-quality-measurereport22.md) | Example Quality Performance MeasureReport Comprehensive Diabetes Care: Hemoglobin A1c (HbA1c) Control (<8.0%) |
| [quality-measurereport23](MeasureReport-quality-measurereport23.md) | Example Quality Performance MeasureReport Controlling High Blood Pressure |
| [quality-measurereport24](MeasureReport-quality-measurereport24.md) | Example Quality Performance MeasureReport Plan All-Cause Readmissions |
| [quality-measurereport25](MeasureReport-quality-measurereport25.md) | Example Quality Performance MeasureReport Member Satisfaction Survey |
| [vbp-measure02](Measure-vbp-measure02.md) | Example VBP Measure |
| [vbp-payer01](Organization-vbp-payer01.md) | Example Organization: ABC Payer |
| [vbp-provider02](Organization-vbp-provider01.md) | Example Organization: Every Hospital |
| [goodhospital-group](Group-everyhospital-group.md) | Example ATR Group: Member Attribution List for ABC Payer and Every Hospital Value-Based Contract |

### Example Value-Based Performance Report - vbp-measurereport104

| | |
| :--- | :--- |
| [vbp-measurereport104](MeasureReport-vbp-measurereport104.md) | Example Value-Based Performance MeasureReport for a value-based contract between ABC Payer and EveryHospital |
| [quality-measurereport30](MeasureReport-quality-measurereport30.md) | Example Quality Performance MeasureReport for Breast Cancer Screening |
| [quality-measurereport31](MeasureReport-quality-measurereport31.md) | Example Quality Performance MeasureReport for Colorectal Cancer Screening |
| [quality-measurereport32](MeasureReport-quality-measurereport32.md) | Example Quality Performance MeasureReport Diabetes Care - Blood Sugar Controlled |
| [quality-measurereport33](MeasureReport-quality-measurereport33.md) | Example Quality Performance MeasureReport Diabetes Care - Eye Exam |
| [vbp-measure02](Measure-vbp-measure02.md) | Example VBP Measure |
| [vbp-payer01](Organization-vbp-payer01.md) | Example Organization: ABC Payer |
| [vbp-provider02](Organization-vbp-provider01.md) | Example Organization: Every Hospital |
| [goodhospital-group](Group-everyhospital-group.md) | Example ATR Group: Member Attribution List for ABC Payer and Every Hospital Value-Based Contract |

