# Downloads - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Downloads

* FHIR Da Vinci Value-Based Performance Reporting (VBPR) IG downloads: 
* The full [FHIR Da Vinci VBPR IG](full-ig.zip) that can be hosted locally
* FHIR VBPR Resource definitions [(JSON)](definitions.json.zip) [(XML)](definitions.xml.zip) [(TTL)](definitions.ttl.zip)
* All examples in the VBPR IG [(JSON)](examples.json.zip) [(XML)](examples.xml.zip) [(TTL)](examples.ttl.zip)
* FHIR VBPR IG [Validator Pack](validator-hl7.fhir.us.davinci-vbpr.pack)
* [Schematrons](schematrons.zip)
 
* FHIR R4 Specification [Downloads](http://hl7.org/fhir/R4/downloads.html)
* FHIR R4 [Core Specification Text](http://hl7.org/fhir/R4/fhir-spec.zip)
* [Instructions for the FHIR Validator](https://confluence.hl7.org/display/FHIR/Using+the+FHIR+Validator)
* Current version of the [FHIR Validator](https://fhir.github.io/latest-ig-validator/org.hl7.fhir.validator.jar)

### Package File

The following package file includes a Node Package Manager ([NPM](https://hl7.org/fhir/packages.html)) package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and URLs, etc., that are defined as part of this version of the implementation guide (IG). This file should be the first choice whenever generating any implementation artifacts since it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation. See the [Validating Resources](http://hl7.org/fhir/R4/validation.html) documentation in FHIR.

* [Package](package.tgz)

### Examples

All the examples that are used in this IG are available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)

### Schematrons

Schematrons are available for download:

* 

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.davinci-vbpr.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.davinci-vbpr.r4b)](package.r4b.tgz) are available.

#### Dependency Table




























#### Globals Table

Global Profiles:

* **Type**: [Encounter](http://hl7.org/fhir/R4/encounter.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore Encounter](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-encounter.html)
* **Type**: [Immunization](http://hl7.org/fhir/R4/immunization.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore Immunization](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-immunization.html)
* **Type**: [Observation](http://hl7.org/fhir/R4/observation.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore Simple Observation](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-simple-observation.html)
* **Type**: [Organization](http://hl7.org/fhir/R4/organization.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore Organization](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-organization.html)
* **Type**: [Patient](http://hl7.org/fhir/R4/patient.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore Patient](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-patient.html)
* **Type**: [Practitioner](http://hl7.org/fhir/R4/practitioner.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore Practitioner](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-practitioner.html)
* **Type**: [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)
  * **Source**: [hl7.fhir.us.qicore#6.0.0](http://hl7.org/fhir/us/qicore/STU6)
  * **Profile**: [QICore PractitionerRole](http://hl7.org/fhir/us/qicore/STU6/StructureDefinition-qicore-practitionerrole.html)

All resources of these types must conform to these profiles.

#### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AlternateMeasureScore](StructureDefinition-alternate-measurescore.md), [Baseline](StructureDefinition-baseline.md)...Show 38 more,[ContractualStatus](StructureDefinition-contractual-status.md),[GroupReference](StructureDefinition-group-reference.md),[HCPLANFrameworkCS](CodeSystem-hcplan-framework.md),[HCPLANFrameworkVS](ValueSet-hcplan-framework.md),[LOB](StructureDefinition-lob.md),[LineOfBusinessVS](ValueSet-lob.md),[MeasureContratualStatusCS](CodeSystem-measure-contractual-status.md),[MeasureContratualStatusVS](ValueSet-measure-contractual-status.md),[MeasureReportCategory](SearchParameter-measurereport-category.md),[MeasureStratifierExampleCS](CodeSystem-measure-stratifier-example.md),[MeasureStratifierExampleVS](ValueSet-measure-stratifier-example.md),[PaidThroughDate](StructureDefinition-paid-through-date.md),[PaymentStream](StructureDefinition-payment-stream.md),[PaymentStreamCS](CodeSystem-payment-stream.md),[PaymentStreamVS](ValueSet-vbp-payment-stream.md),[ProgramModel](StructureDefinition-program-model.md),[Score](StructureDefinition-score.md),[ServicePeriod](StructureDefinition-service-period.md),[Threshold](StructureDefinition-threshold.md),[ThresholdTypeCS](CodeSystem-threshold-type.md),[ThresholdTypeVS](ValueSet-threshold-type.md),[VBPCohortVS](ValueSet-vbp-cohort.md),[VBPIncentiveVS](ValueSet-vbp-incentive.md),[VBPRMeasurePopulationVS](ValueSet-vbp-measure-population.md),[VBPReportingClientCapabilityStatement](CapabilityStatement-vbp-reporting-client.md),[VBPReportingServerCapabilityStatement](CapabilityStatement-vbp-reporting-server.md),[ValueBasedPerformanceReporting](index.md),[VbpCohortCS](CodeSystem-vbp-cohort.md),[VbpIncentiveCS](CodeSystem-vbp-incentive.md),[VbpMeasure](StructureDefinition-vbp-measure.md),[VbpMeasurePopulationTypeCS](CodeSystem-vbp-measure-population.md),[VbpMeasureReport](StructureDefinition-vbp-performance-measurereport.md),[VbpPerformanceMetricsCS](CodeSystem-vbp-performance-metric.md),[VbpPerformanceMetricsVS](ValueSet-vbp-performance-metric.md),[VbpQualityMeasureReport](StructureDefinition-vbp-quality-measurereport.md),[VbprMeasureExample01](Measure-vbp-measure01.md),[VbprMeasureExample02](Measure-vbp-measure02.md)and[Weight](StructureDefinition-weight.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 25 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md),[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md),[MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md),[MeasureReport/vbp-measurereport102](MeasureReport-vbp-measurereport102.md)and[MeasureReport/vbp-measurereport104](MeasureReport-vbp-measurereport104.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 8 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md)and[MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [MeasureImprovementNotation](http://terminology.hl7.org/6.5.0/CodeSystem-measure-improvement-notation.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 22 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* [Measure Population Type](http://terminology.hl7.org/6.5.0/CodeSystem-measure-population.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 8 more,[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[VBPRMeasurePopulationVS](ValueSet-vbp-measure-population.md)and[VbpQualityMeasureReport](StructureDefinition-vbp-quality-measurereport.md)
* [Measure Scoring](http://terminology.hl7.org/6.5.0/CodeSystem-measure-scoring.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 22 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [ABC Payer](Organization-vbp-payer01.md), [Every Hospital](Organization-vbp-provider02.md) and [Good Health Clinic](Organization-vbp-provider01.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md)...Show 7 more,[MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md),[MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md),[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md)and[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md)


