# Projects and Participants - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* **Projects and Participants**

## Projects and Participants

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Da Vinci

[Da Vinci](https://www.hl7.org/about/davinci/index.cfm) is an HL7-sponsored project that brings together U.S. payers, providers, and technology suppliers to help payers and providers improve clinical, quality, cost, and care management outcomes using FHIR-related technologies. The project organizes meetings (face-to-face and conference calls) and connectathons to find ways to leverage FHIR technologies to support and integrate value-based care (VBC) data exchange across communities. Da Vinci identifies value-based care use cases of interest to its members and to the broader community.

The process that Da Vinci has adopted includes:

1. identifying business, clinical, technical, and testing requirements
1. developing and balloting a FHIR-based implementation guide (IG)
1. developing reference implementations (RIs) to demonstrate that the concepts in the IG are possible to implement
1. piloting the standard
1. supporting the production use of the IG to enable exchange of data to support interoperability for value-based care

All Da Vinci work adheres to a common set of [guiding principles](http://hl7.org/fhir/us/davinci-hrex/davinci-guiding-principles.html).

Additional information about Da Vinci, its members, the use cases, and the implementation guides being developed can all be found on the [HL7 website](http://www.hl7.org/about/davinci). Meeting minutes and other materials can be found on the [Da Vinci Confluence page](https://confluence.hl7.org/display/DVP).

### The Da Vinci VBPR project

Further details about the project, including minutes of meetings can be found on the [project Confluence page](https://confluence.hl7.org/spaces/DVP/pages/94643888/Value+Based+Performance+Reporting+VBPR).

### Credits

This implementation guide was made possible by the thoughtful contributions of the following people and organizations:

* **The[Da Vinci Project](http://www.hl7.org/about/davinci/index.cfm?ref=common)member organizations.**
* **Vincent Powell, Providence**
* **Semira Singh, Providence**
* **Michael Pattwell, Edifecs**
* **Tom Dean, Edifecs**
* **David Degandi, Cambia Health Solutions**
* **Omar Amezquita, Cambia Health Solutions**
* **Katie Roan, Optum**
* **Rao Yogesh, Optum**
* **Bryn Rhodes, Smile Digital Health**
* **Rob Reynolds, Smile Digital Health**
* **Teresa Younkin, Point-of-Care Partners**
* **Yan Heras, Optimum eHealth**
* **Viet Nguyen, Stratametrics**

-------

Special thanks go to the numerous individuals who have participated in conference calls, ballots, and reviews of this IG.

If you are interested in participating in the VBPR project: information about our calls, minutes of past discussions, and other information can be found [here](https://confluence.hl7.org/pages/viewpage.action?pageId=94643888) on our HL7 Confluence page.

