# Value-Based Performance MeasureReport - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Value-Based Performance MeasureReport**

## Resource Profile: Value-Based Performance MeasureReport 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:VbpMeasureReport |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.42.14 | | |

 
Value-Based Performance MeasureReport is a payer-generated performance report against the specific details (metrics) of a value-based contract (VBC) or a value-based purchasing (VBP) which may include financial, quality, utilization, etc. over a time period. 

The [Formal Views](StructureDefinition-vbp-performance-measurereport.md#profile) below provides the formal summary, definitions, and terminology requirements.

**Each Value-Based Performance MeasureReport has the following mandatory elements**

1. A`measurereport-category`- with a fixed code`vbp`
1. A`status`- status of this report
1. A`type`- with a fixed value`summary`
1. A`measure`- references a Value-Based Performance Measure
1. A`subject`- references an ATR Group
1. A`date`
1. A`reporter`- references the organization who is reporting the data
1. A`period`- the performance period the report covers

**Each Value-Based Performance MeasureReport should have the following elements**

1. Zero to many`group`- each group corresponds to a performance metric
* If `group` is present, each group must have a `group.code` that represents the performance metric

1. Zero to many`evaluatedResource`- references the VBP Quality MeasureReport profile

**Usages:**

* Examples for this Profile: [MeasureReport/vbp-measurereport101](MeasureReport-vbp-measurereport101.md), [MeasureReport/vbp-measurereport102](MeasureReport-vbp-measurereport102.md), [MeasureReport/vbp-measurereport103](MeasureReport-vbp-measurereport103.md) and [MeasureReport/vbp-measurereport104](MeasureReport-vbp-measurereport104.md)
* CapabilityStatements using this Profile: [VBP Reporting Client Capability Statement](CapabilityStatement-vbp-reporting-client.md) and [VBP Reporting Server Capability Statement](CapabilityStatement-vbp-reporting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-vbpr|current/StructureDefinition/vbp-performance-measurereport)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-vbp-performance-measurereport.csv), [Excel](StructureDefinition-vbp-performance-measurereport.xlsx), [Schematron](StructureDefinition-vbp-performance-measurereport.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "vbp-performance-measurereport",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.42.14"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbpMeasureReport",
  "title" : "Value-Based Performance MeasureReport",
  "status" : "active",
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Value-Based Performance MeasureReport is a payer-generated performance report against the specific details (metrics) of a value-based contract (VBC) or a value-based purchasing (VBP) which may include financial, quality, utilization, etc. over a time period.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MeasureReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MeasureReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MeasureReport",
        "path" : "MeasureReport",
        "short" : "A value-based performance report"
      },
      {
        "id" : "MeasureReport.extension",
        "path" : "MeasureReport.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MeasureReport.extension:measurereport-category",
        "path" : "MeasureReport.extension",
        "sliceName" : "measurereport-category",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/measurereport-category|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.extension:measurereport-category.value[x].coding",
        "path" : "MeasureReport.extension.value[x].coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MeasureReport.extension:measurereport-category.value[x].coding.code",
        "path" : "MeasureReport.extension.value[x].coding.code",
        "min" : 1,
        "max" : "1",
        "fixedCode" : "vbp"
      },
      {
        "id" : "MeasureReport.status",
        "path" : "MeasureReport.status",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.type",
        "path" : "MeasureReport.type",
        "fixedCode" : "summary",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.measure",
        "path" : "MeasureReport.measure",
        "short" : "A Measure definition with contract level data for a value-based contract the report is for",
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.subject",
        "path" : "MeasureReport.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/atr-group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.date",
        "path" : "MeasureReport.date",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.reporter",
        "path" : "MeasureReport.reporter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.period",
        "path" : "MeasureReport.period",
        "short" : "What performance period the report covers",
        "definition" : "What performance period the report covers. If the report contains multiple payment streams and each with different service periods, the report period covers the entire time span of these payment streams service periods. ",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.improvementNotation",
        "path" : "MeasureReport.improvementNotation",
        "max" : "0"
      },
      {
        "id" : "MeasureReport.group",
        "path" : "MeasureReport.group",
        "short" : "Performance metrics in the report. Each group contains data for a performance metric.",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.id",
        "path" : "MeasureReport.group.id",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.extension",
        "path" : "MeasureReport.group.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MeasureReport.group.extension:paymentStream",
        "path" : "MeasureReport.group.extension",
        "sliceName" : "paymentStream",
        "short" : "The payment stream the performance metric is part of",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.extension:servicePeriod",
        "path" : "MeasureReport.group.extension",
        "sliceName" : "servicePeriod",
        "short" : "The service period for the performance metric",
        "definition" : "The service period may be the same as or a subset of the performance period the report covers.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.extension:paidThroughDate",
        "path" : "MeasureReport.group.extension",
        "sliceName" : "paidThroughDate",
        "short" : "Ending date of the pay cycle",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.extension:baseline",
        "path" : "MeasureReport.group.extension",
        "sliceName" : "baseline",
        "short" : "The baseline for the performance metric",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/baseline"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.code",
        "path" : "MeasureReport.group.code",
        "short" : "Performance metric",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/vbp-performance-metric"
        }
      },
      {
        "id" : "MeasureReport.group.measureScore",
        "path" : "MeasureReport.group.measureScore",
        "short" : "The performance metric value"
      },
      {
        "id" : "MeasureReport.group.measureScore.extension:altMeasureScore",
        "path" : "MeasureReport.group.measureScore.extension",
        "sliceName" : "altMeasureScore",
        "short" : "Additional data type choices for the value of the performance metric",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier",
        "path" : "MeasureReport.group.stratifier",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.code",
        "path" : "MeasureReport.group.stratifier.code",
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/measure-stratifier-example"
        }
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum",
        "path" : "MeasureReport.group.stratifier.stratum",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.value",
        "path" : "MeasureReport.group.stratifier.stratum.value",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.component.code",
        "path" : "MeasureReport.group.stratifier.stratum.component.code",
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/measure-stratifier-example"
        }
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.component.value",
        "path" : "MeasureReport.group.stratifier.stratum.component.value",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.measureScore",
        "path" : "MeasureReport.group.stratifier.stratum.measureScore",
        "short" : "Stratified performance metric value",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.group.stratifier.stratum.measureScore.extension:altMeasureScore",
        "path" : "MeasureReport.group.stratifier.stratum.measureScore.extension",
        "sliceName" : "altMeasureScore",
        "short" : "Additional data type choices for the stratified performance metric value",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.evaluatedResource",
        "path" : "MeasureReport.evaluatedResource",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "reference"
            }
          ],
          "description" : "quality measure MeasureReport(s) for quality measure performance",
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "What data was used to calculate the performance metric(s)",
        "definition" : "Evaluated resources are used to capture what data was involved in the calculation of performance metrics.",
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.evaluatedResource:qualityReport",
        "path" : "MeasureReport.evaluatedResource",
        "sliceName" : "qualityReport",
        "short" : "quality measure MeasureReport",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MeasureReport.evaluatedResource:qualityReport.extension:groupRef",
        "path" : "MeasureReport.evaluatedResource.extension",
        "sliceName" : "groupRef",
        "short" : "Reference a performance metric (MeasureReport.group.id) on this value-based performance report",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
