# Threshold - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Threshold**

## Extension: Threshold 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Threshold |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.42.12 | | |

The Threshold Extension is a complex extension that defines a threshold needed to be met when measuring performance.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)
* Examples for this Extension: [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md), [MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md), [MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md)...Show 20 more,[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport11](MeasureReport-quality-measurereport11.md),[MeasureReport/quality-measurereport12](MeasureReport-quality-measurereport12.md),[MeasureReport/quality-measurereport13](MeasureReport-quality-measurereport13.md),[MeasureReport/quality-measurereport14](MeasureReport-quality-measurereport14.md),[MeasureReport/quality-measurereport15](MeasureReport-quality-measurereport15.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-vbpr|current/StructureDefinition/threshold)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-threshold.csv), [Excel](StructureDefinition-threshold.xlsx), [Schematron](StructureDefinition-threshold.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "threshold",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.42.12"
    }
  ],
  "version" : "1.1.0",
  "name" : "Threshold",
  "title" : "Threshold",
  "status" : "active",
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The Threshold Extension is a complex extension that defines a threshold needed to be met when measuring performance.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MeasureReport"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Threshold",
        "definition" : "The Threshold Extension is a complex extension that defines a threshold needed to be met when measuring performance."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:threshold",
        "path" : "Extension.extension",
        "sliceName" : "threshold",
        "short" : "The threshold percentile",
        "definition" : "The threshold percentile",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:threshold.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:threshold.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "threshold"
      },
      {
        "id" : "Extension.extension:threshold.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "decimal"
          },
          {
            "code" : "Quantity"
          },
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Extension.extension:type",
        "path" : "Extension.extension",
        "sliceName" : "type",
        "short" : "The type or the name of the threshold",
        "definition" : "The type or the name of the threshold, such as star-2 threshold in star rating",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:type.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:type.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "type"
      },
      {
        "id" : "Extension.extension:type.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-vbpr/ValueSet/threshold-type"
        }
      },
      {
        "id" : "Extension.extension:gapToThreshold",
        "path" : "Extension.extension",
        "sliceName" : "gapToThreshold",
        "short" : "Gap to achieve the threshold",
        "definition" : "Gap to achieve the threshold",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:gapToThreshold.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:gapToThreshold.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "gapToThreshold"
      },
      {
        "id" : "Extension.extension:gapToThreshold.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "decimal"
          },
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
