# Score - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Score**

## Extension: Score 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Score |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.42.10 | | |

The Score Extension is used to specify the score of a measure, such as star score.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)
* Examples for this Extension: [MeasureReport/quality-measurereport01](MeasureReport-quality-measurereport01.md), [MeasureReport/quality-measurereport02](MeasureReport-quality-measurereport02.md), [MeasureReport/quality-measurereport03](MeasureReport-quality-measurereport03.md), [MeasureReport/quality-measurereport04](MeasureReport-quality-measurereport04.md)...Show 15 more,[MeasureReport/quality-measurereport05](MeasureReport-quality-measurereport05.md),[MeasureReport/quality-measurereport06](MeasureReport-quality-measurereport06.md),[MeasureReport/quality-measurereport07](MeasureReport-quality-measurereport07.md),[MeasureReport/quality-measurereport08](MeasureReport-quality-measurereport08.md),[MeasureReport/quality-measurereport09](MeasureReport-quality-measurereport09.md),[MeasureReport/quality-measurereport20](MeasureReport-quality-measurereport20.md),[MeasureReport/quality-measurereport21](MeasureReport-quality-measurereport21.md),[MeasureReport/quality-measurereport22](MeasureReport-quality-measurereport22.md),[MeasureReport/quality-measurereport23](MeasureReport-quality-measurereport23.md),[MeasureReport/quality-measurereport24](MeasureReport-quality-measurereport24.md),[MeasureReport/quality-measurereport25](MeasureReport-quality-measurereport25.md),[MeasureReport/quality-measurereport30](MeasureReport-quality-measurereport30.md),[MeasureReport/quality-measurereport31](MeasureReport-quality-measurereport31.md),[MeasureReport/quality-measurereport32](MeasureReport-quality-measurereport32.md)and[MeasureReport/quality-measurereport33](MeasureReport-quality-measurereport33.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-vbpr|current/StructureDefinition/score)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-score.csv), [Excel](StructureDefinition-score.xlsx), [Schematron](StructureDefinition-score.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "score",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.42.10"
    }
  ],
  "version" : "1.1.0",
  "name" : "Score",
  "title" : "Score",
  "status" : "active",
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The Score Extension is used to specify the score of a measure, such as star score.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MeasureReport"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Score",
        "definition" : "The Score Extension is used to specify the score of a measure, such as star score."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "decimal"
          }
        ]
      }
    ]
  }
}

```
