# vbp-provider02 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-provider02**

## Example Organization: vbp-provider02

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Davinci ATR Organization](http://hl7.org/fhir/us/davinci-atr/STU2.1/StructureDefinition-atr-organization.html)

**active**: true

**type**: Healthcare Provider

**name**: Every Hospital

**telecom**: ph: (+1) 456-123-7890, [contact@everyhospital.com](mailto:contact@everyhospital.com)

**address**: 100 Every Hospital Lane Amherst MA 01002 USA 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "vbp-provider02",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Provider"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "Provider organization the Value-Based Performance Report is for."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-atr/StructureDefinition/atr-organization"
    ]
  },
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov",
          "display" : "Healthcare Provider"
        }
      ]
    }
  ],
  "name" : "Every Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(+1) 456-123-7890"
    },
    {
      "system" : "email",
      "value" : "contact@everyhospital.com"
    }
  ],
  "address" : [
    {
      "line" : ["100 Every Hospital Lane"],
      "city" : "Amherst",
      "state" : "MA",
      "postalCode" : "01002",
      "country" : "USA"
    }
  ]
}

```
