# vbp-measurereport104 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-measurereport104**

## Example MeasureReport: vbp-measurereport104

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)

**Measure Report Category**: Value-Based Performance

**status**: Complete

**type**: Summary

**measure**: [Example Value-Based Contract - ABC Payer and EveryHospital](Measure-vbp-measure02.md)

**subject**: [Every Hospital](Group-everyhospital-group.md)

**date**: 2023-05-31

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-01-01 --> 2022-08-31

> **group**
> **id**group-01
**code**:Eligible member**measureScore**: 2914

> **group**
> **id**group-02
**code**:Hierarchical Condition Category**measureScore**:

> **group**
> **id**group-03
**code**:Preventive Care Visits**measureScore**:

> **group**
> **id**group-04
**code**:Star Performance**measureScore**:

> **group**
> **id**group-05
**code**:Advance Care Planning**measureScore**:

> **group**
> **id**group-06
**code**:Encounter Palliative Care**measureScore**:

> **group**
> **id**group-07
**code**:Supplemental Data**measureScore**:

> **group**
> **id**group-08
**code**:Estimated YTD Grand Total**measureScore**:

> **group**
> **id**group-09
**code**:Total gaps**measureScore**: 2

> **group**
> **id**group-10
**code**:Closed gaps**measureScore**: 2

> **group**
> **id**group-11
**code**:Minimum Base Incentive Target Percentage**measureScore**: 80 %(Details: UCUM code% = '%')

> **group**
> **id**group-12
**code**:Base Incentive Per Member**measureScore**:

> **group**
> **id**group-13
**code**:Early Performance Bonus Met**measureScore**:

> **group**
> **id**group-14
**code**:Estimated Bonus Incentive Per Member**measureScore**:

> **group**
> **id**group-15
**code**:Estimate Incentive**measureScore**:

**evaluatedResource**: 

* [MeasureReport: extension = Proportion,3,,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport30.md)
* [MeasureReport: extension = Proportion,5,,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport31.md)
* [MeasureReport: extension = Proportion,0,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-care-blood-sugar-controlled-FHIR|1.0.000; date = 2023-05-30; period = 2022-01-01 --> 2022-08-31; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport32.md)
* [MeasureReport: extension = Proportion,0,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-care-eye-exam-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport33.md)



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "vbp-measurereport104",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP MeasureReport Example 104"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
            "code" : "vbp"
          }
        ]
      }
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure02",
  "subject" : {
    "reference" : "Group/everyhospital-group",
    "display" : "Every Hospital"
  },
  "date" : "2023-05-31",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-01-01",
    "end" : "2022-08-31"
  },
  "group" : [
    {
      "id" : "group-01",
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "eligible-member"
          }
        ],
        "text" : "Eligible member"
      },
      "measureScore" : {
        "value" : 2914
      }
    },
    {
      "id" : "group-02",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "hcc"
          }
        ],
        "text" : "Hierarchical Condition Category"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 500,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-03",
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "quality-pmt-office-visit",
            "display" : "Quality payment annual office visit"
          }
        ],
        "text" : "Preventive Care Visits"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 180,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-04",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "star-performance"
          }
        ],
        "text" : "Star Performance"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 132884,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-05",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "advance-care-planning"
          }
        ],
        "text" : "Advance Care Planning"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 100,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-06",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "encounter-palliative-care"
          }
        ],
        "text" : "Encounter Palliative Care"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 1200,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-07",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "supplemental-data"
          }
        ],
        "text" : "Supplemental Data"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 0,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-08",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "closed-gaps"
          }
        ],
        "text" : "Estimated YTD Grand Total"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 134864,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-09",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "total-gaps"
          }
        ],
        "text" : "Total gaps"
      },
      "measureScore" : {
        "value" : 2
      }
    },
    {
      "id" : "group-10",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "closed-gaps"
          }
        ],
        "text" : "Closed gaps"
      },
      "measureScore" : {
        "value" : 2
      }
    },
    {
      "id" : "group-11",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "min-base-incentive-target"
          }
        ],
        "text" : "Minimum Base Incentive Target Percentage"
      },
      "measureScore" : {
        "value" : 80,
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      }
    },
    {
      "id" : "group-12",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "base-incentive-pm"
          }
        ],
        "text" : "Base Incentive Per Member"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 125,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-13",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "early-performance-bonus-met"
          }
        ],
        "text" : "Early Performance Bonus Met"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueBoolean" : false
          }
        ]
      }
    },
    {
      "id" : "group-14",
      "code" : {
        "coding" : [
          {
            "system" : "http://my-local-organization/CodeSystem/vbp-performance-metric",
            "code" : "estimated-bonus-incentive-pm"
          }
        ],
        "text" : "Estimated Bonus Incentive Per Member"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 0,
              "currency" : "USD"
            }
          }
        ]
      }
    },
    {
      "id" : "group-15",
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "earned-incentive",
            "display" : "Earned incentive"
          }
        ],
        "text" : "Estimate Incentive"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 500,
              "currency" : "USD"
            }
          }
        ]
      }
    }
  ],
  "evaluatedResource" : [
    {
      "reference" : "MeasureReport/quality-measurereport30"
    },
    {
      "reference" : "MeasureReport/quality-measurereport31"
    },
    {
      "reference" : "MeasureReport/quality-measurereport32"
    },
    {
      "reference" : "MeasureReport/quality-measurereport33"
    }
  ]
}

```
