# vbp-measurereport101 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **vbp-measurereport101**

## Example MeasureReport: vbp-measurereport101

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Value-Based Performance MeasureReport](StructureDefinition-vbp-performance-measurereport.md)

**Measure Report Category**: Value-Based Performance

**status**: Complete

**type**: Summary

**measure**: [Example Value-Based Contract - ABC Payer and GoodHealth](Measure-vbp-measure01.md)

**subject**: [Good Health Clinic](Group-goodhealth-group.md)

**date**: 2023-01-15

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-01-01 --> 2022-12-31

> **group**
> **id**ccf-group-01

> **Payment Stream**
* type: Care coordination fee

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Care coordination fee**measureScore**:
> **stratifier**
> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2



> **group**
> **id**ssq-group-starscore

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Weighted average star**measureScore**: 3.8

> **group**
> **id**ssq-group-01

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Member months**measureScore**: 300
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 100

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 50

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 50

> **stratum****value**:PPO cohort**measureScore**: 200

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 150

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 50


> **group**
> **id**ssq-group-02

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Average risk score**measureScore**: 0.7
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 0.8

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 0.9

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 1

> **stratum****value**:PPO cohort**measureScore**: 1.1

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 1.2

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 1.3


> **group**
> **id**ssq-group-03

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Total revenue**measureScore**: 10000
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 6000

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 3000

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 3000

> **stratum****value**:PPO cohort**measureScore**: 4000

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 2000

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 2000


> **group**
> **id**ssq-group-04

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Revenue PMPM**measureScore**: 33
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 60

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 60

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 60

> **stratum****value**:PPO cohort**measureScore**: 20

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 13

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 40


> **group**
> **id**ssq-group-05

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Medical pharmacy cost**measureScore**: 9000
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 5000

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 3000

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 2000

> **stratum****value**:PPO cohort**measureScore**: 4000

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 2000

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 3000


> **group**
> **id**ssq-group-06

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Medical pharmacy cost PMPM**measureScore**: 30
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 50

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 60

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 40

> **stratum****value**:PPO cohort**measureScore**: 20

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 13

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 60


> **group**
> **id**ssq-group-07

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Medical cost fund**measureScore**: 90 %(Details: UCUM code% = '%')
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 83.3 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 100 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 66.7 %(Details: UCUM code% = '%')

> **stratum****value**:PPO cohort**measureScore**: 100 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 100 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 150 %(Details: UCUM code% = '%')


> **group**
> **id**ssq-group-08

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Medical cost target**measureScore**: 85 %(Details: UCUM code% = '%')
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 85 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 85 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 85 %(Details: UCUM code% = '%')

> **stratum****value**:PPO cohort**measureScore**: 85 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 85 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 85 %(Details: UCUM code% = '%')


> **group**
> **id**ssq-group-09

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Medical pharmacy cost target**measureScore**: 8500
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 5100

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 2550

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 2550

> **stratum****value**:PPO cohort**measureScore**: 3400

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 1700

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 1700


> **group**
> **id**ssq-group-10

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Variance cost**measureScore**: -500
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 100

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 450

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 550

> **stratum****value**:PPO cohort**measureScore**: -600

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: -300

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: -1300


> **group**
> **id**ssq-group-11

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Average risk score market**measureScore**: 0.7
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 0.71

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 0.72

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 0.72

> **stratum****value**:PPO cohort**measureScore**: 0.71

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 0.7

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 0.69


> **group**
> **id**ssq-group-12

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Market average revenue PMPM**measureScore**: 35
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 40

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 32

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 36

> **stratum****value**:PPO cohort**measureScore**: 50

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 29

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 30


> **group**
> **id**ssq-group-13

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Market average medical pharmacy cost PMPM**measureScore**: 94.3 %(Details: UCUM code% = '%')
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 102.5 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 109.4 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 83.3 %(Details: UCUM code% = '%')

> **stratum****value**:PPO cohort**measureScore**: 70 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 103.4 %(Details: UCUM code% = '%')

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 110 %(Details: UCUM code% = '%')


> **group**
> **id**ssq-group-14

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Care coordination fee**measureScore**: 1500
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 500

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 250

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 250

> **stratum****value**:PPO cohort**measureScore**: 1000

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 750

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 250


> **group**
> **id**ssq-group-15

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Qulaity payment chronic**measureScore**: 11900
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 3966.67

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 1983.33

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 1983.33

> **stratum****value**:PPO cohort**measureScore**: 7933.33

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 5950

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 1983.33


> **group**
> **id**ssq-group-16

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Qulaity payment office visit**measureScore**: 300
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 100

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 50

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 50

> **stratum****value**:PPO cohort**measureScore**: 200

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: 150

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 50


> **group**
> **id**ssq-group-17

> **Payment Stream**
* type: Shared savings gated on quality

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Shared saving deficit**measureScore**: -400
> **stratifier**
> **stratum****value**:HMO cohort**measureScore**: 50

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: -360

> **stratum**
> **component****code**:Cohort**value**:HMO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: 275

> **stratum****value**:PPO cohort**measureScore**: -480

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 1
**measureScore**: -240

> **stratum**
> **component****code**:Cohort**value**:PPO cohort

> **component****code**:Facility**value**:Region 2
**measureScore**: -1040


> **group**
> **id**qip-group-01

> **Payment Stream**
* type: Quality incentive payment
* incentive: Annual office visit

**Service Period**: 2022-01-01 --> 2022-11-30**Paid Through Date**: 2022-12-31**code**:Average members with office visit**measureScore**: 87 %(Details: UCUM code% = '%')

> **group**
> **id**qip-group-02

> **Payment Stream**
* type: Quality incentive payment
* incentive: Chronic care management incentive program

**Service Period**: 2022-01-01 --> 2022-09-30**Paid Through Date**: 2022-09-30**code**:Eligible member**measureScore**: 500
> **stratifier****code**:Condition count
> **stratum****value**:1**measureScore**: 100

> **stratum****value**:2**measureScore**: 200

> **stratum****value**:3**measureScore**: 50

> **stratum****value**:4**measureScore**: 50

> **stratum****value**:5+**measureScore**: 100


> **group**
> **id**qip-group-03

> **Payment Stream**
* type: Quality incentive payment
* incentive: Chronic care management incentive program

**Service Period**: 2022-01-01 --> 2022-09-30**Paid Through Date**: 2022-09-30**code**:1 gap closed**measureScore**: 100
> **stratifier****code**:Condition count
> **stratum****value**:1**measureScore**: 20

> **stratum****value**:2**measureScore**: 30

> **stratum****value**:3**measureScore**: 20

> **stratum****value**:4**measureScore**: 10

> **stratum****value**:5+**measureScore**: 20


> **group**
> **id**qip-group-04

> **Payment Stream**
* type: Quality incentive payment
* incentive: Chronic care management incentive program

**Service Period**: 2022-01-01 --> 2022-09-30**Paid Through Date**: 2022-09-30**code**:2 gap closed**measureScore**: 0
> **stratifier****code**:Condition count
> **stratum****value**:1**measureScore**: 0

> **stratum****value**:2**measureScore**: 0

> **stratum****value**:3**measureScore**: 0

> **stratum****value**:4**measureScore**: 0

> **stratum****value**:5+**measureScore**: 0


> **group**
> **id**qip-group-05

> **Payment Stream**
* type: Quality incentive payment
* incentive: Chronic care management incentive program

**Service Period**: 2022-01-01 --> 2022-09-30**Paid Through Date**: 2022-09-30**code**:Interim payment rate
> **stratifier****code**:Condition count
> **stratum****value**:1**measureScore**: 20

> **stratum****value**:2**measureScore**: 50

> **stratum****value**:3**measureScore**: 100

> **stratum****value**:4**measureScore**: 200

> **stratum****value**:5+**measureScore**: 300


> **group**
> **id**qip-group-06

> **Payment Stream**
* type: Quality incentive payment
* incentive: Chronic care management incentive program

**Service Period**: 2022-01-01 --> 2022-09-30**Paid Through Date**: 2022-09-30**code**:Earned incentive**measureScore**: 11900
> **stratifier****code**:Condition count
> **stratum****value**:1**measureScore**: 400

> **stratum****value**:2**measureScore**: 1500

> **stratum****value**:3**measureScore**: 2000

> **stratum****value**:4**measureScore**: 2000

> **stratum****value**:5+**measureScore**: 6000


**evaluatedResource**: 

* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport01.md)
* [MeasureReport: extension = Proportion,5,,,,; status = complete; type = summary; measure = http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport02.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-care-blood-sugar-controlled-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport03.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-diabetes-care-eye-exam-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport04.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-med-adherence-cholesterol-statins-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport05.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport06.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-med-adherence-diabetes-meds-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport07.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-statin-therapy-cardiovascular-disease-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport08.md)
* [MeasureReport: extension = Proportion,0,,,,; status = complete; type = summary; measure = http://example.org/Measure/measure-statin-use-diabetes-supd-FHIR|1.0.000; date = 2023-01-15; period = 2022-01-01 --> 2022-11-30; improvementNotation = Increased score indicates improvement](MeasureReport-quality-measurereport09.md)



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "vbp-measurereport101",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP MeasureReport Example 101"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Value-Based Performance MeasureReport for the *VBP MeasureReport* profile., which includes examples for payment streams shared savings - gated on quality, care coordination fee, quality incentive payment for the chronic care management incentive program, quality incentive payment for the annual office visits, and quality measure performance."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-performance-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
            "code" : "vbp"
          }
        ]
      }
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure01",
  "subject" : {
    "reference" : "Group/goodhealth-group",
    "display" : "Good Health Clinic"
  },
  "date" : "2023-01-15",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-01-01",
    "end" : "2022-12-31"
  },
  "group" : [
    {
      "id" : "ccf-group-01",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ccf"
                  }
                ],
                "text" : "Care coordination fee"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "ccf"
          }
        ],
        "text" : "Care coordination fee"
      },
      "measureScore" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/alternate-measurescore",
            "valueMoney" : {
              "value" : 500,
              "currency" : "USD"
            }
          }
        ]
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ]
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ]
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ]
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-starscore",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "weighted-avg-star"
          }
        ],
        "text" : "Weighted average star"
      },
      "measureScore" : {
        "value" : 3.8
      }
    },
    {
      "id" : "ssq-group-01",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "member-months"
          }
        ],
        "text" : "Member months"
      },
      "measureScore" : {
        "value" : 300
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 100
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 200
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 150
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 50
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-02",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "avg-risk-score"
          }
        ],
        "text" : "Average risk score"
      },
      "measureScore" : {
        "value" : 0.7
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 0.8
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 0.9
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 1.1
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1.2
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1.3
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-03",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "revenue"
          }
        ],
        "text" : "Total revenue"
      },
      "measureScore" : {
        "value" : 10000
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 6000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 3000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 3000
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 4000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 2000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 2000
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-04",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "revenue-pmpm"
          }
        ],
        "text" : "Revenue PMPM"
      },
      "measureScore" : {
        "value" : 33
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 60
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 60
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 60
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 20
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 13
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 40
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-05",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "med-rx-cost"
          }
        ],
        "text" : "Medical pharmacy cost"
      },
      "measureScore" : {
        "value" : 9000
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 5000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 3000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 2000
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 4000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 2000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 3000
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-06",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "med-rx-cost-pmpm"
          }
        ],
        "text" : "Medical pharmacy cost PMPM"
      },
      "measureScore" : {
        "value" : 30
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 60
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 40
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 20
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 13
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 60
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-07",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "med-cost-fund"
          }
        ],
        "text" : "Medical cost fund"
      },
      "measureScore" : {
        "value" : 90,
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 83.3,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 100,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 66.7,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 100,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 100,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 150,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-08",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "med-cost-target"
          }
        ],
        "text" : "Medical cost target"
      },
      "measureScore" : {
        "value" : 85,
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 85,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 85,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 85,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 85,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 85,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 85,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-09",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "med-rx-cost-target"
          }
        ],
        "text" : "Medical pharmacy cost target"
      },
      "measureScore" : {
        "value" : 8500
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 5100
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 2550
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 2550
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 3400
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1700
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1700
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-10",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "variance-cost"
          }
        ],
        "text" : "Variance cost"
      },
      "measureScore" : {
        "value" : -500
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 100
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 450
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 550
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : -600
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : -300
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : -1300
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-11",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "avg-risk-score-market"
          }
        ],
        "text" : "Average risk score market"
      },
      "measureScore" : {
        "value" : 0.7
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 0.71
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 0.72
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 0.72
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 0.71
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 0.7
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 0.69
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-12",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "avg-revenue-pmpm-market"
          }
        ]
      },
      "measureScore" : {
        "value" : 35
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 40
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 32
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 36
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 29
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 30
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-13",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "avg-med-rx-cost-pmpm-market"
          }
        ]
      },
      "measureScore" : {
        "value" : 94.3,
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 102.5,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 109.4,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 83.3,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 70,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 103.4,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 110,
                "system" : "http://unitsofmeasure.org",
                "code" : "%"
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-14",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "ccf"
          }
        ],
        "text" : "Care coordination fee"
      },
      "measureScore" : {
        "value" : 1500
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 500
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 250
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 250
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 1000
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 750
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 250
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-15",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "quality-pmt-chronic"
          }
        ],
        "text" : "Qulaity payment chronic"
      },
      "measureScore" : {
        "value" : 11900
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 3966.67
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1983.33
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1983.33
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 7933.33
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 5950
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 1983.33
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-16",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "quality-pmt-office-visit"
          }
        ],
        "text" : "Qulaity payment office visit"
      },
      "measureScore" : {
        "value" : 300
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 100
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 200
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : 150
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 50
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "ssq-group-17",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "ssq"
                  }
                ],
                "text" : "Shared savings gated on quality"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "shared-saving-deficit"
          }
        ],
        "text" : "Shared saving deficit"
      },
      "measureScore" : {
        "value" : -400
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "hmo"
                  }
                ]
              },
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : -360
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "hmo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : 275
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                    "code" : "ppo"
                  }
                ]
              },
              "measureScore" : {
                "value" : -480
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "measureScore" : {
                "value" : -240
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "cohort"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                        "code" : "ppo"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
                        "code" : "facility"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "measureScore" : {
                "value" : -1040
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "qip-group-01",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "qip"
                  }
                ],
                "text" : "Quality incentive payment"
              }
            },
            {
              "url" : "incentive",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
                    "code" : "annual-visit"
                  }
                ],
                "text" : "Annual office visit"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-11-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-12-31"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "avg-member-office-visit"
          }
        ],
        "text" : "Average members with office visit"
      },
      "measureScore" : {
        "value" : 87,
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      }
    },
    {
      "id" : "qip-group-02",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "qip"
                  }
                ],
                "text" : "Quality incentive payment"
              }
            },
            {
              "url" : "incentive",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
                    "code" : "chronic-care-mgmt"
                  }
                ],
                "text" : "Chronic care management incentive program"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-09-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-09-30"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "eligible-member"
          }
        ],
        "text" : "Eligible member"
      },
      "measureScore" : {
        "value" : 500
      },
      "stratifier" : [
        {
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
                  "code" : "condition-count"
                }
              ]
            }
          ],
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6112-2"
                  }
                ],
                "text" : "1"
              },
              "measureScore" : {
                "value" : 100
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6113-0"
                  }
                ],
                "text" : "2"
              },
              "measureScore" : {
                "value" : 200
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6114-8"
                  }
                ],
                "text" : "3"
              },
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6115-5"
                  }
                ],
                "text" : "4"
              },
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA10137-0"
                  }
                ],
                "text" : "5+"
              },
              "measureScore" : {
                "value" : 100
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "qip-group-03",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "qip"
                  }
                ],
                "text" : "Quality incentive payment"
              }
            },
            {
              "url" : "incentive",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
                    "code" : "chronic-care-mgmt"
                  }
                ],
                "text" : "Chronic care management incentive program"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-09-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-09-30"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "1-gap-closed"
          }
        ],
        "text" : "1 gap closed"
      },
      "measureScore" : {
        "value" : 100
      },
      "stratifier" : [
        {
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
                  "code" : "condition-count"
                }
              ]
            }
          ],
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6112-2"
                  }
                ],
                "text" : "1"
              },
              "measureScore" : {
                "value" : 20
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6113-0"
                  }
                ],
                "text" : "2"
              },
              "measureScore" : {
                "value" : 30
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6114-8"
                  }
                ],
                "text" : "3"
              },
              "measureScore" : {
                "value" : 20
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6115-5"
                  }
                ],
                "text" : "4"
              },
              "measureScore" : {
                "value" : 10
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA10137-0"
                  }
                ],
                "text" : "5+"
              },
              "measureScore" : {
                "value" : 20
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "qip-group-04",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "qip"
                  }
                ],
                "text" : "Quality incentive payment"
              }
            },
            {
              "url" : "incentive",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
                    "code" : "chronic-care-mgmt"
                  }
                ],
                "text" : "Chronic care management incentive program"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-09-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-09-30"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "2-gap-closed"
          }
        ],
        "text" : "2 gap closed"
      },
      "measureScore" : {
        "value" : 0
      },
      "stratifier" : [
        {
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
                  "code" : "condition-count"
                }
              ]
            }
          ],
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6112-2"
                  }
                ],
                "text" : "1"
              },
              "measureScore" : {
                "value" : 0
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6113-0"
                  }
                ],
                "text" : "2"
              },
              "measureScore" : {
                "value" : 0
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6114-8"
                  }
                ],
                "text" : "3"
              },
              "measureScore" : {
                "value" : 0
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6115-5"
                  }
                ],
                "text" : "4"
              },
              "measureScore" : {
                "value" : 0
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA10137-0"
                  }
                ],
                "text" : "5+"
              },
              "measureScore" : {
                "value" : 0
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "qip-group-05",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "qip"
                  }
                ],
                "text" : "Quality incentive payment"
              }
            },
            {
              "url" : "incentive",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
                    "code" : "chronic-care-mgmt"
                  }
                ],
                "text" : "Chronic care management incentive program"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-09-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-09-30"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "interim-pmt-rate"
          }
        ],
        "text" : "Interim payment rate"
      },
      "stratifier" : [
        {
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
                  "code" : "condition-count"
                }
              ]
            }
          ],
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6112-2"
                  }
                ],
                "text" : "1"
              },
              "measureScore" : {
                "value" : 20
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6113-0"
                  }
                ],
                "text" : "2"
              },
              "measureScore" : {
                "value" : 50
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6114-8"
                  }
                ],
                "text" : "3"
              },
              "measureScore" : {
                "value" : 100
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6115-5"
                  }
                ],
                "text" : "4"
              },
              "measureScore" : {
                "value" : 200
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA10137-0"
                  }
                ],
                "text" : "5+"
              },
              "measureScore" : {
                "value" : 300
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "qip-group-06",
      "extension" : [
        {
          "extension" : [
            {
              "url" : "type",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                    "code" : "qip"
                  }
                ],
                "text" : "Quality incentive payment"
              }
            },
            {
              "url" : "incentive",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
                    "code" : "chronic-care-mgmt"
                  }
                ],
                "text" : "Chronic care management incentive program"
              }
            }
          ],
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/service-period",
          "valuePeriod" : {
            "start" : "2022-01-01",
            "end" : "2022-09-30"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/paid-through-date",
          "valueDate" : "2022-09-30"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
            "code" : "earned-incentive"
          }
        ],
        "text" : "Earned incentive"
      },
      "measureScore" : {
        "value" : 11900
      },
      "stratifier" : [
        {
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
                  "code" : "condition-count"
                }
              ]
            }
          ],
          "stratum" : [
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6112-2"
                  }
                ],
                "text" : "1"
              },
              "measureScore" : {
                "value" : 400
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6113-0"
                  }
                ],
                "text" : "2"
              },
              "measureScore" : {
                "value" : 1500
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6114-8"
                  }
                ],
                "text" : "3"
              },
              "measureScore" : {
                "value" : 2000
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA6115-5"
                  }
                ],
                "text" : "4"
              },
              "measureScore" : {
                "value" : 2000
              }
            },
            {
              "value" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "LA10137-0"
                  }
                ],
                "text" : "5+"
              },
              "measureScore" : {
                "value" : 6000
              }
            }
          ]
        }
      ]
    }
  ],
  "evaluatedResource" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport01"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport02"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport04"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport05"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport06"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport07"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport08"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/group-reference",
          "valueString" : "ssq-group-starscore"
        }
      ],
      "reference" : "MeasureReport/quality-measurereport09"
    }
  ]
}

```
