# quality-measurereport20 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **quality-measurereport20**

## Example MeasureReport: quality-measurereport20

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Information Source: [http://example.org/fhir/server](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/fhir/server)

Profile: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)

**DEQM Measure Scoring Extension**: Proportion

**Score**: 2

> **Threshold**
* threshold: 71.7 %(Details: UCUM code% = '%')
* type: HEDIS 50 Percentile

> **Threshold**
* threshold: 74.3 %(Details: UCUM code% = '%')
* type: HEDIS 75 Percentile

> **Threshold**
* threshold: 77.3 %(Details: UCUM code% = '%')
* type: HEDIS 90 Percentile

**status**: Complete

**type**: Summary

**measure**: [EXM125 - Breast Cancer Screeningversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM125-FHIR.html)

**date**: 2022-12-31

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-10-01 --> 2022-12-31

**improvementNotation**: Increased score indicates improvement

> **group**
> **population**
> **id**pop3
**code**:Initial Population**count**: 40

> **population**
> **id**pop4
**code**:Denominator**count**: 40

> **population**
> **id**pop5
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**pop6
**code**:Numerator**count**: 30
**measureScore**: 0.75



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "quality-measurereport20",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP Quality MeasureReport Example"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Breast Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile."
      }
    ],
    "source" : "http://example.org/fhir/server",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
            "code" : "proportion"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score",
      "valueDecimal" : 2
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 71.7,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "hedis-50-percentile"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 74.3,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "hedis-75-percentile"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 77.3,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "hedis-90-percentile"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000",
  "date" : "2022-12-31",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-10-01",
    "end" : "2022-12-31"
  },
  "improvementNotation" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
        "code" : "increase",
        "display" : "Increased score indicates improvement"
      }
    ]
  },
  "group" : [
    {
      "population" : [
        {
          "id" : "pop3",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population"
              }
            ]
          },
          "count" : 40
        },
        {
          "id" : "pop4",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator"
              }
            ]
          },
          "count" : 40
        },
        {
          "id" : "pop5",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion"
              }
            ]
          },
          "count" : 0
        },
        {
          "id" : "pop6",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator"
              }
            ]
          },
          "count" : 30
        }
      ],
      "measureScore" : {
        "value" : 0.75
      }
    }
  ]
}

```
