# quality-measurereport02 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **quality-measurereport02**

## Example MeasureReport: quality-measurereport02

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Information Source: [http://example.org/fhir/server](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/fhir/server)

Profile: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)

**DEQM Measure Scoring Extension**: Proportion

**Score**: 5

> **Threshold**
* threshold: 40 %(Details: UCUM code% = '%')
* type: Star 2

> **Threshold**
* threshold: 50 %(Details: UCUM code% = '%')
* type: Star 3

> **Threshold**
* threshold: 60 %(Details: UCUM code% = '%')
* type: Star 4

> **Threshold**
* threshold: 70 %(Details: UCUM code% = '%')
* type: Star 5

**status**: Complete

**type**: Summary

**measure**: [EXM130 - Colorectal Cancer Screening Measureversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM130-FHIR.html)

**date**: 2023-01-15

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-01-01 --> 2022-11-30

**improvementNotation**: Increased score indicates improvement

> **group**
> **population**
> **id**pop1
**code**:Initial Population**count**: 520

> **population**
> **id**pop2
**code**:Denominator**count**: 520

> **population**
> **id**pop3
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**pop4
**code**:Numerator**count**: 180
**measureScore**: 0.356
> **stratifier**
> **stratum**
> **component****code**:Coverage type**value**:health maintenance organization policy

> **component****code**:location**value**:Region 1

> **population**
> **id**strat-pop3
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop4
**code**:Numerator**count**: 70
**measureScore**: 0.7

> **stratum**
> **component****code**:Coverage type**value**:health maintenance organization policy

> **component****code**:location**value**:Region 2

> **population**
> **id**strat-pop7
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop8
**code**:Numerator**count**: 20
**measureScore**: 0.13

> **stratum**
> **component****code**:Coverage type**value**:preferred provider organization policy

> **component****code**:location**value**:Region 1

> **population**
> **id**strat-pop11
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop12
**code**:Numerator**count**: 70
**measureScore**: 0.7

> **stratum**
> **component****code**:Coverage type**value**:preferred provider organization policy

> **component****code**:location**value**:Region 2

> **population**
> **id**strat-pop15
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop16
**code**:Numerator**count**: 20
**measureScore**: 0.13




## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "quality-measurereport02",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP Quality MeasureReport Example"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Colorectal Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile."
      }
    ],
    "source" : "http://example.org/fhir/server",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
            "code" : "proportion"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score",
      "valueDecimal" : 5
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 40,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-2"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 50,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-3"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 60,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-4"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 70,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-5"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000",
  "date" : "2023-01-15",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-01-01",
    "end" : "2022-11-30"
  },
  "improvementNotation" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
        "code" : "increase",
        "display" : "Increased score indicates improvement"
      }
    ]
  },
  "group" : [
    {
      "population" : [
        {
          "id" : "pop1",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population"
              }
            ]
          },
          "count" : 520
        },
        {
          "id" : "pop2",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator"
              }
            ]
          },
          "count" : 520
        },
        {
          "id" : "pop3",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion"
              }
            ]
          },
          "count" : 0
        },
        {
          "id" : "pop4",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator"
              }
            ]
          },
          "count" : 180
        }
      ],
      "measureScore" : {
        "value" : 0.356
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "HMO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop3",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop4",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 70
                }
              ],
              "measureScore" : {
                "value" : 0.7
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "HMO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop7",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop8",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 20
                }
              ],
              "measureScore" : {
                "value" : 0.13
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "PPO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop11",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop12",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 70
                }
              ],
              "measureScore" : {
                "value" : 0.7
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "PPO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop15",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop16",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 20
                }
              ],
              "measureScore" : {
                "value" : 0.13
              }
            }
          ]
        }
      ]
    }
  ]
}

```
