# quality-measurereport01 - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **quality-measurereport01**

## Example MeasureReport: quality-measurereport01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Information Source: [http://example.org/fhir/server](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/fhir/server)

Profile: [VBP Quality MeasureReport](StructureDefinition-vbp-quality-measurereport.md)

**DEQM Measure Scoring Extension**: Proportion

**Score**: 0

> **Threshold**
* threshold: 85 %(Details: UCUM code% = '%')
* type: Star 2

> **Threshold**
* threshold: 88 %(Details: UCUM code% = '%')
* type: Star 3

> **Threshold**
* threshold: 91 %(Details: UCUM code% = '%')
* type: Star 4

> **Threshold**
* threshold: 95 %(Details: UCUM code% = '%')
* type: Star 5

**status**: Complete

**type**: Summary

**measure**: [EXM125 - Breast Cancer Screeningversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM125-FHIR.html)

**date**: 2023-01-15

**reporter**: [Organization ABC Payer](Organization-vbp-payer01.md)

**period**: 2022-01-01 --> 2022-11-30

**improvementNotation**: Increased score indicates improvement

> **group**
> **population**
> **id**pop1
**code**:Initial Population**count**: 580

> **population**
> **id**pop2
**code**:Denominator**count**: 580

> **population**
> **id**pop3
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**pop4
**code**:Numerator**count**: 200
**measureScore**: 0.345
> **stratifier**
> **stratum**
> **component****code**:Coverage type**value**:health maintenance organization policy

> **component****code**:location**value**:Region 1

> **population**
> **id**strat-pop3
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop4
**code**:Numerator**count**: 50
**measureScore**: 0.25

> **stratum**
> **component****code**:Coverage type**value**:health maintenance organization policy

> **component****code**:location**value**:Region 2

> **population**
> **id**strat-pop7
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop8
**code**:Numerator**count**: 50
**measureScore**: 0.56

> **stratum**
> **component****code**:Coverage type**value**:preferred provider organization policy

> **component****code**:location**value**:Region 1

> **population**
> **id**strat-pop11
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop12
**code**:Numerator**count**: 50
**measureScore**: 0.25

> **stratum**
> **component****code**:Coverage type**value**:preferred provider organization policy

> **component****code**:location**value**:Region 2

> **population**
> **id**strat-pop15
**code**:Denominator Exclusion**count**: 0

> **population**
> **id**strat-pop16
**code**:Numerator**count**: 50
**measureScore**: 0.56




## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "quality-measurereport01",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "VBP Quality MeasureReport Example"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example Breast Cancer Screening MeasureReport for the *VBP Quality MeasureReport* profile."
      }
    ],
    "source" : "http://example.org/fhir/server",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-quality-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-measureScoring",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/measure-scoring",
            "code" : "proportion"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/score",
      "valueDecimal" : 0
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 85,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-2"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 88,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-3"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 91,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-4"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    },
    {
      "extension" : [
        {
          "url" : "threshold",
          "valueQuantity" : {
            "value" : 95,
            "system" : "http://unitsofmeasure.org",
            "code" : "%"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
                "code" : "star-5"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/threshold"
    }
  ],
  "status" : "complete",
  "type" : "summary",
  "measure" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000",
  "date" : "2023-01-15",
  "reporter" : {
    "reference" : "Organization/vbp-payer01"
  },
  "period" : {
    "start" : "2022-01-01",
    "end" : "2022-11-30"
  },
  "improvementNotation" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
        "code" : "increase",
        "display" : "Increased score indicates improvement"
      }
    ]
  },
  "group" : [
    {
      "population" : [
        {
          "id" : "pop1",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "initial-population"
              }
            ]
          },
          "count" : 580
        },
        {
          "id" : "pop2",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator"
              }
            ]
          },
          "count" : 580
        },
        {
          "id" : "pop3",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "denominator-exclusion"
              }
            ]
          },
          "count" : 0
        },
        {
          "id" : "pop4",
          "code" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                "code" : "numerator"
              }
            ]
          },
          "count" : 200
        }
      ],
      "measureScore" : {
        "value" : 0.345
      },
      "stratifier" : [
        {
          "stratum" : [
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "HMO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop3",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop4",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 50
                }
              ],
              "measureScore" : {
                "value" : 0.25
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "HMO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop7",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop8",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 50
                }
              ],
              "measureScore" : {
                "value" : 0.56
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "PPO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 1"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop11",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop12",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 50
                }
              ],
              "measureScore" : {
                "value" : 0.25
              }
            },
            {
              "component" : [
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "87520-3"
                      }
                    ]
                  },
                  "value" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "PPO"
                      }
                    ]
                  }
                },
                {
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                        "code" : "LOC"
                      }
                    ]
                  },
                  "value" : {
                    "text" : "Region 2"
                  }
                }
              ],
              "population" : [
                {
                  "id" : "strat-pop15",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "denominator-exclusion"
                      }
                    ]
                  },
                  "count" : 0
                },
                {
                  "id" : "strat-pop16",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/measure-population",
                        "code" : "numerator"
                      }
                    ]
                  },
                  "count" : 50
                }
              ],
              "measureScore" : {
                "value" : 0.56
              }
            }
          ]
        }
      ]
    }
  ]
}

```
