# Example Value-Based Contract - ABC Payer and EveryHospital - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Value-Based Contract - ABC Payer and EveryHospital**

## Measure: Example Value-Based Contract - ABC Payer and EveryHospital (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure02 | *Version*:1.1.0 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:VbprMeasureExample02 |
| *Other Identifiers:*http://example.org/fhir/server#ex-vbp-measure02 (use: temp, ), OID:2.16.840.1.113883.4.642.40.30.29.2 | |

 
Example Value-Based Contract between ABC Payer and EveryHospital 

* Knowledge Artifact Metadata: Name (machine-readable)
  * ?: VbprMeasureExample02
* Knowledge Artifact Metadata: Title (human-readable)
  * ?: Example Value-Based Contract - ABC Payer and EveryHospital
* Knowledge Artifact Metadata: Status
  * ?: Active
* Knowledge Artifact Metadata: Experimental
  * ?: true
* Knowledge Artifact Metadata: Description
  * ?: Example Value-Based Contract between ABC Payer and EveryHospital
* Knowledge Artifact Metadata: Effective Period
  * ?: 2022-10-01..2023-09-30
* Knowledge Artifact Metadata: Measure Steward
  * ?: HL7 International / Clinical Quality Information
* Knowledge Artifact Metadata: Steward Contact Details
  * ?: HL7 International / Clinical Quality Information:[http://www.hl7.org/Special/committees/cqi](http://www.hl7.org/Special/committees/cqi)
* Knowledge Artifact Metadata: **Description**: Breast Cancer Screening**Resource**:[EXM125 - Breast Cancer Screeningversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM125-FHIR.html)**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000
* Knowledge Artifact Metadata: **Description**: Colorectal Cancer Screening**Resource**:[EXM130 - Colorectal Cancer Screening Measureversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM130-FHIR.html)**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000
* Knowledge Artifact Metadata: **Description**: Diabetic Retinopathy: Communication with the Physician Managing Ongoing Diabetes Care**Resource**:[http://example.org/Measure/measure-diabetes-retinopathy-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-diabetes-retinopathy-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-diabetes-retinopathy-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Diabetes: Hemoglobin A1c (HbA1c) Poor Control (> 9%)**Resource**:[http://example.org/Measure/measure-diabetes-A1c-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-diabetes-A1c-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-diabetes-A1c-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Diabetes: Medical Attention for Nephropathy**Resource**:[http://example.org/Measure/measure-diabetes-nephropathy-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-diabetes-nephropathy-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-diabetes-nephropathy-FHIR|1.0.000
* Knowledge Artifact Metadata: Measure Metadata
* Knowledge Artifact Metadata: Version Number
  * ?: 1.1.0
* Knowledge Artifact Metadata: Generated using version 0.4.6 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "vbp-measure02",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Payer"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example measure for the *VBP Measure* profile."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                "code" : "ubip",
                "display" : "Utilization incentive payment"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
    },
    {
      "extension" : [
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                "code" : "p4p",
                "display" : "Pay for performance"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
    }
  ],
  "url" : "https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure02",
  "identifier" : [
    {
      "use" : "temp",
      "system" : "http://example.org/fhir/server",
      "value" : "ex-vbp-measure02"
    },
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.29.2"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbprMeasureExample02",
  "title" : "Example Value-Based Contract - ABC Payer and EveryHospital",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Example Value-Based Contract between ABC Payer and EveryHospital",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "effectivePeriod" : {
    "start" : "2022-10-01",
    "end" : "2023-09-30"
  },
  "relatedArtifact" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 1
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Breast Cancer Screening",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Colorectal Cancer Screening",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual-alternate"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Diabetic Retinopathy: Communication with the Physician Managing Ongoing Diabetes Care",
      "resource" : "http://example.org/Measure/measure-diabetes-retinopathy-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual-alternate"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Diabetes: Hemoglobin A1c (HbA1c) Poor Control (> 9%)",
      "resource" : "http://example.org/Measure/measure-diabetes-A1c-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "reporting-only"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Diabetes: Medical Attention for Nephropathy",
      "resource" : "http://example.org/Measure/measure-diabetes-nephropathy-FHIR|1.0.000"
    }
  ]
}

```
