# Example Value-Based Contract - ABC Payer and GoodHealth - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Value-Based Contract - ABC Payer and GoodHealth**

## Measure: Example Value-Based Contract - ABC Payer and GoodHealth (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure01 | *Version*:1.1.0 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:VbprMeasureExample01 |
| *Other Identifiers:*http://example.org/fhir/server#ex-vbp-measure01 (use: temp, ), OID:2.16.840.1.113883.4.642.40.30.29.1 | |

 
Example Value-Based Contract between ABC Payer and GoodHealth 

* Knowledge Artifact Metadata: Name (machine-readable)
  * ?: VbprMeasureExample01
* Knowledge Artifact Metadata: Title (human-readable)
  * ?: Example Value-Based Contract - ABC Payer and GoodHealth
* Knowledge Artifact Metadata: Status
  * ?: Active
* Knowledge Artifact Metadata: Experimental
  * ?: true
* Knowledge Artifact Metadata: Description
  * ?: Example Value-Based Contract between ABC Payer and GoodHealth
* Knowledge Artifact Metadata: Effective Period
  * ?: 2022-01-01..2024-12-31
* Knowledge Artifact Metadata: Measure Steward
  * ?: HL7 International / Clinical Quality Information
* Knowledge Artifact Metadata: Steward Contact Details
  * ?: HL7 International / Clinical Quality Information:[http://www.hl7.org/Special/committees/cqi](http://www.hl7.org/Special/committees/cqi)
* Knowledge Artifact Metadata: **Description**: Breast Cancer Screening**Resource**:[EXM125 - Breast Cancer Screeningversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM125-FHIR.html)**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000
* Knowledge Artifact Metadata: **Description**: Colorectal Cancer Screening**Resource**:[EXM130 - Colorectal Cancer Screening Measureversion: null8.0.000)](http://hl7.org/fhir/us/cqfmeasures/STU5/Measure-EXM130-FHIR.html)**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000
* Knowledge Artifact Metadata: **Description**: Diabetes Care - Blood Sugar Controlled**Resource**:[http://example.org/Measure/measure-diabetes-care-blood-sugar-controlled-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-diabetes-care-blood-sugar-controlled-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-diabetes-care-blood-sugar-controlled-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Diabetes Care - Eye Exam**Resource**:[http://example.org/Measure/measure-diabetes-care-eye-exam-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-diabetes-care-eye-exam-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-diabetes-care-eye-exam-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Medication Adherence for Cholesterol (Statins)**Resource**:[http://example.org/Measure/measure-med-adherence-cholesterol-statins-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-med-adherence-cholesterol-statins-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-med-adherence-cholesterol-statins-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Medication Adherence for Hypertension (RAS antagonists)**Resource**:[http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Medication Adherence for Diabetes Medications**Resource**:[http://example.org/Measure/measure-med-adherence-diabetes-meds-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-med-adherence-diabetes-meds-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-med-adherence-diabetes-meds-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Statin Therapy for Patients with Cardiovascular Disease**Resource**:[http://example.org/Measure/measure-statin-therapy-cardiovascular-disease-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-statin-therapy-cardiovascular-disease-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-statin-therapy-cardiovascular-disease-FHIR|1.0.000
* Knowledge Artifact Metadata: **Description**: Statin Use in Persons with Diabetes (SUPD)**Resource**:[http://example.org/Measure/measure-statin-use-diabetes-supd-FHIR|1.0.000](https://simplifier.net/resolve?scope=hl7.fhir.us.davinci-atr@2.1.0&canonical=http://example.org/Measure/measure-statin-use-diabetes-supd-FHIR|1.0.000)**Canonical URL**:http://example.org/Measure/measure-statin-use-diabetes-supd-FHIR|1.0.000
* Knowledge Artifact Metadata: Measure Metadata
* Knowledge Artifact Metadata: Version Number
  * ?: 1.1.0
* Knowledge Artifact Metadata: Generated using version 0.4.6 of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Measure",
  "id" : "vbp-measure01",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Payer"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example measure for the *VBP Measure* profile."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/vbp-measure"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/lob",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://nahdo.org/sopt",
            "code" : "1",
            "display" : "MEDICARE"
          }
        ],
        "text" : "MEDICARE"
      }
    },
    {
      "extension" : [
        {
          "url" : "hcplan",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework",
                "code" : "3A",
                "display" : "Category 3A"
              }
            ]
          }
        },
        {
          "url" : "cohort",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                "code" : "hmo",
                "display" : "HMO cohort"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/program-model"
    },
    {
      "extension" : [
        {
          "url" : "hcplan",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework",
                "code" : "3B",
                "display" : "Category 3B"
              }
            ]
          }
        },
        {
          "url" : "cohort",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-cohort",
                "code" : "ppo",
                "display" : "PPO cohort"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/program-model"
    },
    {
      "extension" : [
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                "code" : "ssq"
              }
            ],
            "text" : "Shared savings gated on quality"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
    },
    {
      "extension" : [
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                "code" : "ccf"
              }
            ],
            "text" : "Care coordination fee"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
    },
    {
      "extension" : [
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
                "code" : "qip"
              }
            ],
            "text" : "Quality incentive payment"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/payment-stream"
    }
  ],
  "url" : "https://build.fhir.org/ig/HL7/davinci-vbpr/Measure-vbp-measure01",
  "identifier" : [
    {
      "use" : "temp",
      "system" : "http://example.org/fhir/server",
      "value" : "ex-vbp-measure01"
    },
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.29.1"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbprMeasureExample01",
  "title" : "Example Value-Based Contract - ABC Payer and GoodHealth",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Example Value-Based Contract between ABC Payer and GoodHealth",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "effectivePeriod" : {
    "start" : "2022-01-01",
    "end" : "2024-12-31"
  },
  "relatedArtifact" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 1
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Breast Cancer Screening",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM125-FHIR|8.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Colorectal Cancer Screening",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/Measure/EXM130-FHIR|8.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Diabetes Care - Blood Sugar Controlled",
      "resource" : "http://example.org/Measure/measure-diabetes-care-blood-sugar-controlled-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Diabetes Care - Eye Exam",
      "resource" : "http://example.org/Measure/measure-diabetes-care-eye-exam-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "reporting-only",
                "display" : "Reporting Only"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Medication Adherence for Cholesterol (Statins)",
      "resource" : "http://example.org/Measure/measure-med-adherence-cholesterol-statins-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Medication Adherence for Hypertension (RAS antagonists)",
      "resource" : "http://example.org/Measure/measure-med-adherence-hypertension-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 3
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Medication Adherence for Diabetes Medications",
      "resource" : "http://example.org/Measure/measure-med-adherence-diabetes-meds-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 1
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Statin Therapy for Patients with Cardiovascular Disease",
      "resource" : "http://example.org/Measure/measure-statin-therapy-cardiovascular-disease-FHIR|1.0.000"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight",
          "valueDecimal" : 1
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-contractual-status",
                "code" : "contractual",
                "display" : "Contractual"
              }
            ]
          }
        }
      ],
      "type" : "composed-of",
      "display" : "Statin Use in Persons with Diabetes (SUPD)",
      "resource" : "http://example.org/Measure/measure-statin-use-diabetes-supd-FHIR|1.0.000"
    }
  ]
}

```
