# Performance Metric Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Performance Metric Codes**

## CodeSystem: Performance Metric Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:VbpPerformanceMetricsCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.9 | | |

 
Type of value-based performance metrics. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VbpPerformanceMetricsVS](ValueSet-vbp-performance-metric.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "vbp-performance-metric",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-performance-metric",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.9"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbpPerformanceMetricsCS",
  "title" : "Performance Metric Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Type of value-based performance metrics.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 93,
  "concept" : [
    {
      "code" : "avg-risk-score",
      "display" : "Average risk score",
      "definition" : "Average risk score is a numeric score where a higher score indicates a riskier population on average. Example scores: 0.70, 1.00, 1.30."
    },
    {
      "code" : "avg-risk-score-market",
      "display" : "Market average risk score",
      "definition" : "The market average risk score."
    },
    {
      "code" : "capitation",
      "display" : "Capitation",
      "definition" : "Total capitation amount."
    },
    {
      "code" : "capitation-pmpm",
      "display" : "Capitation per member per month",
      "definition" : "Capitation per member per month (PMPM). Capitation is a fixed amount of money per patient per month paid in advance to the physician [or health care provider] for the delivery of health care services."
    },
    {
      "code" : "dental-capitation",
      "display" : "Dental capitation",
      "definition" : "Total dental capitation."
    },
    {
      "code" : "dental-capitation-pmpm",
      "display" : "Dental capitation PMPM",
      "definition" : "Total dental capitation per member per month (PMPM)."
    },
    {
      "code" : "reinsurance-capitation",
      "display" : "Reinsurance capitation",
      "definition" : "Total reinsurance capitation."
    },
    {
      "code" : "reinsurance-capitation-pmpm",
      "display" : "Reinsurance capitation PMPM",
      "definition" : "Reinsurance captitation per member per month (PMPM)."
    },
    {
      "code" : "ccf",
      "display" : "Care coordination fee",
      "definition" : "Care coordination fee (CCF) is per member per payments based on the number of patients that are assigned to primary care physicians."
    },
    {
      "code" : "goal-hcc-raf",
      "display" : "Goal HCC RAF",
      "definition" : "Goal or target hierarchical condition category (HCC) Risk Adjustment Factor (RAF)."
    },
    {
      "code" : "actual-hcc-raf",
      "display" : "Actual HCC RAF",
      "definition" : "Acutal hierarchical condition category (HCC) Risk Adjustment Factor (RAF)."
    },
    {
      "code" : "earnings-ccf",
      "display" : "Earnings CCF",
      "definition" : "Earnings from care coordination fees."
    },
    {
      "code" : "performance-ccf",
      "display" : "Performance CCF",
      "definition" : "Performance for care coordination fees."
    },
    {
      "code" : "potential-upside-ccf",
      "display" : "Potential upside CCF",
      "definition" : "Potential upside earnings for care coordination fees."
    },
    {
      "code" : "potential-downside-ccf",
      "display" : "Potential downside CCF",
      "definition" : "Potential downside earnings for care coordination fees."
    },
    {
      "code" : "earned-incentive",
      "display" : "Earned incentive",
      "definition" : "Earned incentive payment."
    },
    {
      "code" : "earnings-qip",
      "display" : "Earnings QIP",
      "definition" : "Earnings from quality incentive payments."
    },
    {
      "code" : "performance-qip",
      "display" : "Performance QIP",
      "definition" : "Performance for quality incentive payments."
    },
    {
      "code" : "potential-upside-qip",
      "display" : "Potential upside QIP",
      "definition" : "Potential upside earnings for quality incentive payments."
    },
    {
      "code" : "potential-downside-qip",
      "display" : "Potential downside QIP",
      "definition" : "Potential downside earnings for quality incentive payments."
    },
    {
      "code" : "earnings-ssl",
      "display" : "Earnings SSL",
      "definition" : "Earnings from shared savings surplus/loss."
    },
    {
      "code" : "performance-ssl",
      "display" : "performance SSL",
      "definition" : "Performance for shared savings surplus/loss."
    },
    {
      "code" : "potential-upside-ssl",
      "display" : "Potential upside SSL",
      "definition" : "Potential upside earnings for shared savings surplus/loss."
    },
    {
      "code" : "potential-downside-ssl",
      "display" : "potential downside SSL",
      "definition" : "Potential downside earnings for shared savings surplus/loss."
    },
    {
      "code" : "earnings-cap",
      "display" : "Earnings capitated",
      "definition" : "Earnings from capitated payments."
    },
    {
      "code" : "performance-cap",
      "display" : "Performance capitated",
      "definition" : "Performance for capitated payments."
    },
    {
      "code" : "potential-upside-cap",
      "display" : "Potential upside capitated",
      "definition" : "Potential upside earnings from capitated payments."
    },
    {
      "code" : "potential-downside-cap",
      "display" : "Potential downside capitated",
      "definition" : "Potential downside earnings for capitated payments."
    },
    {
      "code" : "quality-gate-percentage",
      "display" : "Quality gate percentage",
      "definition" : "% of payment tied to quality."
    },
    {
      "code" : "quality-gate-performance-percentage",
      "display" : "Quality gate performance percentage",
      "definition" : "% of shared savings can earn based on quality metric performance."
    },
    {
      "code" : "interim-pmt-rate",
      "display" : "Interim payment rate",
      "definition" : "Interim payment rate."
    },
    {
      "code" : "ibnr-pmpm",
      "display" : "IBNR PMPM",
      "definition" : "Incurred but not yet reported (IBNR) per member per month (PMPM)."
    },
    {
      "code" : "med-ibnr",
      "display" : "Medical IBNR",
      "definition" : "Estimated medical expenses incurred but not yet reported (IBNR)."
    },
    {
      "code" : "rx-ibnr",
      "display" : "Pharmacy IBNR",
      "definition" : "Estimated pharmacy expenses incurred but not yet reported (IBNR)."
    },
    {
      "code" : "med-rx-ibnr",
      "display" : "Medical pharmacy IBNR",
      "definition" : "Estimated medical and pharmacy expenses incurred but not yet reported (IBNR)."
    },
    {
      "code" : "revenue",
      "display" : "Revenue",
      "definition" : "Total revenues earned, which includes premiums and other resources that a payer receives."
    },
    {
      "code" : "revenue-pmpm",
      "display" : "Revenue PMPM",
      "definition" : "Revenue earned per member per month (PMPM)."
    },
    {
      "code" : "avg-revenue-pmpm-market",
      "display" : "Market average revenue PMPM",
      "definition" : "Average revenue per member per month (PMPM) for a market."
    },
    {
      "code" : "cost-target",
      "display" : "Cost target",
      "definition" : "Cost target."
    },
    {
      "code" : "admin-cost",
      "display" : "Administrative cost",
      "definition" : "A general term that refers to Medicare and Medicaid administrative costs, as well as CMS administrative costs. Medicare administrative costs are comprised of the Medicare related outlays and non-CMS administrative outlays. Medicaid administrative costs refer to the Federal share of the States' expenditures for administration of the Medicaid program. CMS administrative costs are the costs of operating CMS (e.g., salaries and expenses, facilities, equipment, rent and utilities, etc.). These costs are reflected in the Program Management account."
    },
    {
      "code" : "rx-cost",
      "display" : "Pharmacy cost",
      "definition" : "Total amount of the pharmacy cost."
    },
    {
      "code" : "rx-cost-target",
      "display" : "Pharmacy cost target",
      "definition" : "The goal or target pharmacy spend level as specified by a value-based contract below which savings are generated, often represented as a percent of total revenue."
    },
    {
      "code" : "rx-cost-pmpm",
      "display" : "Pharmacy cost PMPM",
      "definition" : "Pharmacy cost per member per month (PMPM)."
    },
    {
      "code" : "rx-cost-pmpm-target",
      "display" : "Pharmacy cost PMPM target",
      "definition" : "The goal or target pharmacy spend level per member per month (PMPM) as specified by a value-based contract below which savings are generated, often represented as a percent of total revenue."
    },
    {
      "code" : "med-cost",
      "display" : "Medical cost",
      "definition" : "Total amount of the medical cost."
    },
    {
      "code" : "med-cost-target",
      "display" : "Medical cost target",
      "definition" : "The goal or target medical spend level as specified by a value-based contract below which savings are generated, often represented as a percent of total revenue."
    },
    {
      "code" : "med-cost-pmpm",
      "display" : "Medical cost PMPM",
      "definition" : "Medical cost per member per month (PMPM)."
    },
    {
      "code" : "med-cost-pmpm-target",
      "display" : "Medical cost PMPM target",
      "definition" : "The goal or target medical cost per member per month (PMPM)."
    },
    {
      "code" : "med-cost-fund",
      "display" : "Medical cost fund",
      "definition" : "Total dollars available for medical spend calculated using the medical cost target relative to estimated revenue."
    },
    {
      "code" : "avg-med-cost-fund-market",
      "display" : "Market average medical cost fund",
      "definition" : "The market average medical cost per member per month (PMPM) over revenue PMPM."
    },
    {
      "code" : "med-rx-cost",
      "display" : "Medical pharmacy cost",
      "definition" : "Total spend on medical and pharmacy cost for a specified population."
    },
    {
      "code" : "med-rx-cost-target",
      "display" : "Medical pharmacy cost target",
      "definition" : "Target spend on medical and pharmacy cost for a specified population."
    },
    {
      "code" : "med-rx-cost-pmpm",
      "display" : "Medical pharmacy cost PMPM",
      "definition" : "Total spend on pharmacy cost for a specified population represented on a per member per month (PMPM) basis."
    },
    {
      "code" : "avg-med-rx-cost-pmpm-market",
      "display" : "Market average medical pharmacy cost PMPM",
      "definition" : "The market average medical pharmacy cost per member per month (PMPM)."
    },
    {
      "code" : "variance-cost",
      "display" : "Variance cost",
      "definition" : "How much actual costs vary from projected (target) costs."
    },
    {
      "code" : "med-loss-ratio",
      "display" : "Medical loss ratio",
      "definition" : "The Medical Loss Ratio (MLR) is the proportion of premium revenues spent on clinical services and quality improvement."
    },
    {
      "code" : "med-loss-ratio-target",
      "display" : "Medical loss ratio target",
      "definition" : "The goal or target medical spend level relative to revenue as specified in a value-based care contract, often represented as a percent of revenue."
    },
    {
      "code" : "med-expense-ratio",
      "display" : "Medical expense ratio",
      "definition" : "Medical expense ratio."
    },
    {
      "code" : "med-expense-ratio-pmpm",
      "display" : "Medical expense ratio PMPM",
      "definition" : "Medical expense ratio per member per month (PMPM)."
    },
    {
      "code" : "member-months",
      "display" : "Member months",
      "definition" : "Total member months in a given period."
    },
    {
      "code" : "med-member-months",
      "display" : "Medical member months",
      "definition" : "Total medical member months in a given period."
    },
    {
      "code" : "rx-member-months",
      "display" : "Pharmacy member months",
      "definition" : "Total pharmacy member months in a given period."
    },
    {
      "code" : "adjusted-paid-claim",
      "display" : "Adjusted paid claim",
      "definition" : "Adjusted paid claim, excludes catastrophic claims."
    },
    {
      "code" : "annual-care-visit-bonus",
      "display" : "Annual care visit bonus",
      "definition" : "Bonus to qualified annual care visit (ACV). A type of quality incentive payment."
    },
    {
      "code" : "avg-star-rating-bonus",
      "display" : "Average star rating bonus",
      "definition" : "Bonus earned when achieve a certain Average Star Rating. A type of quality incentive payment."
    },
    {
      "code" : "avg-star-rating-improvement-bonus",
      "display" : "Average star rating improvement bonus",
      "definition" : "Bonus earned when achieve improvement performance year over year based on average star rating. A type of quality incentive payment"
    },
    {
      "code" : "quality-metric-performance-incentive",
      "display" : "Quality metric performance incentive",
      "definition" : "Quality metric performance incentive payment is a type of quality incentive payment."
    },
    {
      "code" : "quality-pmt-chronic",
      "display" : "Quality payment chronic disease management",
      "definition" : "Quality payment chronic disease management."
    },
    {
      "code" : "quality-pmt-office-visit",
      "display" : "Quality payment annual office visit",
      "definition" : "Quality payment annual office visit."
    },
    {
      "code" : "shared-saving-deficit",
      "display" : "Shared saving deficit",
      "definition" : "The amount of shared saving deficit."
    },
    {
      "code" : "weighted-avg-star",
      "display" : "Weighted average star",
      "definition" : "The average quality score across a specified set of measures, weighted by importance of the individual measures for a specific population. Often used in relation to CMS Medicare Star rating reports, e.g., where medication adherence measures are 3x weighted relative to other quality measures in the set."
    },
    {
      "code" : "condition-count",
      "display" : "Condition count",
      "definition" : "The number of conditions."
    },
    {
      "code" : "1-gap-closed",
      "display" : "1 gap closed",
      "definition" : "Number of members with 1 closed gap."
    },
    {
      "code" : "2-gap-closed",
      "display" : "2 gaps closed",
      "definition" : "Number of members with 2 closed gaps."
    },
    {
      "code" : "paid-claim",
      "display" : "Paid claim",
      "definition" : "Total paid claim amount."
    },
    {
      "code" : "paid-claim-pmpm",
      "display" : "Paid claim PMPM",
      "definition" : "Paid claim per member per month (PMPM)."
    },
    {
      "code" : "drg-expense",
      "display" : "DRG expense",
      "definition" : "Total diagnosis related group (DRG) expense."
    },
    {
      "code" : "drg-expense-pmpm",
      "display" : "DRG expense PMPM",
      "definition" : "Diagnosis related group (DRG) expense per member per month (PMPM)."
    },
    {
      "code" : "provider-quality-expense-pmpm",
      "display" : "Provider quality expense PMPM",
      "definition" : "Provider quality expense per member per month (PMPM)."
    },
    {
      "code" : "subrogation-pmpm",
      "display" : "Subrogation PMPM",
      "definition" : "Subrogation per member per month (PMPM)."
    },
    {
      "code" : "avg-member-office-visit",
      "display" : "Average members with office visit",
      "definition" : "Average number of members with office visit."
    },
    {
      "code" : "ed-visit",
      "display" : "ED visit",
      "definition" : "Total number of Emergency Department (ED) visits."
    },
    {
      "code" : "eligible-member",
      "display" : "Eligible members",
      "definition" : "Total number of eligible members."
    },
    {
      "code" : "inpatient-acute",
      "display" : "Inpatient acute",
      "definition" : "Total number of inpatient acute stays."
    },
    {
      "code" : "inpatient-admission",
      "display" : "Inpatient admission",
      "definition" : "Total number of inpatient admissions."
    },
    {
      "code" : "nurse-hotline",
      "display" : "Nurse hotline",
      "definition" : "Total number calls of the nurse hotline."
    },
    {
      "code" : "nurse-hotline-pmpm",
      "display" : "Nurse hotline PMPM",
      "definition" : "Total nurse hotline per member per month (PMPM)."
    },
    {
      "code" : "snf-avg-los",
      "display" : "Skilled Nursing Facility average length of stay",
      "definition" : "The number of skilled nursing facility average length of stay."
    },
    {
      "code" : "readmission",
      "display" : "Readmission",
      "definition" : "Total number of readmissions"
    },
    {
      "code" : "snf-admission",
      "display" : "Skilled Nursing Facility admission",
      "definition" : "Total number of skilled nursing facility admissions."
    },
    {
      "code" : "provider-quality-expense",
      "display" : "Provider quality expense",
      "definition" : "Total provider quality expense."
    },
    {
      "code" : "subrogation",
      "display" : "Subrogation",
      "definition" : "Total subrogation amount."
    },
    {
      "code" : "avg-membership",
      "display" : "Average membership",
      "definition" : "Average membership."
    }
  ]
}

```
