# Incentive Payment Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Incentive Payment Codes**

## CodeSystem: Incentive Payment Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:VbpIncentiveCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.7 | | |

 
What type of incentive for a payment stream such as quality incentive payment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VBPIncentiveVS](ValueSet-vbp-incentive.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "vbp-incentive",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/vbp-incentive",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.7"
    }
  ],
  "version" : "1.1.0",
  "name" : "VbpIncentiveCS",
  "title" : "Incentive Payment Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "What type of incentive for a payment stream such as quality incentive payment.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "chronic-care-mgmt",
      "display" : "Chronic care management",
      "definition" : "Chronic Care Management incentive payment. Applicable to the payment streams such as Quality Incentive Payment (QIP) and Pay for Performance (P4P)."
    },
    {
      "code" : "annual-visit",
      "display" : "Annual office visit",
      "definition" : "Annual Office Visit incentive payment."
    }
  ]
}

```
