# Threshold Type Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Threshold Type Codes**

## CodeSystem: Threshold Type Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ThresholdTypeCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.5 | | |

 
The threshold type. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ThresholdTypeVS](ValueSet-threshold-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "threshold-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/threshold-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.5"
    }
  ],
  "version" : "1.1.0",
  "name" : "ThresholdTypeCS",
  "title" : "Threshold Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The threshold type.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 8,
  "concept" : [
    {
      "code" : "star-1",
      "display" : "Star 1",
      "definition" : "Threshold for star 1 in a star rating."
    },
    {
      "code" : "star-2",
      "display" : "Star 2",
      "definition" : "Threshold for star 2 in a star rating."
    },
    {
      "code" : "star-3",
      "display" : "Star 3",
      "definition" : "Threshold for star 3 in a star rating."
    },
    {
      "code" : "star-4",
      "display" : "Star 4",
      "definition" : "Threshold for star 4 in a star rating."
    },
    {
      "code" : "star-5",
      "display" : "Star 5",
      "definition" : "Threshold for star 5 in a star rating."
    },
    {
      "code" : "hedis-50-percentile",
      "display" : "HEDIS 50 Percentile",
      "definition" : "Threshold for HEDIS 50 percentile."
    },
    {
      "code" : "hedis-75-percentile",
      "display" : "HEDIS 75 Percentile",
      "definition" : "Threshold for HEDIS 75 percentile."
    },
    {
      "code" : "hedis-90-percentile",
      "display" : "HEDIS 90 Percentile",
      "definition" : "Threshold for HEDIS 90 percentile."
    }
  ]
}

```
