# Payment Stream Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Payment Stream Codes**

## CodeSystem: Payment Stream Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PaymentStreamCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.4 | | |

 
Payment stream defined in a value-based contract. A value-based contract may contain multiple payment streams. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PaymentStreamVS](ValueSet-vbp-payment-stream.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "payment-stream",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/payment-stream",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.4"
    }
  ],
  "version" : "1.1.0",
  "name" : "PaymentStreamCS",
  "title" : "Payment Stream Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Payment stream defined in a value-based contract. A value-based contract may contain multiple payment streams.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "count" : 16,
  "concept" : [
    {
      "code" : "ccf",
      "display" : "Care coordination fee",
      "definition" : "A payment model that providers are paid a per member per month (PMPM) incentive payments on a specific schedule."
    },
    {
      "code" : "ccf-with-risk",
      "display" : "Care coordination fee with risk adjustment",
      "definition" : "A payment model that providers are paid a per variable member per month (PMPM) incentive payments on a specific schedule based on risk."
    },
    {
      "code" : "eoc",
      "display" : "Episode of care",
      "definition" : "Episodes-of-care refers to an all-inclusive health-and-payment model in which a single, bundled payment includes all services associated with the treatment for an illness, condition or medical event rather than a separate fee-for-service model."
    },
    {
      "code" : "pcpcp",
      "display" : "Primary Care Physician (PCP) capitation payment",
      "definition" : "Capitation is a payment arrangement for health care services in which an entity (e.g., a physician or group of physicians) receives a risk adjusted amount of money for each person attributed to them, per period of time, regardless of the volume of services that person seeks."
    },
    {
      "code" : "ssq",
      "display" : "Shared savings gated on quality",
      "definition" : "Shared saving is a value-based model designed to reward health care providers who improve patient care while contributing to an overall reduction in cost. Shared savings gated on quality includes a set of quality measures that serve as a quality gate in which participants must exceed an established minimum target in order to participate in savings."
    },
    {
      "code" : "ssl",
      "display" : "Shared savings loss percent",
      "definition" : "A two-sided shared saving value-based model that provides two-sided payment and risk to a provider. To be liable for shared losses, providers must meet or exceed a prescribed minmum loss rate (MLR). Once this MLR is met or exceeded, the providers will share in losses at a rate determined by its quality performance up to a loss recoupment limit (also referred to as a loss-sharing limit)."
    },
    {
      "code" : "ssp",
      "display" : "Shared savings percent",
      "definition" : "A one-sided shared saving value-based model with no risk to a provider. Providers must meet or exceed a prescribed minimum savings rate (MSR), fulfill the minimum quality performance standards, to qualify for the shared savings."
    },
    {
      "code" : "tcoc",
      "display" : "Total cost of care",
      "definition" : "The payer determines the benchmark expected costs for a population attributed to a provider over a time period, the provider offers care to the population, and the payer shares some proportion of the savings in the actual costs incurred (the Total Cost of Care or TCOC) relative to the benchmark – adjusted by whether the provider met quality goals."
    },
    {
      "code" : "qip",
      "display" : "Quality incentive payment",
      "definition" : "Quality Incentive Payment (QIP) is designed to improve patient outcomes, service provider performance, and service quality. QIP is any incentive payment based on quality. Stars Incentive Payment (SIP), Star Score Threshold (SST), Pay for Reporting (P4R), Pay for Performance (P4P), Chronic Disease Management (CDM), Annual Health Assessment (AHA), Ulitization Incentive Payment (UBIP) are examples of QIP.",
      "concept" : [
        {
          "code" : "aha",
          "display" : "Annual health assessment",
          "definition" : "This payment model pays either a per variable member per month (PMPM) for each attributed based on the percentage or pays each member who has a recorded Annual Health Assesment."
        },
        {
          "code" : "cdm",
          "display" : "Chronic Disease Management",
          "definition" : "A payment model tha pays extra for members with chronic conditions. Chronic disease management programs are structured treatment plans that aim to help people better manage their chronic disease (e.g., diabetes, asthma, hypertension), and to maintain and improve quality of life. It is an effort to improve care quality, promote self-management, and reduce costs for patients with one or more chronic conditions."
        },
        {
          "code" : "p4r",
          "display" : "Pay for reporting",
          "definition" : "A payment model that is based on pay for reporting quality measure data. There is no min performance criteria requirement."
        },
        {
          "code" : "p4p",
          "display" : "Pay for performance",
          "definition" : "A payment model where providers are given financial incentives for meeting certain quality performance criteria."
        },
        {
          "code" : "sip",
          "display" : "Stars incentive payment",
          "definition" : "A payment model that is based on meeting certain individual star performance criteria."
        },
        {
          "code" : "sst",
          "display" : "Star score threshold",
          "definition" : "A payment model that is based on meeting certain provider star performance criteria."
        },
        {
          "code" : "ubip",
          "display" : "Utilization incentive payment",
          "definition" : "A payment model that compares current utilization to a benchmark utilization and pays a variable per variable member per month (PMPM) for different rate of change in utilization."
        }
      ]
    }
  ]
}

```
