# Measure Stratifier Example Codes - Da Vinci Value-Based Performance Reporting Implementation Guide v1.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Measure Stratifier Example Codes**

## CodeSystem: Measure Stratifier Example Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example | *Version*:1.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MeasureStratifierExampleCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.30.16.3 | | |

 
Example stratifiers that could be used to stratify measure or performance metrics. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureStratifierExampleVS](ValueSet-measure-stratifier-example.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-stratifier-example",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-vbpr/ImplementationGuide/hl7.fhir.us.davinci-vbpr"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-vbpr/CodeSystem/measure-stratifier-example",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.30.16.3"
    }
  ],
  "version" : "1.1.0",
  "name" : "MeasureStratifierExampleCS",
  "title" : "Measure Stratifier Example Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-08T18:26:09+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "HL7 International / Clinical Quality Information",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Example stratifiers that could be used to stratify measure or performance metrics.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 5,
  "concept" : [
    {
      "code" : "facility",
      "display" : "Facility",
      "definition" : "Stratify based on healthcare facilities, such as regions and hospitals."
    },
    {
      "code" : "taxid",
      "display" : "TIN",
      "definition" : "Stratify based on Tax Identifier (TIN)."
    },
    {
      "code" : "group",
      "display" : "Group",
      "definition" : "Stratify based on group such as a group of tax ids."
    },
    {
      "code" : "geography",
      "display" : "Geography",
      "definition" : "Stratify based on geographical data, such as zip code and city."
    },
    {
      "code" : "cohort",
      "display" : "Cohort",
      "definition" : "Stratify based on a group of members with a shared characteristic, such as members that are with PPO plan or members with HMO plan."
    }
  ]
}

```
