<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CRMIShareableMeasure
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Measure</sch:title>
    <sch:rule context="f:Measure">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/artifact-versionAlgorithm|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/artifact-versionAlgorithm|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/artifact-versionPolicy|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/artifact-versionPolicy|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/lob']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/lob': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:scoring) &lt;= 0">scoring: maximum cardinality of 'scoring' is 0</sch:assert>
      <sch:assert test="count(f:compositeScoring) &lt;= 0">compositeScoring: maximum cardinality of 'compositeScoring' is 0</sch:assert>
      <sch:assert test="count(f:improvementNotation) &lt;= 0">improvementNotation: maximum cardinality of 'improvementNotation' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Measure/f:relatedArtifact</sch:title>
    <sch:rule context="f:Measure/f:relatedArtifact">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/weight': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status']) &gt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/us/davinci-vbpr/StructureDefinition/contractual-status': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:type) &gt;= 1">type: minimum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:type) &lt;= 1">type: maximum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:label) &lt;= 1">label: maximum cardinality of 'label' is 1</sch:assert>
      <sch:assert test="count(f:display) &lt;= 1">display: maximum cardinality of 'display' is 1</sch:assert>
      <sch:assert test="count(f:citation) &lt;= 1">citation: maximum cardinality of 'citation' is 1</sch:assert>
      <sch:assert test="count(f:url) &lt;= 1">url: maximum cardinality of 'url' is 1</sch:assert>
      <sch:assert test="count(f:document) &lt;= 1">document: maximum cardinality of 'document' is 1</sch:assert>
      <sch:assert test="count(f:resource) &gt;= 1">resource: minimum cardinality of 'resource' is 1</sch:assert>
      <sch:assert test="count(f:resource) &lt;= 1">resource: maximum cardinality of 'resource' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
