# Home - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra | *Version*:2.1.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RiskAdjustment |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

* New [operations](operations.md) under development since the STU 2.1 publication

### Summary

The Da Vinci Fast Healthcare Interoperability Resource (FHIR) Risk Adjustment Implementation Guide (IG) describes exchanging risk adjustment coding gaps between payers and providers. Risk adjusted premium calculations are important to government managed care. To better inform providers of opportunities to address risk adjusted conditions, better enable payers to communicate risk adjustment information, and enhance government sponsors' ability to allocate funding accurately, payers and providers need a standard protocol to share and receive clinical data related to risk adjustment and a standard methodology to communicate risk based coding, documentation and submission status of chronic conditions. The first Standard for Trial Use (STU) version of this implementation guide focused on the standard exchange format of risk adjustment coding gaps from payers to providers, it offers potential for reducing the administrative burden experienced by providers by standardizing the reporting they receive from all payers.

This version of the implementation guide focuses primarily on the communication from providers back to payers. It focuses on two forms of communication:

* Allowing the provider, a risk adjustment coder or the provider's EMR to add a Condition Category Remark to the Risk Adjustment Coding Gap Report. Providers and risk adjustment coders may indicate that a gap was closed, invalidated, not appropriate at this time, etc. It also allows for the EMR to notify the payer when the content could not be processed. Note that where appropriate, the payer or an entity acting on behalf of the payer can also add a remark to the Risk Adjustment Coding Gap Report.
* A Risk Adjustment Data Exchange MeasureReport was added to allow the provider to return data to the payer to potentially close the Condition Category code gaps. We anticipate this could be used to submit Consolidated Clinical Document Architecture documents such as the Continuity of Care Document (CCD), Progress Notes, etc. It can also be used to submit specific FHIR data if appropriate.

This version also introduces the draft content for digital Condition Category (dCC). It describes how to specify dCCs, using Clinical Quality Language (CQL), through an example which would allow for a more automated process of generating risk adjustment coding gap reports by evaluating dCCs against clinical data.

This implementation guide is supported by the Da Vinci initiative which is a private effort to accelerate the adoption of Health Level Seven International Fast Healthcare Interoperability Resources (HL7® FHIR®) as the standard to support and integrate value-based care (VBC) data exchange across communities. Like all Da Vinci Implementation Guides, it follows the [HL7 Da Vinci Guiding Principles](https://confluence.hl7.org/display/DVP/Da+Vinci+Clinical+Advisory+Council+Members?preview=/66940155/66942916/Guiding%20Principles%20for%20Da%20Vinci%20Implementation%20Guides.pdf) for the exchange of patient health information. As an HL7 FHIR Implementation Guide, changes to this specification are managed by the sponsoring [Clinical Quality Information (CQI) Work Group](http://www.hl7.org/Special/committees/cqi/overview.cfm) and are incorporated as part of the standard balloting process.

### Content and Organization

The main menu shown at the top of each page is categorized into several primary topics with several sub-topics:

* **[Home](index.md)**: The home page provides a high-level summary of this IG and background information about risk adjustment for revenue normalization.
* **Background**: These pages provide background information to this IG. 
* [FHIR Introduction](fhir.md) highlights the key sections of the FHIR core specification that Da Vinci implementers should be familiar with.
* [Background - Risk Adjustment](background.md) provides background information about risk adjustment for revenue normalization, risk adjustment models, scope of this IG, and etc.
* [Participants and Credits](credits.md) provides thanks to key contributors to the creation of this guide.
* [Glossary](glossary.md) lists glossary and acronyms for this guide.
 
* **Specification**: These pages provide guidance on the resource profiles and operation defined in this IG. 
* [General Guidance](general-guidance.md) provides guidance that applies to all functionalities in this IG.
* [Report Generation](report-generation.md) describes how generating a Risk Adjustment Coding Gap Report is accomplished.
* [Report Query](report-query.md) provides guidance on using query to return a Risk Adjustment Coding Gap Report(s) and their evaluated resources.
* [Submit Data to Payer](submit-data-to-payer.md) provides guidance on submitting clinical evaluation evidence to Payer for the purpose of evaluating risk adjustment coding gaps using [$submit-data](https://www.hl7.org/fhir/measure-operation-submit-data.html) and [Risk Adjustment Data Exchange MeasureReport](StructureDefinition-ra-datax-measurereport.md).
* [Add Remark to Condition Category](cc-remark.md) describes how providers can add remarks to Condition Categories on the Risk Adjustment Coding Gap Report to note that they took actions while seeing the patient.
* [Digital Condition Category (dCC)](dcc.md) includes draft content describing how a Condition Category can be structured as a proportion measure and be specified using CQL as a digital Condition Category in a similar fashion to electronic quality measures through an example.
* [Security, Privacy, and Safety](security.md) provides general expectations to ensure security and privacy of exchanges
 
* **FHIR Artifacts**: These pages list FHIR artifacts specified in this IG. 
* [Artifacts Summary](artifacts.md) shows a complete list of FHIR artifacts defined in this IG.
* [Profiles](profiles.md) lists the set of Profiles that are defined in this IG to exchange risk adjustment coding gaps.
* [Extensions](extensions.md) lists the set of Extensions that are defined in this IG to exchange risk adjustment coding gaps.
* [Search Parameters](search-parameters.md) lists Search Parameter defined in this IG.
* [Operations](operations.md) lists operations defined in this IG.
* [Terminology](terminology.md) lists code systems and value sets defined in this IG.
* [Capability statements](capabilities.md) describes the expected FHIR capabilities of the risk adjustment actors of this IG.
* [Examples](examples.md) lists all the examples used in this IG.
 
* **Base Specs** includes links to the FHIR core specification as well as the US Core specs that underlie this IG.
* **Support** includes various links for support and guidance, as well as [Downloads](downloads.md) links for this IG and guidance on tools and support for Da Vinci implementers.

### Dependencies

At present, the Risk Adjustment IG is based on [FHIR R4](http://hl7.org/fhir/R4/). In addition, this guide also relies on a number of parent implementation guides:

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

As seen in the above table, this implementation guide is dependent on the [US Core 3.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU3.1.1), [US Core 6.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU6.1) and [US Core 7.0 (FHIR R4)](http://hl7.org/fhir/us/core/STU7) implementation guides. The first is supported for those systems limited to [United States Core Data for Interoperability (USCDI) v1](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi) capabilities, the second is for upcoming regulatory requirements mandating support for [USCDI v3](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v3), and the last is to enable support for proposed regulations mandating support for [USCDI v4](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v4). Wherever possible, Da Vinci profiles strive to comply with all three releases, simplifying implementation for those who will need to support varying regulatory expectations over time.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.5.0/CodeSystem-ISO3166Part1.html): [CCRemarkPatchParameters](StructureDefinition-ra-parameters-cc-remark-patch.md), [CCType](StructureDefinition-ra-ccType.md)...Show 36 more,[CodingGapRemark](ValueSet-coding-gap-remark.md),[ConditionCategoryRemark](StructureDefinition-ra-ccRemark.md),[ConfidenceScale](ValueSet-confidence-scale.md),[ContextId](StructureDefinition-ra-contextId.md),[DxCode](StructureDefinition-ra-dxCode.md),[EvidenceStatus](StructureDefinition-ra-evidenceStatus.md),[GroupReference](StructureDefinition-ra-groupReference.md),[HierarchicalStatus](StructureDefinition-ra-hierarchicalStatus.md),[MeasureReportCategory](SearchParameter-measurereport-category.md),[PatientGroup](StructureDefinition-ra-patient-group.md),[PayerCodingGapReportId](StructureDefinition-ra-payerCodingGapReportId.md),[QualifyingCode](StructureDefinition-ra-qualifyingDxCode.md),[RAClientCapabilityStatement](CapabilityStatement-ra-reporting-client.md),[RAClinicalDataCollectionDeadline](StructureDefinition-ra-clinicalDataCollectionDeadline.md),[RAClinicalEvidenceStatusDate](StructureDefinition-ra-evidenceStatusDate.md),[RADataSubmissionClientCapabilityStatement](CapabilityStatement-ra-data-submission-client.md),[RADataSubmissionServerCapabilityStatement](CapabilityStatement-ra-data-submission-server.md),[RAEvaluateMeasure](OperationDefinition-ra.evaluate-measure.md),[RAMeasureReportBundle](StructureDefinition-ra-measurereport-bundle.md),[RAModelExample01](Measure-RAModelExample01.md),[RAModelExample02](Measure-RAModelExample02.md),[RAModelExample03](Measure-RAModelExample03.md),[RAServerCapabilityStatement](CapabilityStatement-ra-reporting-server.md),[RemarkReason](ValueSet-remark-reason.md),[ReportingVendor](StructureDefinition-ra-reportingVendor.md),[RiskAdjustment](index.md),[RiskAdjustmentCodingGapMeasureReport](StructureDefinition-ra-measurereport.md),[RiskAdjustmentConditionCategoryType](ValueSet-cc-type.md),[RiskAdjustmentDataExchangeMeasureReport](StructureDefinition-ra-datax-measurereport.md),[RiskAdjustmentEvidenceStatus](ValueSet-evidence-status.md),[RiskAdjustmentMeasureReportRemarkBundle](StructureDefinition-ra-measurereport-remark-bundle.md),[RiskAdjustmentModelMeasure](StructureDefinition-ra-model-measure.md),[RiskAdjustmenthierarchicalStatus](ValueSet-hierarchical-status.md),[RiskGap](OperationDefinition-risk-gap.md),[SampleCMSHCC](ValueSet-sample-cmshcc.md)and[SubmitRemarkData](OperationDefinition-submit-remark-data.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Observation/ra-obs01pat02](Observation-ra-obs01pat02.md), [Observation/ra-obs01pat03](Observation-ra-obs01pat03.md) and [Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [DocumentReference/ra-documentreference01pat01](DocumentReference-ra-documentreference01pat01.md)...Show 5 more,[Observation/ra-obs01pat02](Observation-ra-obs01pat02.md),[Observation/ra-obs01pat03](Observation-ra-obs01pat03.md),[Observation/ra-obs02pat03](Observation-ra-obs02pat03.md),[Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)and[Parameters/ra-submit-data](Parameters-ra-submit-data.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [ConfidenceScale](ValueSet-confidence-scale.md), [DxCode](StructureDefinition-ra-dxCode.md), [MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md) and [MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-category.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Condition/ra-condition01pat03](Condition-ra-condition01pat03.md)...Show 26 more,[Condition/ra-condition02pat01](Condition-ra-condition02pat01.md),[Condition/ra-condition03pat01](Condition-ra-condition03pat01.md),[Condition/ra-condition04pat03](Condition-ra-condition04pat03.md),[Condition/ra-condition05pat03](Condition-ra-condition05pat03.md),[Condition/ra-condition06pat03](Condition-ra-condition06pat03.md),[Condition/ra-condition07pat03](Condition-ra-condition07pat03.md),[Condition/ra-condition08pat01](Condition-ra-condition08pat01.md),[Condition/ra-condition09pat01](Condition-ra-condition09pat01.md),[Condition/ra-condition10pat01](Condition-ra-condition10pat01.md),[Condition/ra-condition11pat01](Condition-ra-condition11pat01.md),[Condition/ra-condition12pat01](Condition-ra-condition12pat01.md),[Condition/ra-condition15pat03](Condition-ra-condition15pat03.md),[Condition/ra-condition16pat03](Condition-ra-condition16pat03.md),[Condition/ra-condition17pat01](Condition-ra-condition17pat01.md),[Condition/ra-condition18pat01](Condition-ra-condition18pat01.md),[Condition/ra-condition21pat03](Condition-ra-condition21pat03.md),[Condition/ra-condition22pat03](Condition-ra-condition22pat03.md),[Condition/ra-condition23pat03](Condition-ra-condition23pat03.md),[Condition/ra-condition31pat02](Condition-ra-condition31pat02.md),[Condition/ra-condition32pat03](Condition-ra-condition32pat03.md),[Condition/ra-condition33pat01](Condition-ra-condition33pat01.md),[Condition/ra-condition35pat03](Condition-ra-condition35pat03.md),[Condition/ra-condition42pat03](Condition-ra-condition42pat03.md),[Condition/ra-condition43pat01](Condition-ra-condition43pat01.md),[Condition/ra-condition44pat01](Condition-ra-condition44pat01.md)and[Condition/ra-conditionR01pat01](Condition-ra-conditionR01pat01.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-clinical.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Condition/ra-condition01pat03](Condition-ra-condition01pat03.md)...Show 26 more,[Condition/ra-condition02pat01](Condition-ra-condition02pat01.md),[Condition/ra-condition03pat01](Condition-ra-condition03pat01.md),[Condition/ra-condition04pat03](Condition-ra-condition04pat03.md),[Condition/ra-condition05pat03](Condition-ra-condition05pat03.md),[Condition/ra-condition06pat03](Condition-ra-condition06pat03.md),[Condition/ra-condition07pat03](Condition-ra-condition07pat03.md),[Condition/ra-condition08pat01](Condition-ra-condition08pat01.md),[Condition/ra-condition09pat01](Condition-ra-condition09pat01.md),[Condition/ra-condition10pat01](Condition-ra-condition10pat01.md),[Condition/ra-condition11pat01](Condition-ra-condition11pat01.md),[Condition/ra-condition12pat01](Condition-ra-condition12pat01.md),[Condition/ra-condition15pat03](Condition-ra-condition15pat03.md),[Condition/ra-condition16pat03](Condition-ra-condition16pat03.md),[Condition/ra-condition17pat01](Condition-ra-condition17pat01.md),[Condition/ra-condition18pat01](Condition-ra-condition18pat01.md),[Condition/ra-condition21pat03](Condition-ra-condition21pat03.md),[Condition/ra-condition22pat03](Condition-ra-condition22pat03.md),[Condition/ra-condition23pat03](Condition-ra-condition23pat03.md),[Condition/ra-condition31pat02](Condition-ra-condition31pat02.md),[Condition/ra-condition32pat03](Condition-ra-condition32pat03.md),[Condition/ra-condition33pat01](Condition-ra-condition33pat01.md),[Condition/ra-condition35pat03](Condition-ra-condition35pat03.md),[Condition/ra-condition42pat03](Condition-ra-condition42pat03.md),[Condition/ra-condition43pat01](Condition-ra-condition43pat01.md),[Condition/ra-condition44pat01](Condition-ra-condition44pat01.md)and[Condition/ra-conditionR01pat01](Condition-ra-conditionR01pat01.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.0/CodeSystem-condition-ver-status.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Condition/ra-condition01pat03](Condition-ra-condition01pat03.md)...Show 26 more,[Condition/ra-condition02pat01](Condition-ra-condition02pat01.md),[Condition/ra-condition03pat01](Condition-ra-condition03pat01.md),[Condition/ra-condition04pat03](Condition-ra-condition04pat03.md),[Condition/ra-condition05pat03](Condition-ra-condition05pat03.md),[Condition/ra-condition06pat03](Condition-ra-condition06pat03.md),[Condition/ra-condition07pat03](Condition-ra-condition07pat03.md),[Condition/ra-condition08pat01](Condition-ra-condition08pat01.md),[Condition/ra-condition09pat01](Condition-ra-condition09pat01.md),[Condition/ra-condition10pat01](Condition-ra-condition10pat01.md),[Condition/ra-condition11pat01](Condition-ra-condition11pat01.md),[Condition/ra-condition12pat01](Condition-ra-condition12pat01.md),[Condition/ra-condition15pat03](Condition-ra-condition15pat03.md),[Condition/ra-condition16pat03](Condition-ra-condition16pat03.md),[Condition/ra-condition17pat01](Condition-ra-condition17pat01.md),[Condition/ra-condition18pat01](Condition-ra-condition18pat01.md),[Condition/ra-condition21pat03](Condition-ra-condition21pat03.md),[Condition/ra-condition22pat03](Condition-ra-condition22pat03.md),[Condition/ra-condition23pat03](Condition-ra-condition23pat03.md),[Condition/ra-condition31pat02](Condition-ra-condition31pat02.md),[Condition/ra-condition32pat03](Condition-ra-condition32pat03.md),[Condition/ra-condition33pat01](Condition-ra-condition33pat01.md),[Condition/ra-condition35pat03](Condition-ra-condition35pat03.md),[Condition/ra-condition42pat03](Condition-ra-condition42pat03.md),[Condition/ra-condition43pat01](Condition-ra-condition43pat01.md),[Condition/ra-condition44pat01](Condition-ra-condition44pat01.md)and[Condition/ra-conditionR01pat01](Condition-ra-conditionR01pat01.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Observation/ra-obs01pat02](Observation-ra-obs01pat02.md), [Observation/ra-obs01pat03](Observation-ra-obs01pat03.md), [Observation/ra-obs02pat03](Observation-ra-obs02pat03.md) and [Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)
* [Organization type](http://terminology.hl7.org/7.0.0/CodeSystem-organization-type.html): [ABC Payer](Organization-ra-payer01.md), [Best RA Vendor](Organization-ra-vendor01.md)...Show 5 more,[Community HealthCenter](Organization-ra-org03pat03.md),[Community Urgent Care](Organization-ra-org01pat01.md),[GHH Outpatient Clinic](Organization-ra-org02pat02.md),[Risk Adjustment Author](Organization-ra-org-author.md)and[XYZ Laboratory](Organization-ra-laboratory01.md)
* [Observation Reference Range Meaning Codes](http://terminology.hl7.org/7.0.0/CodeSystem-referencerange-meaning.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Observation/ra-obs01pat02](Observation-ra-obs01pat02.md), [Observation/ra-obs01pat03](Observation-ra-obs01pat03.md) and [Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Parameters/ra-submit-data](Parameters-ra-submit-data.md), [Patient/ra-patient01](Patient-ra-patient01.md), [Patient/ra-patient02](Patient-ra-patient02.md) and [Patient/ra-patient03](Patient-ra-patient03.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Encounter/ra-encounter01pat03](Encounter-ra-encounter01pat03.md)...Show 21 more,[Encounter/ra-encounter02pat01](Encounter-ra-encounter02pat01.md),[Encounter/ra-encounter03pat01](Encounter-ra-encounter03pat01.md),[Encounter/ra-encounter04pat03](Encounter-ra-encounter04pat03.md),[Encounter/ra-encounter05pat03](Encounter-ra-encounter05pat03.md),[Encounter/ra-encounter06pat03](Encounter-ra-encounter06pat03.md),[Encounter/ra-encounter07pat03](Encounter-ra-encounter07pat03.md),[Encounter/ra-encounter08pat01](Encounter-ra-encounter08pat01.md),[Encounter/ra-encounter09pat01](Encounter-ra-encounter09pat01.md),[Encounter/ra-encounter11pat01](Encounter-ra-encounter11pat01.md),[Encounter/ra-encounter15pat03](Encounter-ra-encounter15pat03.md),[Encounter/ra-encounter16pat03](Encounter-ra-encounter16pat03.md),[Encounter/ra-encounter19pat03](Encounter-ra-encounter19pat03.md),[Encounter/ra-encounter21pat03](Encounter-ra-encounter21pat03.md),[Encounter/ra-encounter22pat03](Encounter-ra-encounter22pat03.md),[Encounter/ra-encounter31pat02](Encounter-ra-encounter31pat02.md),[Encounter/ra-encounter35pat03](Encounter-ra-encounter35pat03.md),[Encounter/ra-encounter42pat03](Encounter-ra-encounter42pat03.md),[Encounter/ra-encounter43pat01](Encounter-ra-encounter43pat01.md),[Encounter/ra-encounter44pat01](Encounter-ra-encounter44pat01.md),[Encounter/ra-encounter45pat01](Encounter-ra-encounter45pat01.md)and[Encounter/ra-encounter46pat01](Encounter-ra-encounter46pat01.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.0/CodeSystem-v3-MaritalStatus.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Parameters/ra-submit-data](Parameters-ra-submit-data.md), [Patient/ra-patient01](Patient-ra-patient01.md), [Patient/ra-patient02](Patient-ra-patient02.md) and [Patient/ra-patient03](Patient-ra-patient03.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core DocumentReferences Category Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-documentreference-category.html): [DocumentReference/ra-documentreference01pat01](DocumentReference-ra-documentreference01pat01.md) and [Parameters/ra-submit-data](Parameters-ra-submit-data.md)
* [Risk Adjustment Condition Category Type Codes](CodeSystem-cc-type.md): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [CCType](StructureDefinition-ra-ccType.md)...Show 9 more,[MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md),[MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md),[MeasureReport/ra-measurereport02](MeasureReport-ra-measurereport02.md),[MeasureReport/ra-measurereport03](MeasureReport-ra-measurereport03.md),[MeasureReport/ra-measurereport04](MeasureReport-ra-measurereport04.md),[MeasureReport/ra-measurereport05](MeasureReport-ra-measurereport05.md),[MeasureReport/ra-measurereport06](MeasureReport-ra-measurereport06.md),[RiskAdjustmentConditionCategoryType](ValueSet-cc-type.md)and[RiskGap](OperationDefinition-risk-gap.md)
* [Coding Gap Remark Codes](CodeSystem-coding-gap-remark.md): [CodingGapRemark](ValueSet-coding-gap-remark.md), [ConditionCategoryRemark](StructureDefinition-ra-ccRemark.md) and [MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md)
* [Risk Adjustment Evidence Status Codes](CodeSystem-evidence-status.md): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [EvidenceStatus](StructureDefinition-ra-evidenceStatus.md)...Show 9 more,[MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md),[MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md),[MeasureReport/ra-measurereport02](MeasureReport-ra-measurereport02.md),[MeasureReport/ra-measurereport03](MeasureReport-ra-measurereport03.md),[MeasureReport/ra-measurereport04](MeasureReport-ra-measurereport04.md),[MeasureReport/ra-measurereport05](MeasureReport-ra-measurereport05.md),[MeasureReport/ra-measurereport06](MeasureReport-ra-measurereport06.md),[RiskAdjustmentEvidenceStatus](ValueSet-evidence-status.md)and[RiskGap](OperationDefinition-risk-gap.md)
* [Risk Adjustment Hierarchical Status Codes](CodeSystem-hierarchical-status.md): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [HierarchicalStatus](StructureDefinition-ra-hierarchicalStatus.md)...Show 8 more,[MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md),[MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md),[MeasureReport/ra-measurereport02](MeasureReport-ra-measurereport02.md),[MeasureReport/ra-measurereport03](MeasureReport-ra-measurereport03.md),[MeasureReport/ra-measurereport04](MeasureReport-ra-measurereport04.md),[MeasureReport/ra-measurereport05](MeasureReport-ra-measurereport05.md),[MeasureReport/ra-measurereport06](MeasureReport-ra-measurereport06.md)and[RiskAdjustmenthierarchicalStatus](ValueSet-hierarchical-status.md)
* [Remark Reason Codes](CodeSystem-remark-reason.md): [ConditionCategoryRemark](StructureDefinition-ra-ccRemark.md) and [RemarkReason](ValueSet-remark-reason.md)


-------



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.davinci-ra",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra",
  "version" : "2.1.0",
  "name" : "RiskAdjustment",
  "title" : "Da Vinci Risk Adjustment Implementation Guide",
  "status" : "active",
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The Da Vinci Fast Healthcare Interoperability Resource (FHIR) Risk Adjustment Implementation Guide (this IG) describes exchange of risk-based coding gaps among stakeholders such as payers, providers, and government care programs in support of driving towards accurate and complete documentation of health conditions that would lead to more accurate risk-adjustment payment calculations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "packageId" : "hl7.fhir.us.davinci-ra",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "uscore7",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v4\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "7.0.0"
    },
    {
      "id" : "uscore6",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v3\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v610/ImplementationGuide/hl7.fhir.us.core.v610",
      "packageId" : "hl7.fhir.us.core.v610",
      "version" : "6.1.0"
    },
    {
      "id" : "uscore3",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v1\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v311/ImplementationGuide/hl7.fhir.us.core.v311",
      "packageId" : "hl7.fhir.us.core.v311",
      "version" : "3.1.1"
    },
    {
      "id" : "crmi",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for the RA Data Exchange MeasureReport Profile having an extension using CRMI Software System Device profile      \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/uv/crmi/ImplementationGuide/hl7.fhir.uv.crmi",
      "packageId" : "hl7.fhir.uv.crmi",
      "version" : "1.0.0"
    },
    {
      "id" : "hl7_fhir_uv_extensions_r4",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for the measurereport-category extension.  \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2.1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-ra/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.29"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "2.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2.1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-ra/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.29"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "2.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-clinicalDataCollectionDeadline"
        },
        "name" : "Clinical Data Collection Deadline Extension",
        "description" : "Indicates the deadline for collecting data to close Condition Category (CC) coding gaps for a risk adjustment model of a measurement period.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/coding-gap-remark"
        },
        "name" : "Coding Gap Remark",
        "description" : "Coded remark for a coding gap.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/coding-gap-remark"
        },
        "name" : "Coding Gap Remark Codes",
        "description" : "Code sytstem that indicates coded remark for a coding gap.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-ccRemark"
        },
        "name" : "Condition Category Remark Extension",
        "description" : "The Condition Category Remark extension allows a coded and/or narrative remark be added to a Condition Category (CC) coding gap that is on a Payer generated risk adjustment coding gap report by a provider, an organization, or a software.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cc-type"
        },
        "name" : "Condition Category Type",
        "description" : "Type of value-based performance reporting performance metric.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-ccType"
        },
        "name" : "Condition Category Type Extension",
        "description" : "Indicates whether the Condition Category (CC) gap is historic or suspected. This extension is also used to indicate if a Condition Category (CC) is net-new.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition01pat03"
        },
        "name" : "Condition01Pat03: Other artificial openings of gastrointestinal tract status",
        "description" : "This is a Condition example with code Z93.4: Other artificial openings of gastrointestinal tract status.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition02pat01"
        },
        "name" : "Condition02Pat02: Diabetes mellitus due to underlying condition with other diabetic kidney complication",
        "description" : "This is a Condition example with code E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition03pat01"
        },
        "name" : "Condition03Pat01: Chronic obstructive pulmonary disease with (acute) exacerbation",
        "description" : "This is a Condition example with code J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition04pat03"
        },
        "name" : "Condition04Pat03: Chronic obstructive pulmonary disease with (acute) exacerbation",
        "description" : "This is a Condition example with code J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition05pat03"
        },
        "name" : "Condition05Pat03: Unspecified protein-calorie malnutrition",
        "description" : "This is a Condition example with code E46: Unspecified protein-calorie malnutrition.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition06pat03"
        },
        "name" : "Condition06Pat03: Crohn’s disease of large intestine with unspecified complications",
        "description" : "This is a Condition example with code K50.119: Crohn's disease of large intestine with unspecified complications.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition07pat03"
        },
        "name" : "Condition07Pat03: Other persistent atrial fibrillation",
        "description" : "This is a Condition example with code I48.19: Other persistent atrial fibrillation.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition08pat01"
        },
        "name" : "Condition08Pat01: Bipolar disorder, current episode mixed, mild",
        "description" : "This is a Condition example with code F31.61: Bipolar disorder, current episode mixed, mild.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition09pat01"
        },
        "name" : "Condition09Pat01: Allergic bronchopulmonary aspergillosis",
        "description" : "This is a Condition example with code B44.81: Allergic bronchopulmonary aspergillosis.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition10pat01"
        },
        "name" : "Condition10Pat01: Long term (current) use of insulin",
        "description" : "This is a Condition example with code Z79.4: Long term (current) use of insulin.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition11pat01"
        },
        "name" : "Condition11Pat01: Acute pulmonary edema",
        "description" : "This is a Condition example with code J81.0: Acute pulmonary edema.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition12pat01"
        },
        "name" : "Condition12Pat01: Manic episode, unspecified",
        "description" : "This is a Condition example with code F30.9: Manic episode, unspecified.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition15pat03"
        },
        "name" : "Condition15Pat03: Diabetes mellitus due to underlying condition with diabetic chronic kidney disease",
        "description" : "This is a Condition example with code E08.22: Diabetes mellitus due to underlying condition with diabetic chronic kidney disease.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition16pat03"
        },
        "name" : "Condition16Pat03: Dependence on renal dialysis",
        "description" : "This is a Condition example with code Z99.2: Dependence on renal dialysis.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition17pat01"
        },
        "name" : "Condition17Pat01: Body mass index (BMI) 45.0-49.9, adult",
        "description" : "This is a Condition example with code Z68.42: Body mass index [BMI] 45.0-49.9, adult.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition18pat01"
        },
        "name" : "Condition18Pat01: Longstanding persistent atrial fibrillation",
        "description" : "This is a Condition example with code I48.11: Longstanding persistent atrial fibrillation.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition21pat03"
        },
        "name" : "Condition21Pat03: Type 2 diabetes mellitus without complications",
        "description" : "This is a Condition example with code E11.9: Type 2 diabetes mellitus without complications.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition22pat03"
        },
        "name" : "Condition22Pat03: Other acute kidney failure",
        "description" : "This is a Condition example with code N17.8: Other acute kidney failure.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition23pat03"
        },
        "name" : "Condition23Pat03: Chronic kidney disease, stage 5",
        "description" : "This is a Condition example with code N18.5: Chronic kidney disease, stage 5.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition31pat02"
        },
        "name" : "Condition31Pat02: Typical atrial flutter",
        "description" : "This is a Condition example with code I48.3: Typical atrial flutter.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition32pat03"
        },
        "name" : "Condition32Pat03: Chronic pulmonary embolism",
        "description" : "This is a Condition example with code I27.82: Chronic pulmonary embolism.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition33pat01"
        },
        "name" : "Condition33Pat01: Respiratory arrest",
        "description" : "This is a Condition example with code R09.2: Respiratory arrest.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition35pat03"
        },
        "name" : "Condition35Pat03: Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene",
        "description" : "This is a Condition example with code E11.51: Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition42pat03"
        },
        "name" : "Condition42Pat03: Other artificial openings of gastrointestinal tract status",
        "description" : "This is a Condition example with code Z93.4: Other artificial openings of gastrointestinal tract status.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition43pat01"
        },
        "name" : "Condition43Pat01: Diabetes mellitus due to underlying condition with other diabetic kidney",
        "description" : "This is a Condition example with code E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-condition44pat01"
        },
        "name" : "Condition44Pat01: Allergic bronchopulmonary aspergillosis",
        "description" : "This is a Condition example with code B44.81: Allergic bronchopulmonary aspergillosis.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ra-conditionR01pat01"
        },
        "name" : "ConditionR01Pat01: Cystic fibrosis with other intestinal manifestations",
        "description" : "This is a Condition example with code E84.19: Cystic fibrosis with other intestinal manifestations.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-confidenceScale"
        },
        "name" : "Confidence Scale Extension",
        "description" : "A coded confidence scale, the degree of certainty, for a Condition Category (CC) coding gap presented in a Payer generated risk adjustment coding gap report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-contextId"
        },
        "name" : "Context Id Extension",
        "description" : "The contextId is intended to be used for 'non-standard' identifiers provided as part of the $risk-gap operation API call, for example, some systems may have an internally defined gap-request-id.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-datax-measurereport01"
        },
        "name" : "Data Exchange MeasureReport Example01",
        "description" : "This is an example for the Risk Adjustment Data Exchange MeasureReport profile. It evaluatedResource references an example C-CDA document that is being submitted.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-datax-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-dxCode"
        },
        "name" : "Diagnosis Code Extension",
        "description" : "Diganosis code(s) of the condition, such as ICD-10 codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter44pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2017-01-18 for Patient 01",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2017-01-18 for Patient 01.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter08pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2017-02-03 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2017-02-03 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter45pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2018-07-21 for Patient 01",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2018-07-21 for Patient 01.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter43pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2019-02-10 for Patient 01",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2019-02-10 for Patient 01.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter11pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2020-11-02 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2020-11-02 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter02pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2021-01-31 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2021-01-31 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter09pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2021-03-27 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2021-03-27 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter03pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2021-09-26 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2021-09-26 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter46pat01"
        },
        "name" : "Encounter with Dr Hippocrates on 2021-10-15 for Patient 01",
        "description" : "This is an Encounter example for encounter with Dr Hippocrates on 2021-10-15 for Patient 01.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter07pat03"
        },
        "name" : "Encounter with Dr Osler on 2019-02-07 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2019-02-07 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter19pat03"
        },
        "name" : "Encounter with Dr Osler on 2019-08-23 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2019-08-23 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter42pat03"
        },
        "name" : "Encounter with Dr Osler on 2020-02-10 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2020-02-10 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter05pat03"
        },
        "name" : "Encounter with Dr Osler on 2020-03-03 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2020-03-03 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter06pat03"
        },
        "name" : "Encounter with Dr Osler on 2020-09-17 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2020-09-17 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter04pat03"
        },
        "name" : "Encounter with Dr Osler on 2020-12-18 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2020-12-18 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter21pat03"
        },
        "name" : "Encounter with Dr Osler on 2021-01-30 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2021-01-30 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter35pat03"
        },
        "name" : "Encounter with Dr Osler on 2021-02-12 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2021-02-12 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter22pat03"
        },
        "name" : "Encounter with Dr Osler on 2021-07-01 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2021-07-01 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter01pat03"
        },
        "name" : "Encounter with Dr Osler on 2021-07-14 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2021-07-14 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter16pat03"
        },
        "name" : "Encounter with Dr Osler on 2021-07-27 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2021-07-27 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter15pat03"
        },
        "name" : "Encounter with Dr Osler on 2021-08-08 for Patient 03",
        "description" : "This is an Encounter example for encounter with Dr Osler on 2021-08-08 for Patient 03.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ra-encounter31pat02"
        },
        "name" : "Encounter with Dr Pump on 2021-08-06 for Patient 02",
        "description" : "This is an Encounter example for encounter with Dr Pump on 2021-08-06 for Patient 02.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/ra.evaluate-measure"
        },
        "name" : "Evaluate Measure",
        "description" : "The ra.evaluate-measure operation is used to evaluate Digital Condition Category and obtain the results.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/evidence-status"
        },
        "name" : "Evidence Status",
        "description" : "Codes that indicate whether a coding gap is an open-gap, invalid-gap, closed-gap, or pending.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-evidenceStatusDate"
        },
        "name" : "Evidence Status Date Extension",
        "description" : "Risk adjustment evidence status date",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-evidenceStatus"
        },
        "name" : "Evidence Status Extension",
        "description" : "Indicates whether a Condition Category (CC) coding gap is closed-gap, open-gap, invalid-gap, or pending based on the clinical evidence available for risk adjustment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-groupReference"
        },
        "name" : "Group Reference Extension",
        "description" : "This extension identifies which Condition Category (CC) the supporting evidence (represented by `MeasureReport.evaluatedResource`) is for.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hierarchical-status"
        },
        "name" : "Hierarchical Status",
        "description" : "Codes that indicate how hierarchies were applied to a Condition Category (CC), and if applied, whether the Condition Category (CC) is superseded.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-hierarchicalStatus"
        },
        "name" : "Hierarchical Status Extension",
        "description" : "Indicates how hiearchies were applied to a Condition Category (CC), and if applied, whether the Condition Category (CC) is superseded.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/measurereport-category"
        },
        "name" : "MeasureReportCategory",
        "description" : "Search based on the measurereport-category extension",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-laboratory01"
        },
        "name" : "Organization Example: XYZ Laboratory",
        "description" : "Laboratory that created lab observations",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-payer01"
        },
        "name" : "Organization: ABC Payer",
        "description" : "ABC Payer is an Organization example that generated Risk Adjustment Coding Gap Report.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-vendor01"
        },
        "name" : "Organization: Best RA Vendor",
        "description" : "Best RA Vendor is an Organization example that generated Risk Adjustment Data Exchange MeasureReport.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-org03pat03"
        },
        "name" : "Organization: Community HealthCenter",
        "description" : "Community HealthCenter is an Organization example, which is used for example Patient 03 data.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-org01pat01"
        },
        "name" : "Organization: Community Urgent Care",
        "description" : "Community Urgent Care is an Organization example, which is used for example Patient 01 data.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-org02pat02"
        },
        "name" : "Organization: GHH Outpatient Clinic",
        "description" : "GHH Outpatient Clinic is an Organization example, which is used for example Patient 02 data.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ra-org-author"
        },
        "name" : "Organization: Risk Adjustment Author",
        "description" : "This is an example Organization that is the author of the RA report",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/ra-documentreference01pat01"
        },
        "name" : "Outpatient Note for Patient01 Eve Everywoman",
        "description" : "This is an outpatient note example for the *US Core DocumentReference Profile*.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ra-measurereport01-patch-mult"
        },
        "name" : "Patch Example01 with multiple value (ra-measurereport01)",
        "description" : "This is an example using the patch operation to send a Condition Category Remark with data for two Condition Categories (group-001, group-002) and one with multiple attributes: authorDatetime, text.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-parameters-cc-remark-patch"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ra-measurereport01-patch"
        },
        "name" : "Patch Example02 (ra-measurereport01)",
        "description" : "This is an example using the patch operation to send a Condition Category Remark for one Condition Category (group-001) with one attribute: authorDatetime.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-parameters-cc-remark-patch"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-patient-group"
        },
        "name" : "Patient Group",
        "description" : "The Patient Group Profile describes a group consisting of one or more patients. It can be used a) when generating risk adjustment gap reports using Bulk FHIR or b) for the evaluated-approach for generating reports as defined on the dCC page.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Group"
          }
        ],
        "reference" : {
          "reference" : "Group/ra-group01"
        },
        "name" : "Patient Group Example 1",
        "description" : "This is an example for the Patient Group profile. This example patient group has one member.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-patient-group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Group"
          }
        ],
        "reference" : {
          "reference" : "Group/ra-group02"
        },
        "name" : "Patient Group Example 2",
        "description" : "This is an example for the Patient Group profile. This example patient group has two members.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-patient-group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/ra-patient01"
        },
        "name" : "Patient01: Eve Everywoman",
        "description" : "This is an example patient that uses the USCore profile. The example patient name is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/ra-patient02"
        },
        "name" : "Patient02: Adam Everyman",
        "description" : "This is an example patient that uses the US Core Patient profile. The example patient name is Adam Everyman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/ra-patient03"
        },
        "name" : "Patient03: Nelda Nuclear",
        "description" : "This is an example patient that uses the US Core Patient profile. The example patient name is Nelda Nuclear.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-payerCodingGapReportId"
        },
        "name" : "Payer Coding Gap Report Id Extension",
        "description" : "Unique id of the original payer generated coding gap report. This is the MeasureReport.id from the Risk Adjustment Coding Gap Report profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ra-obs02pat03"
        },
        "name" : "PHQ9 Total Score for Patient 03",
        "description" : "This is a PHQ9 Total Score for Patient 03.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/ra-prac01pat01"
        },
        "name" : "Practitioner01: Harold Hippocrates",
        "description" : "This is an example practitioner that uses the US Core Practitioner profile. The example practitioner is an individual practitioner: Harold Hippocrates.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/ra-prac02pat02"
        },
        "name" : "Practitioner02: Patrick Pump",
        "description" : "This is an example practitioner that uses the US Core Practitioner profile. The example practitioner is an organization: GHH Outpatient Clinic.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/ra-prac03pat03"
        },
        "name" : "Practitioner03: Otto Osler",
        "description" : "This is an example practitioner that uses the US Core Practitioner profile. The example practitioner is an organization: Community HealthCenter.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-qualifyingDxCode"
        },
        "name" : "QualifyingCode Extension",
        "description" : "Diagnosis code(s) classified under a Condition Category, as defined by the risk adjustment model. This usually comes into play in the scenario where proprietary risk models are used and the mappings of ICD-10 codes to Condition Categories are not readily available. Note that whether qualifying codes may be included in a report depending may depend on individual Risk Adjustment model licensing agreement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport01"
        },
        "name" : "RA Coding Gap MeasureReport Example01 with RA Model CMS-HCC V24 for Patient01 Eve Everywoman",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-HCC version 24 as the Risk Adjustment Model and the example patient used is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport02"
        },
        "name" : "RA Coding Gap MeasureReport Example02 with RA Model CMS-RxHCC V5 for Patient01 Eve Everywoman",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport03"
        },
        "name" : "RA Coding Gap MeasureReport Example03 with RA Model CMS-HCC V24 for Patient02 Adam Everyman",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-HCC version 24 as the Risk Adjustment Model and the example patient used is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport04"
        },
        "name" : "RA Coding Gap MeasureReport Example04 with RA Model CMS-HCC V21 for Patient03 Nelda Nuclear",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-HCC version 21 as the Risk Adjustment Model and the example patient used is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport05"
        },
        "name" : "RA Coding Gap MeasureReport Example05 with RA Model CMS-RxHCC V5 for Patient03 Nelda Nuclear",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport06"
        },
        "name" : "RA Coding Gap MeasureReport Example06 with RA Model CMS-RxHCC V5 for Patient02 Adam Everyman",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/confidence-scale"
        },
        "name" : "RA Confidence Scale",
        "description" : "Codes that describe the confidence scale of a risk adjustment Condition Category (CC).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MeasureReport"
          }
        ],
        "reference" : {
          "reference" : "MeasureReport/ra-measurereport01-with-remark"
        },
        "name" : "RA MeasureReport with Remark Example (ra-measurereport01-with-remark)",
        "description" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile that shows using the Condition Category Remark extension. The remark is added to MeasureReport.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Measure"
          }
        ],
        "reference" : {
          "reference" : "Measure/RAModelExample01"
        },
        "name" : "RA Model Example01 CMS-HCC version 24",
        "description" : "This is an example for the Risk Adjustment Model Measure profile. The example uses the CMS-HCC version 24 as the example Risk Adjustment Model.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-model-measure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Measure"
          }
        ],
        "reference" : {
          "reference" : "Measure/RAModelExample02"
        },
        "name" : "RA Model Example02 CMS-HCC version 21",
        "description" : "This is an example for the Risk Adjustment Model Measure profile. The example uses the CMS-HCC version 21 as the example Risk Adjustment Model.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-model-measure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Measure"
          }
        ],
        "reference" : {
          "reference" : "Measure/RAModelExample03"
        },
        "name" : "RA Model Example03 CMS-RxHCC version 5",
        "description" : "This is an example for the Risk Adjustment Model Measure profile. The example uses the CMS-RxHCC version 5 as the example Risk Adjustment Model.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-model-measure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-parameters-cc-remark-patch"
        },
        "name" : "RA Parameters ccRemark Patch Profile",
        "description" : "A Parameters profile that defines structures of multi-part Parameters to be used for sending [Condition Category Remarks](StructureDefinition-ra-ccRemark.html) to a [Risk Adjustment Coding Gap Report](StructureDefinition-ra-measurereport.html) using the [PATCH](https://www.hl7.org/fhir/http.html#patch) operation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/remark-reason"
        },
        "name" : "Remark Reason",
        "description" : "Reason for the remark",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/remark-reason"
        },
        "name" : "Remark Reason Codes",
        "description" : "Reason codes for remark",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-reportingVendor"
        },
        "name" : "Reporting Vendor Extension",
        "description" : "A reference to the vendor who generated the report. The 'reporting vendor' is intended to represent the submitting entity when it is not the same as the reporting entity. This extension is used when the Receiver is interested in getting vendor information in the report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-measurereport"
        },
        "name" : "Risk Adjustment Coding Gap MeasureReport",
        "description" : "This profile is based on the [MeasureReport](http://hl7.org/fhir/R4/measurereport.html) to represent a risk adjustment coding gap report. Payer runs risk adjustment engine and uses this profile to represent the risk adjustment Condition Category (CC) coding gaps and their detailed information for a patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-measurereport-with-remark"
        },
        "name" : "Risk Adjustment Coding Gap MeasureReport with Remark",
        "description" : "This profile represents a risk adjustment coding gap report with condition categories and at least one of the condition category has one or more condition category remark(s).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-measurereport-bundle"
        },
        "name" : "Risk Adjustment Coding Gap Report Bundle",
        "description" : "The Risk Adjustment Coding Gap Report Bundle Profile describes a collection bundle returned by the [$ra.evaluate-measure](OperationDefinition-ra.evaluate-measure.html) operation. This bundle is a collection of Risk Adjustment Coding Gap Reports.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cc-type"
        },
        "name" : "Risk Adjustment Condition Category Type Codes",
        "description" : "Code sytstem that indicates whether it is a suspected Condition Category (CC) gap, a historic Condition Category (CC) gap, or a net-new Condition Category (CC). Historic, suspected, and net-new are mutually exclusive.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-datax-measurereport"
        },
        "name" : "Risk Adjustment Data Exchange MeasureReport",
        "description" : "This profile is based on the [MeasureReport](http://hl7.org/fhir/R4/measurereport.html). It is used for Provider to submit data such as clinical evaluation evidence to Payer.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/ra-data-submission-client"
        },
        "name" : "Risk Adjustment Data Submission Client Capability Statement",
        "description" : "This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Data Submission Clients and Data Submission Servers. Clients are the actors creating and submitting the Risk Adjustment Data Exchange Measure Reports using the $submit-data operation to the Server.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/ra-data-submission-server"
        },
        "name" : "Risk Adjustment Data Submission Server Capability Statement",
        "description" : "This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Clients and Servers. Servers are the actors receiving and processing the Risk Adjustment Data Exchange MeasureReports submitted by the Client.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/evidence-status"
        },
        "name" : "Risk Adjustment Evidence Status Codes",
        "description" : "Code System that indicates whether a coding gap is an open-gap, invalid-gap, closed-gap or pending",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hierarchical-status"
        },
        "name" : "Risk Adjustment Hierarchical Status Codes",
        "description" : "Code system that indicates how hierarchies were applied to a Condition Category (CC), and if applied, whether the Condition Category (CC) is superseded.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/ra-bundle01"
        },
        "name" : "Risk Adjustment MeasureReport Bundle example, MeasureReport01: Patient01",
        "description" : "This is an Risk Adjustment MeasureReport Bundle example includes MeasureReport01 for Patient01.",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-measurereport-remark-bundle"
        },
        "name" : "Risk Adjustment MeasureReport With Remark Bundle",
        "description" : "This bundle contains a Risk Adjustment Coding Gap MeasureReport that has Condition Category Remark (ccRemark) present on at least one of the Condition Categories. It also contains the relevant resources referenced by the ccRemark.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ra-model-measure"
        },
        "name" : "Risk Adjustment Model Measure",
        "description" : "This risk adjustment model measure profile is based on the [Measure](http://hl7.org/fhir/R4/measure.html) resource to represent a risk adjustment model and its version, such as CMS-HCC version 24, CMS-HCC version 28.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/ra-reporting-client"
        },
        "name" : "Risk Adjustment Reporting Client Capability Statement",
        "description" : "This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Clients are the actors making the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustmenet Models that are available on the Server. This CapabilityStatement resource includes the complete list of the *recommended* Da Vinci Risk Adjustment profiles and RESTful operations that a Risk Adjustment Reporting Client could support. Clients have the option of choosing from this list based on their local use cases and other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/ra-reporting-server"
        },
        "name" : "Risk Adjustment Reporting Server Capability Statement",
        "description" : "This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Servers are the actors receiving the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustmenet Models that are available on the Server. This CapabilityStatement resource includes the complete list of the *recommended* Da Vinci Risk Adjustment profiles and RESTful operations that a Risk Adjustment Reporting Server could support. Servers have the option of choosing from this list based on their local use cases and other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/risk-gap"
        },
        "name" : "Risk Gap",
        "description" : "The risk-gap operation is used to determine condition Category (CC) gaps for a patient/member.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sample-cmshcc"
        },
        "name" : "Sample CMS Hierarchical Condition Category",
        "description" : "This is a sample of the concepts that can be found in the CMS Hierarchical Condition Categories (CMS-HCC) code system version 24. The source of the codes included in this example was published at https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Downloads/Announcement2020.pdf. The CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories (CCs) that predict costs well. The condition categories (CCs) are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the Condition Categories (CCs) to capture the most costly diagnoses. Hierarchy logic is imposed on certain Condition Categories (CCs) to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ra-obs01pat03"
        },
        "name" : "Serum Creatinine for Patient 03",
        "description" : "This is an example for Observation. Serum Creatinine for Patient 03 Nelda Nuclear performed at XYZ Laboratory.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/ra-submit-data"
        },
        "name" : "Submit Data example for sending a C-CDA document",
        "description" : "This is an example for using $submit-data oepration to send a C-CDA document as supporting evidence using the RA Data Exchange MeasureReport.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/submit-remark-data"
        },
        "name" : "Submit Remark Data",
        "description" : "A [Condition Category Remark](StructureDefinition-ra-ccRemark.html) may reference resources such as Pracitioner and Condition, using Patch to submit the remark may not be feasible. This operation is used to submit a Risk Adjustment Coding Gap Report with one or more ccRemarks on at least one of the Condition Categories, along with the relevant resources referenced by the ccRemark(s).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ra-obs21pat01"
        },
        "name" : "Trypsin [Mass/volume] in Serum or Plasma for Patient 01",
        "description" : "Trypsin [Mass/volume] in Serum or Plasma for Patient 01.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|7.0.0"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ra-obs01pat02"
        },
        "name" : "Trypsin [Mass/volume] in Serum or Plasma for Patient 02",
        "description" : "This is an example for Observation profile. Trypsin [Mass/volume] in Serum or Plasma for Patient 02 Adam Everyman performed at XYZ Laboratory.",
        "exampleCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|7.0.0"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "fhir.html"
            }
          ],
          "nameUrl" : "fhir.html",
          "title" : "Reading this IG - FHIR Introduction",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "credits.html"
            }
          ],
          "nameUrl" : "credits.html",
          "title" : "Projects and Participants",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "general-guidance.html"
            }
          ],
          "nameUrl" : "general-guidance.html",
          "title" : "General Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "report-generation.html"
            }
          ],
          "nameUrl" : "report-generation.html",
          "title" : "Report Generation",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "report-query.html"
            }
          ],
          "nameUrl" : "report-query.html",
          "title" : "Report Query",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "submit-data-to-payer.html"
            }
          ],
          "nameUrl" : "submit-data-to-payer.html",
          "title" : "Submit Data To Payer",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "cc-remark.html"
            }
          ],
          "nameUrl" : "cc-remark.html",
          "title" : "Add Remark to Condition Category",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "draft"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dcc.html"
            }
          ],
          "nameUrl" : "dcc.html",
          "title" : "Digital Condition Category (dCC)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Security, Privacy, and Safety",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "glossary.html"
            }
          ],
          "nameUrl" : "glossary.html",
          "title" : "Glossary",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles.html"
            }
          ],
          "nameUrl" : "profiles.html",
          "title" : "Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "extensions.html"
            }
          ],
          "nameUrl" : "extensions.html",
          "title" : "Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "search-parameters.html"
            }
          ],
          "nameUrl" : "search-parameters.html",
          "title" : "Search Parameters",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology.html"
            }
          ],
          "nameUrl" : "terminology.html",
          "title" : "Terminology",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "operations.html"
            }
          ],
          "nameUrl" : "operations.html",
          "title" : "Operation",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capabilities.html"
            }
          ],
          "nameUrl" : "capabilities.html",
          "title" : "Capability Statements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "tools.html"
            }
          ],
          "nameUrl" : "tools.html",
          "title" : "Tooling and Support",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "change-log.html"
            }
          ],
          "nameUrl" : "change-log.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "input/pagecontent"
      },
      {
        "code" : "path-pages",
        "value" : "input/intro-notes"
      },
      {
        "code" : "path-pages",
        "value" : "fsh-generated/includes"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
