# Reading this IG - FHIR Introduction - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Reading this IG - FHIR Introduction**

## Reading this IG - FHIR Introduction

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This implementation guide uses terminology, notations and design principles that are specific to FHIR. Before reading this implementation guide, it is important to be familiar with some of the basic principles of FHIR as well as general guidance on how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to read (or at least skim) the following prior to reading the rest of this implementation guide.

* [FHIR overview](http://hl7.org/fhir/R4/overview.html)
* [Developer's introduction](http://hl7.org/fhir/R4/overview-dev.html) (or [Clinical introduction](http://hl7.org/fhir/R4/overview-clinical.html))
* [FHIR data types](http://hl7.org/fhir/R4/datatypes.html)
* [Using codes](http://hl7.org/fhir/R4/terminologies.html)
* [References between resources](http://hl7.org/fhir/R4/references.html)
* [How to read resource & profile definitions](http://hl7.org/fhir/R4/formats.html)
* [Base resource](http://hl7.org/fhir/R4/resource.html)

This implementation guide supports the [R4](http://hl7.org/fhir/R4/index.html) version of the FHIR standard and builds on the [US Core 3.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU3.1.1), [US Core 6.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU6.1), and [US Core 7.0 (FHIR R4)](http://hl7.org/fhir/us/core/STU7) implementation guides. Implementers therefore need to familiarize themselves with those profiles as well. The general implementation notes and guidance on the resource pages of these guides will apply to Da Vinci implementations as they would in any other. A complete list of the FHIR resources in the core specification can be found [here](http://hl7.org/fhir/R4/resourcelist.html)

