# Examples - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

-------

### Bundle

* [Bundle01: Risk Adjustment Bundle, (MeasureReport01: Patient01)](Bundle-ra-bundle01.md)

### Condition

* [Condition01Pat03: Other artificial openings of gastrointestinal tract status](Condition-ra-condition01pat03.md)
* [Condition02pat01: Diabetes mellitus due to underlying condition with other diabetic kidney complication](Condition-ra-condition02pat01.md)
* [Condition03pat01: Chronic obstructive pulmonary disease with (acute) exacerbation](Condition-ra-condition03pat01.md)
* [Condition04Pat03: Chronic obstructive pulmonary disease with (acute) exacerbation](Condition-ra-condition04pat03.md)
* [Condition05Pat03: Unspecified protein-calorie malnutrition](Condition-ra-condition05pat03.md)
* [Condition06Pat03: Crohn's disease of large intestine with unspecified complications](Condition-ra-condition06pat03.md)
* [Condition07Pat03: Other persistent atrial fibrillation](Condition-ra-condition07pat03.md)
* [Condition08pat01: Bipolar disorder, current episode mixed, mild](Condition-ra-condition08pat01.md)
* [Condition09Pat01: Allergic bronchopulmonary aspergillosis](Condition-ra-condition09pat01.md)
* [Condition10Pat01: Long term (current) use of insulin](Condition-ra-condition10pat01.md)
* [Condition11Pat01: Acute pulmonary edema](Condition-ra-condition11pat01.md)
* [Condition12Pat01: Manic episode, unspecified](Condition-ra-condition12pat01.md)
* [Condition15Pat03: Diabetes mellitus due to underlying condition with diabetic chronic kidney disease](Condition-ra-condition15pat03.md)
* [Condition16Pat03: Dependence on renal dialysis](Condition-ra-condition16pat03.md)
* [Condition17Pat01: Body mass index (BMI) 45.0-49.9, adult](Condition-ra-condition17pat01.md)
* [Condition18Pat01: Longstanding persistent atrial fibrillation](Condition-ra-condition18pat01.md)
* [Condition21Pat03: Type 2 diabetes mellitus without complications](Condition-ra-condition21pat03.md)
* [Condition22Pat03: Other acute kidney failure](Condition-ra-condition22pat03.md)
* [Condition23Pat03: Chronic kidney disease, stage 5](Condition-ra-condition23pat03.md)
* [Condition31Pat02: Typical atrial flutter](Condition-ra-condition31pat02.md)
* [Condition32Pat03: Chronic pulmonary embolism](Condition-ra-condition32pat03.md)
* [Condition33Pat01: Respiratory arrest](Condition-ra-condition33pat01.md)
* [Condition35Pat03: Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene](Condition-ra-condition35pat03.md)
* [Condition42Pat03: Other artificial openings of gastrointestinal tract status](Condition-ra-condition42pat03.md)
* [Condition43pat01: Diabetes mellitus due to underlying condition with other diabetic kidney complication](Condition-ra-condition43pat01.md)
* [Condition44Pat01: Allergic bronchopulmonary aspergillosis](Condition-ra-condition44pat01.md)

### Encounter

* [Encounter01Pat03: Pat03 Encounter on 2021-07-14](Encounter-ra-encounter01pat03.md)
* [Encounter02Pat01: Pat01 Encounter on 2021-01-31](Encounter-ra-encounter02pat01.md)
* [Encounter03Pat01: Pat01 Encounter on 2021-09-26](Encounter-ra-encounter03pat01.md)
* [Encounter04Pat03: Pat03 Encounter on 2020-12-18](Encounter-ra-encounter04pat03.md)
* [Encounter05Pat03: Pat03 Encounter on 2020-03-03](Encounter-ra-encounter05pat03.md)
* [encounter06Pat03: Pat03 Encounter on 2020-09-17](Encounter-ra-encounter06pat03.md)
* [Encounter07Pat03: Pat03 Encounter on 2019-02-07](Encounter-ra-encounter07pat03.md)
* [Encounter08Pat01: Pat01 Encounter on 2017-02-03](Encounter-ra-encounter08pat01.md)
* [Encounter09Pat01: Pat01 Encounter on 2021-03-27](Encounter-ra-encounter09pat01.md)
* [Encounter11Pat01: Pat01 Encounter on 2020-11-02](Encounter-ra-encounter11pat01.md)
* [Encounter15Pat03: Pat03 Encounter on 2021-08-08](Encounter-ra-encounter15pat03.md)
* [Encounter16Pat03: Pat03 Encounter on 2021-07-27](Encounter-ra-encounter16pat03.md)
* [Encounter19Pat03: Pat03 Encounter on 2019-08-23](Encounter-ra-encounter19pat03.md)
* [Encounter21Pat03: Pat03 Encounter on 2021-01-30](Encounter-ra-encounter21pat03.md)
* [Encounter22Pat03: Pat03 Encounter on 2021-07-01](Encounter-ra-encounter22pat03.md)
* [Encounter31Pat02: Pat02 Encounter on 2021-08-06](Encounter-ra-encounter31pat02.md)
* [Encounter35Pat03: Pat03 Encounter on 2021-02-12](Encounter-ra-encounter35pat03.md)
* [Encounter42Pat03: Pat03 Encounter on 2020-02-10](Encounter-ra-encounter42pat03.md)
* [Encounter43Pat01: Pat01 Encounter on 2019-02-10](Encounter-ra-encounter43pat01.md)
* [Encounter44Pat01: Pat01 Encounter on 2017-01-18](Encounter-ra-encounter44pat01.md)
* [Encounter45Pat01: Pat01 Encounter on 2018-07-21](Encounter-ra-encounter45pat01.md)

### Group

* [Group01: Risk Adjustment Patient Group, (Patient01: Eve Everywoman)](Group-ra-group01.md)
* [Group02: Risk Adjustment Patient Group, (Patient02: Adam Everyman, Patient03: Nelda Nuclear)](Group-ra-group02.md)

### Measure

* [Measure01: Risk Adjustment Model CMS-HCC V24](Measure-RAModelExample01.md)
* [Measure02: Risk Adjustment Model CMS-HCC V21](Measure-RAModelExample02.md)
* [Measure03: Risk Adjustment Model CMS-RxHCC V05](Measure-RAModelExample03.md)

### MeasureReport

* [MeasureReport01: Risk Adjustment Coding Gap Report, RA Model CMS-HCC V24 (Patient01: Eve Everywoman)](MeasureReport-ra-measurereport01.md)
* [MeasureReport01WithRemarks: Risk Adjustment Coding Report with Condition Category Remarks Added, RA Model CMS-HCC V24 (Patient01: Eve Everywoman)](MeasureReport-ra-measurereport01-with-remark.md)
* [MeasureReport02: Risk Adjustment Coding Gap Report, RA Model CMS-RxHCC V5 (Patient01: Eve Everywoman)](MeasureReport-ra-measurereport02.md)
* [MeasureReport03: Risk Adjustment Coding Gap Report, RA Model CMS-HCC V24 (Patient02: Adam Everyman)](MeasureReport-ra-measurereport03.md)
* [MeasureReport04: Risk Adjustment Coding Gap Report, RA Model CMS-HCC V21 (Patient03: Nelda Nuclear)](MeasureReport-ra-measurereport04.md)
* [MeasureReport05: Risk Adjustment Coding Gap Report, RA Model CMS-RxHCC V5 (Patient03: Nelda Nuclear)](MeasureReport-ra-measurereport05.md)
* [MeasureReport06: Risk Adjustment Coding Gap Report, RA Model CMS-RxHCC V5 (Patient02: Adam Everyman)](MeasureReport-ra-measurereport06.md)
* [Data Exchange MeasureReport01: RA Model CMS-HCC V24 (Patient01: Eve Everywoman)](MeasureReport-ra-datax-measurereport01.md)

### DocumentReference

* [DocumentReference Example: Outpatient Note for Patient01 Eve Everywoman](DocumentReference-ra-documentreference01pat01.md)

### Observation

* [Observation01Pat03: Pat03 Creatinine on 20210728](Observation-ra-obs01pat03.md)
* [Observation02Pat03: Pat03 PHQ9 on 20190823](Observation-ra-obs02pat03.md)
* [Observation21Pat01: Pat01 Trypsin (Mass/volume) in Serum or Plasma from 20170617](Observation-ra-obs21pat01.md)

### Organization

* [Organization Example: XYZ Laboratory](Organization-ra-laboratory01.md)
* [Organization01: Payer Organization ABC Payer](Organization-ra-payer01.md)
* [Organization01Pat01: Community Urgent Care](Organization-ra-org01pat01.md)
* [Organization02Pat02: GHH Outpatient Clinic](Organization-ra-org02pat02.md)
* [Organization01Pat03: Community HealthCenter](Organization-ra-org03pat03.md)

### Patient

* [Patient01: Eve Everywoman](Patient-ra-patient01.md)
* [Patient02: Adam Everyman](Patient-ra-patient02.md)
* [Patient03: Nelda Nuclear](Patient-ra-patient03.md)

### Practitioner

* [Practitioner01: Harold Hippocrates](Practitioner-ra-prac01pat01.md)
* [Practitioner02: Patrick Pump](Practitioner-ra-prac02pat02.md)
* [Practitioner03: Otto Osler](Practitioner-ra-prac03pat03.md)

### Parameters

* [Parameters: PATCH example for sending Condition Category Remark](Parameters-ra-measurereport01-patch.json.md)
* [Parameters: PATCH example for sending Condition Category Remark with multiple value](Parameters-ra-measurereport01-patch-mult.md)
* [Parameters: Submit Data example for sending a C-CDA document](Parameters-ra-submit-data.md)

