# Projects and Participants - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Projects and Participants**

## Projects and Participants

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### The Da Vinci Project

[Da Vinci](https://www.hl7.org/about/davinci/index.cfm) is an HL7-sponsored project that brings together U.S. payers, providers, and technology suppliers to help payers and providers improve clinical, quality, cost, and care management outcomes using FHIR-related technologies. The project organizes meetings (face-to-face and conference calls) and connectathons to find ways to leverage FHIR technologies to support and integrate value-based care (VBC) data exchange across communities. Da Vinci identifies value-based care use cases of interest to its members and to the broader community.

The process that Da Vinci has adopted includes:

1. identifying business, clinical, technical, and testing requirements
1. developing and balloting a FHIR-based implementation guide (IG)
1. developing reference implementations (RIs) to demonstrate that the concepts in the IG are possible to implement
1. piloting the standard
1. supporting the production use of the IG to enable exchange of data to support interoperability for value-based care

All Da Vinci work adheres to a common set of [guiding principles](https://hl7.org/fhir/us/davinci-hrex/davinci-guiding-principles.html).

Additional information about Da Vinci, its members, the use cases, and the implementation guides being developed can all be found on the [HL7 website](http://www.hl7.org/about/davinci). Meeting minutes and other materials can be found on the [Da Vinci Confluence page](https://confluence.hl7.org/display/DVP).

### Credits

This implementation guide was made possible by the thoughtful contributions of the following people and organizations:

* **The[Da Vinci Project](http://www.hl7.org/about/davinci/index.cfm?ref=common)member organizations.**

Primary Authors

* Brent Zenobia (Novillus)
* Linda Michaelsen (Optum)
* Rob Reynolds (Smile Digital Health)
* Yan Heras (Optimum eHealth)

Contributors

* Amy Neftzger (United Healthcare)
* Brian J Murtha (Centene)
* Bryn Rhodes (Smile Digital Health)
* Cody Danielshak (Epic)
* Josh Lamb (Optum)
* Lloyd McKenzie (Dogwood Health Consulting)
* Nidhi Pengoria (Athenahealth)
* Swati Mukherjee (Optum)
* Rose Tucker (United Healthcare)
* Viet Nguyen (Stratametrics)

Project management and coordination

* Teresa Younkin (Point of Care Partners)
* Yan Heras (Optimum eHealth)

-------

Special thanks go to the numerous individuals who have participated in conference calls, ballots, and reviews of this IG.

If you are interested in participating in the VBPR project: information about our calls, minutes of past discussions, and other information can be found [here](https://confluence.hl7.org/pages/viewpage.action?pageId=104582473) on our HL7 Confluence page.

