# Confidence Scale Extension - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Confidence Scale Extension**

## Extension: Confidence Scale Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-confidenceScale | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:ConfidenceScale |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.42.4 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

A coded confidence scale, the degree of certainty, for a Condition Category (CC) coding gap presented in a Payer generated risk adjustment coding gap report.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md)
* Examples for this Extension: [MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md) and [MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-ra|current/StructureDefinition/ra-confidenceScale)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ra-confidenceScale.csv), [Excel](StructureDefinition-ra-confidenceScale.xlsx), [Schematron](StructureDefinition-ra-confidenceScale.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ra-confidenceScale",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-confidenceScale",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.29.42.4"
    }
  ],
  "version" : "2.1.0",
  "name" : "ConfidenceScale",
  "title" : "Confidence Scale Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "A coded confidence scale, the degree of certainty, for a Condition Category (CC) coding gap presented in a Payer generated risk adjustment coding gap report.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MeasureReport.group"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Confidence scale for a coding gap",
        "definition" : "Coding gap confidence scale",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-confidenceScale"
      },
      {
        "id" : "Extension.valueCodeableConcept",
        "path" : "Extension.valueCodeableConcept",
        "short" : "Confidence scale for a coding gap",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-ra/ValueSet/confidence-scale"
        }
      }
    ]
  }
}

```
