# Submit Data example for sending a C-CDA document - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Submit Data example for sending a C-CDA document**

## Example Parameters: Submit Data example for sending a C-CDA document



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "ra-submit-data",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Submit Data example for sending a C-CDA document"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example for using $submit-data oepration to send a C-CDA document as supporting evidence using the RA Data Exchange MeasureReport."
      }
    ]
  },
  "parameter" : [
    {
      "name" : "MeasureReport",
      "resource" : {
        "resourceType" : "MeasureReport",
        "id" : "ra-datax-measurereport01",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-datax-measurereport"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p><b>Generated Narrative: MeasureReport</b><a name=\"ra-datax-measurereport01\"> </a></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Resource MeasureReport &quot;ra-datax-measurereport01&quot; </p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-ra-datax-measurereport.html\">Risk Adjustment Data Exchange MeasureReport</a></p></div><p><b>Payer Coding Gap Report Id</b>: ra-measurereport01</p><p><b>status</b>: complete</p><p><b>type</b>: data-collection</p><p><b>measure</b>: <a href=\"Measure-RAModelExample01.html\">Risk Adjustment Model Version 24 - CMS Hierarchical Category Condition (CMS-HCC)</a></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Patient/ra-patient01</a> &quot; EVERYWOMAN&quot;</p><p><b>date</b>: 2021-11-10</p><p><b>reporter</b>: <a href=\"Organization-ra-org02pat02.html\">Organization/ra-org02pat02</a> &quot;GHH Outpatient Clinic&quot;</p><p><b>period</b>: 2021-01-01 --&gt; 2021-09-30</p><p><b>evaluatedResource</b>: <a href=\"DocumentReference-ra-documentreference01pat01.html\">DocumentReference/ra-documentreference01pat01</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
                  "code" : "ra"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-payerCodingGapReportId",
            "valueId" : "ra-measurereport01"
          }
        ],
        "status" : "complete",
        "type" : "data-collection",
        "measure" : "http://hl7.org/fhir/us/davinci-ra/Measure/RAModelExample01",
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "date" : "2021-11-10",
        "reporter" : {
          "reference" : "Organization/ra-org02pat02"
        },
        "period" : {
          "start" : "2021-01-01",
          "end" : "2021-09-30"
        },
        "evaluatedResource" : [
          {
            "reference" : "DocumentReference/ra-documentreference01pat01"
          }
        ]
      }
    },
    {
      "name" : "resource",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "ra-documentreference01pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Episode Summary Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a episode summary example for the *US Core DocumentReference Profile*."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference ra-documentreference01pat01</b></p><a name=\"ra-documentreference01pat01\"> </a><a name=\"hcra-documentreference01pat01\"> </a><a name=\"ra-documentreference01pat01-en-US\"> </a><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-uri.html\" title=\"As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem.\">Uniform Resource Identifier (URI)</a>/urn:oid:2.16.840.1.113883.19.5.99999.1</p><p><b>status</b>: Current</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 34108-1}\">CCD Document</span></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category clinical-note}\">Clinical Note</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman</a></p><p><b>date</b>: 2021-03-27 15:29:46+0000</p><p><b>author</b>: <a href=\"Practitioner-ra-prac01pat01.html\">Harold Hippocrates, MD</a></p><p><b>description</b>: Clinical Note</p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Data</b></td></tr><tr><td style=\"display: none\">*</td><td>text/plain</td><td><code>DQpQYXRpZW50OiBFdmUgRXZlcnl3b21lbg0KRE9COiAgMS8xNi8xOTc1DQpNUiM6ICAxMjM0NQ0KDQpEYXRlIG9mIFZpc2l0OiAzLzI3LzIwMjENClBhdGllbnQgcmVwb3J0cyB0aGUgaW5hYmlsaXR5IHRvIGRpZ2VzdCBmb29kIHByb3Blcmx5IGR1ZSB0byBhbiBpbnN1ZmZpY2llbmN5IGluIGV4b2NyaW5lIHBhbmNyZWF0aWMgZGlnZXN0aXZlIGVuenltZXMuIFBhdGllbnQgZXhwZXJpZW5jaW5nIGFiZG9taW5hbCBwYWluLCBkaWFycmhlYSwgZ2FzLCBhbmQgd2VpZ2h0IGxvc3MuIE9yZGVyZWQgUEVSVCB0cmVhdG1lbnQuDQoNCg0KDQpIYXJvbGQgSGlwcG9jcmF0ZXMsIE1EDQo=</code></td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
          }
        ],
        "status" : "current",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34108-1",
              "display" : "Outpatient Note"
            }
          ],
          "text" : "CCD Document"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
                "code" : "clinical-note",
                "display" : "Clinical Note"
              }
            ],
            "text" : "Clinical Note"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01",
          "display" : "Eve Everywoman"
        },
        "date" : "2021-03-27T15:29:46Z",
        "author" : [
          {
            "reference" : "Practitioner/ra-prac01pat01",
            "display" : "Harold Hippocrates, MD"
          }
        ],
        "description" : "Clinical Note",
        "content" : [
          {
            "attachment" : {
              "contentType" : "text/plain",
              "data" : "DQpQYXRpZW50OiBFdmUgRXZlcnl3b21lbg0KRE9COiAgMS8xNi8xOTc1DQpNUiM6ICAxMjM0NQ0KDQpEYXRlIG9mIFZpc2l0OiAzLzI3LzIwMjENClBhdGllbnQgcmVwb3J0cyB0aGUgaW5hYmlsaXR5IHRvIGRpZ2VzdCBmb29kIHByb3Blcmx5IGR1ZSB0byBhbiBpbnN1ZmZpY2llbmN5IGluIGV4b2NyaW5lIHBhbmNyZWF0aWMgZGlnZXN0aXZlIGVuenltZXMuIFBhdGllbnQgZXhwZXJpZW5jaW5nIGFiZG9taW5hbCBwYWluLCBkaWFycmhlYSwgZ2FzLCBhbmQgd2VpZ2h0IGxvc3MuIE9yZGVyZWQgUEVSVCB0cmVhdG1lbnQuDQoNCg0KDQpIYXJvbGQgSGlwcG9jcmF0ZXMsIE1EDQo="
            }
          }
        ]
      }
    },
    {
      "name" : "resource",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "ra-patient01",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\"><b>Eve Everywoman (OFFICIAL)</b> female, DoB: 1975-01-16 ( Medical record number/12345 (use: USUAL))</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td>true</td><td style=\"background-color: #f3f5da\" title=\"Known status of Patient\">Deceased:</td><td>false</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes: {http://terminology.hl7.org/CodeSystem/v3-MaritalStatus M}\">Married</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail:</td><td colspan=\"3\">2222 Home Street Ann Arbor MI 99999 USA (HOME)</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Languages spoken\">Language:</td><td colspan=\"3\"><span title=\"Codes: {urn:ietf:bcp:47 en-US}\">English (United States)</span> (preferred)</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality.  The ethnicity codes used to represent these concepts are based upon the [CDC ethnicity and Ethnicity Code Set Version 1.0](http://www.cdc.gov/phin/resources/vocabulary/index.html) which includes over 900 concepts for representing race and ethnicity of which 43 reference ethnicity.  The ethnicity concepts are grouped by and pre-mapped to the 2 OMB ethnicity categories: - Hispanic or Latino - Not Hispanic or Latino.\">US Core Ethnicity Extension:</td><td colspan=\"3\"><ul><li>ombCategory: <a href=\"http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2186-5\">Race &amp; Ethnicity - CDC</a> 2186-5: Not Hispanic or Latino</li><li>text: Not Hispanic or Latino</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"A code classifying the person's sex assigned at birth  as specified by the [Office of the National Coordinator for Health IT (ONC)](https://www.healthit.gov/newsroom/about-onc). This extension aligns with the C-CDA Birth Sex Observation (LOINC 76689-9).\"><a href=\"http://hl7.org/fhir/us/core/STU3.1.1/StructureDefinition-us-core-birthsex.html\">US Core Birth Sex Extension:</a></td><td colspan=\"3\"><ul><li>F</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality.  The race codes used to represent these concepts are based upon the [CDC Race and Ethnicity Code Set Version 1.0](http://www.cdc.gov/phin/resources/vocabulary/index.html) which includes over 900 concepts for representing race and ethnicity of which 921 reference race.  The race concepts are grouped by and pre-mapped to the 5 OMB race categories:\n\n - American Indian or Alaska Native\n - Asian\n - Black or African American\n - Native Hawaiian or Other Pacific Islander\n - White.\">US Core Race Extension:</td><td colspan=\"3\"><ul><li>ombCategory: <a href=\"http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2106-3\">Race &amp; Ethnicity - CDC</a> 2106-3: White</li><li>text: White</li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex",
            "valueCode" : "F"
          },
          {
            "extension" : [
              {
                "url" : "ombCategory",
                "valueCoding" : {
                  "system" : "urn:oid:2.16.840.1.113883.6.238",
                  "code" : "2106-3",
                  "display" : "White"
                }
              },
              {
                "url" : "text",
                "valueString" : "White"
              }
            ],
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
          },
          {
            "extension" : [
              {
                "url" : "ombCategory",
                "valueCoding" : {
                  "system" : "urn:oid:2.16.840.1.113883.6.238",
                  "code" : "2186-5",
                  "display" : "Not Hispanic or Latino"
                }
              },
              {
                "url" : "text",
                "valueString" : "Not Hispanic or Latino"
              }
            ],
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
          }
        ],
        "identifier" : [
          {
            "use" : "usual",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR",
                  "display" : "Medical record number"
                }
              ]
            },
            "system" : "http://example.org/hospital-davinci",
            "value" : "12345"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "family" : "Everywoman",
            "given" : ["Eve"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1975-01-16",
        "deceasedBoolean" : false,
        "address" : [
          {
            "use" : "home",
            "line" : ["2222 Home Street"],
            "city" : "Ann Arbor",
            "state" : "MI",
            "postalCode" : "99999",
            "country" : "USA"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "M",
              "display" : "Married"
            }
          ]
        },
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "en-US",
                  "display" : "English (United States)"
                }
              ]
            },
            "preferred" : true
          }
        ]
      }
    }
  ]
}

```
